/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.search;

import org.codehaus.groovy.eclipse.core.search.ISearchRequestor;
import org.codehaus.groovy.eclipse.core.search.SyntheticAccessorSearchRequestor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.LocalVariableDeclarationMatch;
import org.eclipse.jdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.ui.search.JavaElementMatch;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;

public class SyntheticAccessorQueryParticipant
implements IQueryParticipant {
    SyntheticAccessorSearchRequestor accessorRequestor;

    public void search(org.eclipse.jdt.ui.search.ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        if (querySpecification instanceof ElementQuerySpecification) {
            this.accessorRequestor = new SyntheticAccessorSearchRequestor();
            IJavaElement element = ((ElementQuerySpecification)querySpecification).getElement();
            this.accessorRequestor.findSyntheticMatches(element, querySpecification.getLimitTo(), this.getSearchParticipants(), querySpecification.getScope(), (ISearchRequestor)new UISearchRequestor(requestor, element.getOpenable() instanceof GroovyCompilationUnit), monitor);
        }
    }

    private SearchParticipant[] getSearchParticipants() {
        return new SearchParticipant[]{new JavaSearchParticipant()};
    }

    public int estimateTicks(QuerySpecification specification) {
        if (!(specification instanceof ElementQuerySpecification)) {
            return 0;
        }
        return 3;
    }

    public IMatchPresentation getUIParticipant() {
        return new IMatchPresentation(){

            public ILabelProvider createLabelProvider() {
                return new JavaElementLabelProvider();
            }

            public void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
            }
        };
    }

    class UISearchRequestor
    implements ISearchRequestor {
        private final org.eclipse.jdt.ui.search.ISearchRequestor requestor;
        private final boolean targetIsGroovy;

        public UISearchRequestor(org.eclipse.jdt.ui.search.ISearchRequestor requestor, boolean targetIsGroovy) {
            this.requestor = requestor;
            this.targetIsGroovy = targetIsGroovy;
        }

        public void acceptMatch(SearchMatch match) {
            IJavaElement enclosingElement = (IJavaElement)match.getElement();
            if (enclosingElement != null) {
                if (!(enclosingElement.getOpenable() instanceof GroovyCompilationUnit) && !this.targetIsGroovy) {
                    return;
                }
                boolean isWriteAccess = false;
                boolean isReadAccess = false;
                if (match instanceof FieldReferenceMatch) {
                    FieldReferenceMatch fieldRef = (FieldReferenceMatch)match;
                    isWriteAccess = fieldRef.isWriteAccess();
                    isReadAccess = fieldRef.isReadAccess();
                } else if (match instanceof FieldDeclarationMatch) {
                    isWriteAccess = true;
                } else if (match instanceof LocalVariableReferenceMatch) {
                    LocalVariableReferenceMatch localVarRef = (LocalVariableReferenceMatch)match;
                    isWriteAccess = localVarRef.isWriteAccess();
                    isReadAccess = localVarRef.isReadAccess();
                } else if (match instanceof LocalVariableDeclarationMatch) {
                    isWriteAccess = true;
                }
                boolean isSuperInvocation = false;
                if (match instanceof MethodReferenceMatch) {
                    MethodReferenceMatch methodRef = (MethodReferenceMatch)match;
                    isSuperInvocation = methodRef.isSuperInvocation();
                }
                this.requestor.reportMatch(this.createJavaElementMatch(enclosingElement, match.getRule(), match.getOffset(), match.getLength(), match.getAccuracy(), isReadAccess, isWriteAccess, match.isInsideDocComment(), isSuperInvocation));
            }
        }

        private Match createJavaElementMatch(IJavaElement enclosingElement, int rule, int offset, int length, int accuracy, boolean isReadAccess, boolean isWriteAccess, boolean insideDocComment, boolean isSuperInvocation) {
            return (Match)ReflectionUtils.invokeConstructor(JavaElementMatch.class, (Class[])new Class[]{Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, (Object[])new Object[]{enclosingElement, rule, offset, length, accuracy, isReadAccess, isWriteAccess, insideDocComment, isSuperInvocation});
        }
    }
}

