/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.search;

import java.util.Collections;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.CodeSelectHelper;
import org.codehaus.groovy.eclipse.core.search.FindAllReferencesRequestor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyOccurrencesFinder
implements IOccurrencesFinder {
    public static final String ID = "GroovyOccurrencesFinder";
    public static final String IS_WRITEACCESS = "writeAccess";
    public static final String IS_VARIABLE = "variable";
    private GroovyCompilationUnit gunit;
    private CompilationUnit cunit;
    private AnnotatedNode nodeToLookFor;
    private String elementName;

    public CompilationUnit getASTRoot() {
        return this.cunit;
    }

    public String getElementName() {
        if (this.elementName == null) {
            this.elementName = this.internalGetElementName();
        }
        return this.elementName;
    }

    private String internalGetElementName() {
        if (this.nodeToLookFor instanceof ClassNode) {
            String name = ((ClassNode)this.nodeToLookFor).getNameWithoutPackage();
            int lastDollar = name.lastIndexOf(36);
            return name.substring(lastDollar + 1);
        }
        if (this.nodeToLookFor instanceof MethodNode) {
            return ((MethodNode)this.nodeToLookFor).getName();
        }
        if (this.nodeToLookFor instanceof FieldNode) {
            return ((FieldNode)this.nodeToLookFor).getName();
        }
        if (this.nodeToLookFor instanceof Variable) {
            return ((Variable)this.nodeToLookFor).getName();
        }
        return null;
    }

    public String getID() {
        return ID;
    }

    public String getJobLabel() {
        return "Search for Occurrences in File (Groovy)";
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        Map<org.codehaus.groovy.ast.ASTNode, Integer> occurences = this.internalFindOccurences();
        IOccurrencesFinder.OccurrenceLocation[] locations = new IOccurrencesFinder.OccurrenceLocation[occurences.size()];
        int i = 0;
        for (Map.Entry<org.codehaus.groovy.ast.ASTNode, Integer> entry : occurences.entrySet()) {
            IOccurrencesFinder.OccurrenceLocation occurrenceLocation;
            FieldNode c;
            org.codehaus.groovy.ast.ASTNode node = entry.getKey();
            int flag = entry.getValue();
            if (node instanceof FieldNode) {
                c = (FieldNode)node;
                occurrenceLocation = new IOccurrencesFinder.OccurrenceLocation(c.getNameStart(), c.getNameEnd() - c.getNameStart() + 1, flag, "Occurrence of ''" + this.getElementName() + "''");
            } else if (node instanceof MethodNode) {
                c = (MethodNode)node;
                occurrenceLocation = new IOccurrencesFinder.OccurrenceLocation(c.getNameStart(), c.getNameEnd() - c.getNameStart() + 1, flag, "Occurrence of ''" + this.getElementName() + "''");
            } else if (node instanceof Parameter) {
                c = (Parameter)node;
                int start = c.getNameStart();
                int length = c.getNameEnd() - c.getNameStart();
                occurrenceLocation = new IOccurrencesFinder.OccurrenceLocation(start, length, flag, "Occurrence of ''" + this.getElementName() + "''");
            } else if (node instanceof ClassNode && ((ClassNode)node).getNameEnd() > 0) {
                c = (ClassNode)node;
                occurrenceLocation = new IOccurrencesFinder.OccurrenceLocation(c.getNameStart(), c.getNameEnd() - c.getNameStart() + 1, flag, "Occurrence of ''" + this.getElementName() + "''");
            } else if (node instanceof StaticMethodCallExpression) {
                StaticMethodCallExpression smce = (StaticMethodCallExpression)node;
                occurrenceLocation = new IOccurrencesFinder.OccurrenceLocation(smce.getStart(), Math.min(smce.getLength(), smce.getMethod().length()), flag, "Occurrence of ''" + this.getElementName() + "''");
            } else {
                SourceRange range = this.getSourceRange(node);
                occurrenceLocation = new IOccurrencesFinder.OccurrenceLocation(range.getOffset(), range.getLength(), flag, "Occurrence of ''" + this.getElementName() + "''");
            }
            locations[i++] = occurrenceLocation;
        }
        return locations;
    }

    private SourceRange getSourceRange(org.codehaus.groovy.ast.ASTNode node) {
        int simpleNameStart;
        String name;
        String semiQualifiedName;
        if (node instanceof ConstructorCallExpression) {
            node = ((ConstructorCallExpression)node).getType();
        }
        if (node instanceof ClassNode && (semiQualifiedName = ((ClassNode)node).getNameWithoutPackage()).contains("$") && (name = this.getElementName()).length() < node.getLength() - 1 && (simpleNameStart = semiQualifiedName.indexOf(name)) >= 0) {
            return new SourceRange(node.getStart() + simpleNameStart, name.length());
        }
        return new SourceRange(node.getStart(), node.getLength());
    }

    private Map<org.codehaus.groovy.ast.ASTNode, Integer> internalFindOccurences() {
        if (!(this.nodeToLookFor == null || this.nodeToLookFor instanceof ConstantExpression || this.nodeToLookFor instanceof ClosureExpression || this.nodeToLookFor instanceof DeclarationExpression || this.nodeToLookFor instanceof BinaryExpression || this.nodeToLookFor instanceof MethodCallExpression)) {
            FindAllReferencesRequestor requestor = new FindAllReferencesRequestor(this.nodeToLookFor);
            TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(this.gunit);
            visitor.visitCompilationUnit((ITypeRequestor)requestor);
            Map occurences = requestor.getReferences();
            return occurences;
        }
        return Collections.emptyMap();
    }

    public int getSearchKind() {
        return 5;
    }

    public String getUnformattedPluralLabel() {
        return "''{0}'' - {1} occurrences in ''{2}''";
    }

    public String getUnformattedSingularLabel() {
        return "''{0}'' - 1 occurrence in ''{1}''";
    }

    public String initialize(CompilationUnit root, ASTNode node) {
        return this.initialize(root, node.getStartPosition(), node.getLength());
    }

    public String initialize(CompilationUnit root, int offset, int length) {
        ModuleNode moduleNode;
        this.cunit = root;
        if (this.gunit == null) {
            ITypeRoot typeRoot = this.cunit.getTypeRoot();
            if (!(typeRoot instanceof GroovyCompilationUnit)) {
                return "Can't find occurrenes...not a Groovy file.";
            }
            this.gunit = (GroovyCompilationUnit)typeRoot;
        }
        if ((moduleNode = this.gunit.getModuleNode()) == null) {
            return "Can't find occurrences...no module node.";
        }
        CodeSelectHelper helper = new CodeSelectHelper();
        org.codehaus.groovy.ast.ASTNode node = helper.selectASTNode(this.gunit, offset, length);
        if (!(node instanceof AnnotatedNode)) {
            return "Can't find occurrences...invalid selection";
        }
        if (node instanceof PropertyNode) {
            PropertyNode property = (PropertyNode)node;
            node = property.getField();
        }
        this.nodeToLookFor = (AnnotatedNode)node;
        return null;
    }

    public void setGroovyCompilationUnit(GroovyCompilationUnit gunit) {
        this.gunit = gunit;
    }

    public org.codehaus.groovy.ast.ASTNode getNodeToLookFor() {
        return this.nodeToLookFor;
    }
}

