/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.util.ArrayList;
import java.util.Map;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.actions.OrganizeGroovyImports;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.corext.util.TypeNameMatchCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSearch {
    public void searchForTypes(GroovyCompilationUnit unit, Map<String, OrganizeGroovyImports.UnresolvedTypeData> missingTypes) throws JavaModelException {
        char[][] allTypes = new char[missingTypes.size()][];
        int i = 0;
        for (String simpleName : missingTypes.keySet()) {
            allTypes[i++] = simpleName.toCharArray();
        }
        ArrayList typesFound = new ArrayList();
        TypeNameMatchCollector collector = new TypeNameMatchCollector(typesFound);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{unit.getJavaProject()});
        new SearchEngine().searchAllTypeNames(null, (char[][])allTypes, scope, (TypeNameMatchRequestor)collector, 3, null);
        for (TypeNameMatch match : typesFound) {
            OrganizeGroovyImports.UnresolvedTypeData data = missingTypes.get(match.getSimpleTypeName());
            if (data == null) {
                GroovyCore.logException((String)("GRECLIPSE-735: Match not found in missing types: " + match.getFullyQualifiedName()), (Throwable)new Exception());
                continue;
            }
            if (!this.isOfKind(match, data.isAnnotation)) continue;
            data.addInfo(match);
        }
    }

    protected boolean isOfKind(TypeNameMatch match, boolean isAnnotation) {
        boolean isCollectedByAnnotationCollector;
        boolean isRegularAnnotation = isAnnotation ? Flags.isAnnotation((int)match.getModifiers()) : true;
        boolean bl = isCollectedByAnnotationCollector = match.getType().getAnnotation("AnnotationCollector") != null;
        return isRegularAnnotation || isCollectedByAnnotationCollector;
    }
}

