/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyRefactoringAction;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyRenameLinkedMode;
import org.codehaus.groovy.eclipse.refactoring.actions.IRenameTarget;
import org.codehaus.groovy.eclipse.refactoring.core.rename.CandidateCollector;
import org.codehaus.groovy.eclipse.refactoring.core.rename.JavaRefactoringDispatcher;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameDispatcherAction
extends GroovyRefactoringAction {
    public void run(IAction action) {
        if (this.initRefactoring()) {
            ITextSelection selection = this.getSelection();
            GroovyCompilationUnit unit = this.getUnit();
            CandidateCollector dispatcher = new CandidateCollector(unit, selection);
            try {
                ISourceReference target = dispatcher.getRefactoringTarget();
                IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
                boolean lightweight = store.getBoolean("Refactor.lightweight");
                if (this.runViaAdapter(target, lightweight)) {
                    return;
                }
                if (target instanceof IMember || target instanceof ILocalVariable) {
                    if (lightweight && this.nameMatches(((IJavaElement)target).getElementName(), unit, selection)) {
                        new GroovyRenameLinkedMode((IJavaElement)target, this.getEditor()).start();
                    } else {
                        this.openJavaRefactoringWizard((IJavaElement)target);
                    }
                } else {
                    this.displayErrorDialog("Cannot refactor on current selection.  No refactoring candidates found");
                }
            }
            catch (CoreException e) {
                this.displayErrorDialog(e.getMessage());
            }
        }
    }

    private boolean nameMatches(String elementName, GroovyCompilationUnit unit, ITextSelection selection) {
        char[] selectedText;
        char[] contents = unit.getContents();
        int start = selection.getOffset();
        int end = start + selection.getLength();
        while (start >= contents.length || start >= 0 && Character.isJavaIdentifierPart(contents[start])) {
            --start;
        }
        if (start != 0 || !Character.isJavaIdentifierPart(contents[start])) {
            ++start;
        }
        while (end < contents.length && Character.isJavaIdentifierPart(contents[end])) {
            ++end;
        }
        if (end > contents.length) {
            --end;
        }
        return (selectedText = CharOperation.subarray((char[])contents, (int)start, (int)end)) != null && elementName.equals(String.valueOf(selectedText));
    }

    private boolean runViaAdapter(ISourceReference _target, boolean lightweight) {
        try {
            IRenameTarget target = RenameDispatcherAction.adapt(_target, IRenameTarget.class);
            if (target != null) {
                return target.performRenameAction(this.getShell(), (AbstractTextEditor)this.getEditor(), lightweight);
            }
        }
        catch (Exception e) {
            GroovyCore.logException((String)"", (Throwable)e);
        }
        return false;
    }

    public static <T> T adapt(Object target, Class<T> clazz) {
        if (target instanceof IAdaptable) {
            Object result = ((IAdaptable)target).getAdapter(clazz);
            return (T)result;
        }
        return null;
    }

    private void openJavaRefactoringWizard(IJavaElement element) throws CoreException {
        JavaRefactoringDispatcher dispatcher = new JavaRefactoringDispatcher(element);
        RenameSupport refactoring = dispatcher.dispatchJavaRenameRefactoring();
        Shell shell = this.getShell();
        refactoring.openDialog(shell);
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

