/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.text.Collator;
import java.util.Comparator;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.refactoring.actions.OrganizeGroovyImports;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.dialogs.MultiElementListSelectionDialog;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.TypeNameMatchLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;

public class OrganizeGroovyImportsAction
extends OrganizeImportsAction {
    private static final OrganizeImportComparator ORGANIZE_IMPORT_COMPARATOR = new OrganizeImportComparator();
    private JavaEditor editor;

    public OrganizeGroovyImportsAction(JavaEditor editor) {
        super(editor);
        this.editor = editor;
    }

    public void run(ICompilationUnit cu) {
        if (cu instanceof GroovyCompilationUnit) {
            try {
                IStatusLineManager manager;
                OrganizeGroovyImports action = new OrganizeGroovyImports((GroovyCompilationUnit)cu, this.createChooseImportQuery(this.editor));
                boolean success = action.calculateAndApplyMissingImports();
                if (!success && (manager = this.getStatusLineManager()) != null) {
                    manager.setErrorMessage(Messages.format((String)ActionMessages.OrganizeImportsAction_multi_error_parse, (Object)OrganizeGroovyImportsAction.getLocationString(cu)));
                }
            }
            catch (JavaModelException e) {
                GroovyPlugin.getDefault().logException("Error organizing imports for " + cu.getElementName(), (Exception)((Object)e));
            }
        } else {
            super.run(cu);
        }
    }

    private static String getLocationString(ICompilationUnit cu) {
        return BasicElementLabels.getPathLabel((IPath)cu.getPath(), (boolean)false);
    }

    private OrganizeImportsOperation.IChooseImportQuery createChooseImportQuery(final JavaEditor editor) {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                return OrganizeGroovyImportsAction.this.doChooseImports(openChoices, ranges, editor);
            }
        };
    }

    private TypeNameMatch[] doChooseImports(TypeNameMatch[][] openChoices, final ISourceRange[] ranges, final JavaEditor editor) {
        ISelection sel = editor.getSelectionProvider().getSelection();
        TypeNameMatch[] result = null;
        TypeNameMatchLabelProvider labelProvider = new TypeNameMatchLabelProvider(1);
        MultiElementListSelectionDialog dialog = new MultiElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                OrganizeGroovyImportsAction.this.doListSelectionChanged(this.getCurrentPage(), ranges, editor);
            }
        };
        dialog.setTitle(ActionMessages.OrganizeImportsAction_selectiondialog_title);
        dialog.setMessage(ActionMessages.OrganizeImportsAction_selectiondialog_message);
        dialog.setElements((Object[][])openChoices);
        dialog.setComparator((Comparator)ORGANIZE_IMPORT_COMPARATOR);
        if (dialog.open() == 0) {
            Object[] res = dialog.getResult();
            result = new TypeNameMatch[res.length];
            int i = 0;
            while (i < res.length) {
                Object[] array = (Object[])res[i];
                if (array.length > 0) {
                    result[i] = (TypeNameMatch)array[0];
                    QualifiedTypeNameHistory.remember((String)result[i].getFullyQualifiedName());
                }
                ++i;
            }
        }
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            editor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
        }
        return result;
    }

    private void doListSelectionChanged(int page, ISourceRange[] ranges, JavaEditor editor) {
        if (ranges != null && page >= 0 && page < ranges.length) {
            ISourceRange range = ranges[page];
            editor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    private IStatusLineManager getStatusLineManager() {
        if (this.editor != null) {
            try {
                return this.editor.getEditorSite().getActionBars().getStatusLineManager();
            }
            catch (NullPointerException nullPointerException) {}
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrganizeImportComparator
    implements Comparator<String> {
        private OrganizeImportComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int pos2;
            if (o1.equals(o2)) {
                return 0;
            }
            QualifiedTypeNameHistory history = QualifiedTypeNameHistory.getDefault();
            int pos1 = history.getPosition((Object)o1);
            if (pos1 == (pos2 = history.getPosition((Object)o2))) {
                return Collator.getInstance().compare(o1, o2);
            }
            if (pos1 > pos2) {
                return -1;
            }
            return 1;
        }
    }
}

