/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import groovy.transform.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.util.ArrayUtils;
import org.codehaus.groovy.eclipse.refactoring.actions.TypeSearch;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.core.search.JavaSearchTypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizeGroovyImports {
    private static final ClassNode CLASS_NODE_FIELD = ClassHelper.make(Field.class);
    private static final Pattern ALIASED_IMPORT = Pattern.compile("\\sas\\s");
    private static final Pattern STATIC_CONSTANT = Pattern.compile("[A-Z][A-Z0-9_]+");
    private OrganizeImportsOperation.IChooseImportQuery query;
    private final GroovyCompilationUnit unit;
    private Map<String, UnresolvedTypeData> missingTypes;
    private Map<String, ImportNode> importsSlatedForRemoval;
    private static final Set<String> DEFAULT_IMPORTS = new LinkedHashSet<String>();

    static {
        DEFAULT_IMPORTS.add("java.lang.");
        DEFAULT_IMPORTS.add("java.util.");
        DEFAULT_IMPORTS.add("java.io.");
        DEFAULT_IMPORTS.add("java.net.");
        DEFAULT_IMPORTS.add("groovy.lang.");
        DEFAULT_IMPORTS.add("groovy.util.");
        DEFAULT_IMPORTS.add("java.math.BigDecimal");
        DEFAULT_IMPORTS.add("java.math.BigInteger");
    }

    public OrganizeGroovyImports(GroovyCompilationUnit unit, OrganizeImportsOperation.IChooseImportQuery query) {
        this.unit = unit;
        this.query = query;
    }

    public boolean calculateAndApplyMissingImports() throws JavaModelException {
        TextEdit edit = this.calculateMissingImports();
        if (edit != null) {
            this.unit.applyTextEdit(edit, null);
            return true;
        }
        return false;
    }

    public TextEdit calculateMissingImports() {
        ModuleNodeMapper.ModuleNodeInfo info = this.unit.getModuleInfo(true);
        if (OrganizeGroovyImports.isEmpty(info.module) || OrganizeGroovyImports.isUnclean(info, this.unit)) {
            return null;
        }
        this.missingTypes = new HashMap<String, UnresolvedTypeData>();
        this.importsSlatedForRemoval = new HashMap<String, ImportNode>();
        try {
            TextEdit textEdit;
            List allImports = new ImportNodeCompatibilityWrapper(info.module).getAllImportNodes();
            ImportRewrite rewriter = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)this.unit, (!OrganizeGroovyImports.isSafeToReorganize(allImports) ? 1 : 0) != 0);
            for (ImportNode importNode : allImports) {
                if (importNode.isStar()) {
                    if (!importNode.isStatic()) {
                        rewriter.addImport(String.valueOf(importNode.getPackageName()) + "*");
                        continue;
                    }
                    rewriter.addStaticImport(importNode.getClassName().replace('$', '.'), "*", true);
                    continue;
                }
                String className = importNode.getClassName().replace('$', '.');
                if (!importNode.isStatic()) {
                    if (!OrganizeGroovyImports.isAliased(importNode)) {
                        rewriter.addImport(className);
                        this.importsSlatedForRemoval.put(className, importNode);
                        continue;
                    }
                    String alias = String.valueOf(className) + " as " + importNode.getAlias();
                    rewriter.addImport(alias);
                    this.importsSlatedForRemoval.put(alias, importNode);
                    continue;
                }
                if (!OrganizeGroovyImports.isAliased(importNode)) {
                    rewriter.addStaticImport(className, importNode.getFieldName(), true);
                    this.importsSlatedForRemoval.put(String.valueOf(className) + '.' + importNode.getFieldName(), importNode);
                    continue;
                }
                rewriter.addStaticImport(className, String.valueOf(importNode.getFieldName()) + " as " + importNode.getAlias(), true);
                this.importsSlatedForRemoval.put(String.valueOf(className) + '.' + importNode.getFieldName() + " as " + importNode.getAlias(), importNode);
            }
            for (ClassNode classNode : info.module.getClasses()) {
                FindUnresolvedReferencesVisitor visitor = new FindUnresolvedReferencesVisitor();
                visitor.visitClass(classNode);
            }
            for (ImportNode importNode : allImports) {
                String key;
                if (!OrganizeGroovyImports.isDefaultImport(importNode)) continue;
                if (importNode.getClassName() != null) {
                    key = importNode.getClassName();
                } else {
                    key = importNode.getPackageName();
                    if (key.endsWith(".")) {
                        key = String.valueOf(key) + "*";
                    }
                }
                this.importsSlatedForRemoval.put(key, importNode);
            }
            for (Map.Entry entry : this.importsSlatedForRemoval.entrySet()) {
                if (!((ImportNode)entry.getValue()).isStatic()) {
                    rewriter.removeImport((String)entry.getKey());
                    continue;
                }
                rewriter.removeStaticImport((String)entry.getKey());
            }
            if (!this.missingTypes.isEmpty()) {
                this.pruneMissingTypes(allImports);
                if (!this.missingTypes.isEmpty()) {
                    IType[] iTypeArray = this.resolveMissingTypes();
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType iType = iTypeArray[n2];
                        rewriter.addImport(iType.getFullyQualifiedName('.'));
                        ++n2;
                    }
                }
            }
            TextEdit textEdit2 = textEdit = rewriter.rewriteImports(null);
            return textEdit2;
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logException("Exception thrown when organizing imports for " + this.unit.getElementName(), e);
        }
        finally {
            this.importsSlatedForRemoval = null;
            this.missingTypes = null;
        }
        return null;
    }

    private void pruneMissingTypes(Iterable<ImportNode> imports) throws JavaModelException {
        LinkedHashSet<String> starImports = new LinkedHashSet<String>();
        LinkedHashSet<String> typeImports = new LinkedHashSet<String>();
        if (this.unit.getModuleNode().getPackageName() != null) {
            starImports.add(this.unit.getModuleNode().getPackageName());
        } else {
            starImports.add("");
        }
        for (ImportNode in : imports) {
            if (in.isStatic()) continue;
            if (in.isStar()) {
                starImports.add(in.getPackageName());
                continue;
            }
            typeImports.add(in.getText());
        }
        for (String di : DEFAULT_IMPORTS) {
            if (di.endsWith(".")) {
                starImports.add(di);
                continue;
            }
            typeImports.add(String.valueOf(di) + " as " + di.substring(di.lastIndexOf(46) + 1));
        }
        Iterator<String> it = this.missingTypes.keySet().iterator();
        block2: while (it.hasNext()) {
            String typeName = it.next();
            for (String ti : typeImports) {
                if (!ti.endsWith(String.valueOf(' ') + typeName)) continue;
                it.remove();
                continue block2;
            }
            for (String si : starImports) {
                IType type = this.unit.getJavaProject().findType(String.valueOf(si) + typeName, null);
                if (type == null) continue;
                it.remove();
                continue block2;
            }
        }
    }

    private IType[] resolveMissingTypes() throws JavaModelException {
        new TypeSearch().searchForTypes(this.unit, this.missingTypes);
        ArrayList<TypeNameMatch> missingTypesNoChoiceRequired = new ArrayList<TypeNameMatch>();
        ArrayList<TypeNameMatch[]> missingTypesChoiceRequired = new ArrayList<TypeNameMatch[]>();
        ArrayList<ISourceRange> ranges = new ArrayList<ISourceRange>();
        for (UnresolvedTypeData data : this.missingTypes.values()) {
            int foundInfosSize = data.foundInfos.size();
            if (foundInfosSize == 1) {
                missingTypesNoChoiceRequired.add(data.foundInfos.get(0));
                continue;
            }
            if (foundInfosSize <= 1) continue;
            missingTypesChoiceRequired.add(data.foundInfos.toArray(new TypeNameMatch[foundInfosSize]));
            ranges.add(data.range);
        }
        TypeNameMatch[][] missingTypesArr = (TypeNameMatch[][])missingTypesChoiceRequired.toArray((T[])new TypeNameMatch[0][]);
        TypeNameMatch[] chosen = missingTypesArr.length > 0 ? this.query.chooseImports(missingTypesArr, ranges.toArray(new ISourceRange[0])) : new TypeNameMatch[]{};
        if (chosen != null) {
            IType[] typeMatches = new IType[missingTypesNoChoiceRequired.size() + chosen.length];
            int cnt = 0;
            for (TypeNameMatch typeNameMatch : missingTypesNoChoiceRequired) {
                typeMatches[cnt++] = typeNameMatch.getType();
            }
            int i = 0;
            while (i < chosen.length) {
                typeMatches[cnt++] = ((JavaSearchTypeNameMatch)chosen[i]).getType();
                ++i;
            }
            return typeMatches;
        }
        return new IType[0];
    }

    private static boolean isSafeToReorganize(Iterable<ImportNode> allImports) {
        for (ImportNode imp : allImports) {
            if (imp.getAnnotations() == null || imp.getAnnotations().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isDefaultImport(ImportNode imp) {
        String pkg;
        if (imp.isStatic()) {
            return false;
        }
        if (imp.getType() != null && !imp.getType().getNameWithoutPackage().equals(imp.getAlias())) {
            return false;
        }
        if (imp.getType() != null) {
            pkg = imp.getType().getPackageName();
            pkg = pkg == null ? "." : String.valueOf(pkg) + ".";
            if (pkg.equals("java.math.")) {
                pkg = imp.getType().getName();
            }
        } else {
            pkg = imp.getPackageName();
            if (pkg == null) {
                pkg = ".";
            }
        }
        return DEFAULT_IMPORTS.contains(pkg);
    }

    private static boolean isAliased(ImportNode imp) {
        String alias = imp.getAlias();
        if (alias == null) {
            return false;
        }
        String fieldName = imp.getFieldName();
        if (fieldName != null) {
            return !fieldName.equals(alias);
        }
        String className = imp.getClassName();
        if (className != null) {
            boolean aliasIsSameAsClassName = className.endsWith(alias) && (className.length() == alias.length() || className.endsWith("." + alias) || className.endsWith("$" + alias));
            return !aliasIsSameAsClassName;
        }
        return false;
    }

    private static boolean isEmpty(ModuleNode node) {
        if (node == null || node.getClasses() == null || node.getClasses().isEmpty() && node.getImports().isEmpty()) {
            return true;
        }
        return !(node.getClasses().size() != 1 || !node.getImports().isEmpty() || !((ClassNode)node.getClasses().get(0)).isScript() || node.getStatementBlock() != null && !node.getStatementBlock().isEmpty() && !OrganizeGroovyImports.isNullReturn(node.getStatementBlock()) || node.getMethods() != null && !node.getMethods().isEmpty());
    }

    private static boolean isNullReturn(BlockStatement statementBlock) {
        ReturnStatement ret;
        List statements = statementBlock.getStatements();
        if (statements.size() == 1 && statements.get(0) instanceof ReturnStatement && (ret = (ReturnStatement)statements.get(0)).getExpression() instanceof ConstantExpression) {
            return ((ConstantExpression)ret.getExpression()).isNullExpression();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isUnclean(ModuleNodeMapper.ModuleNodeInfo info, GroovyCompilationUnit unit) {
        try {
            if (info.module.encounteredUnrecoverableError()) return true;
            if (!unit.isConsistent()) {
                return true;
            }
            CategorizedProblem[] problems = info.result.getProblems();
            if (problems == null) return false;
            if (problems.length <= 0) return false;
            CategorizedProblem[] categorizedProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (true) {
                String message;
                if (n2 >= n) {
                    return false;
                }
                CategorizedProblem problem = categorizedProblemArray[n2];
                if (problem.isError() && problem.getCategoryID() == 60 && (message = problem.getMessage()).contains("unexpected token")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return true;
        }
    }

    private class FindUnresolvedReferencesVisitor
    extends ClassCodeVisitorSupport {
        private ClassNode current;

        private FindUnresolvedReferencesVisitor() {
        }

        protected void visitAnnotation(AnnotationNode annotation) {
            if (annotation.getNodeMetaData((Object)"AnnotationCollector") == null) {
                this.handleType(annotation.getClassNode(), true);
            }
            super.visitAnnotation(annotation);
        }

        public void visitCastExpression(CastExpression expression) {
            this.handleType(expression.getType(), false);
            super.visitCastExpression(expression);
        }

        public void visitClassExpression(ClassExpression expression) {
            if (expression.getEnd() > 0) {
                this.handleType(expression.getType(), false);
            }
        }

        public void visitClosureExpression(ClosureExpression expression) {
            Parameter[] parameters = expression.getParameters();
            if (parameters != null) {
                Parameter[] parameterArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter param = parameterArray[n2];
                    this.handleType(param.getType(), false);
                    ++n2;
                }
            }
            super.visitClosureExpression(expression);
        }

        public void visitConstantExpression(ConstantExpression expression) {
            if (expression instanceof AnnotationConstantExpression) {
                this.handleType(expression.getType(), true);
            }
        }

        public void visitPropertyExpression(PropertyExpression expression) {
            String alias;
            if (!expression.isStatic() && !expression.isSynthetic() && (alias = (String)expression.getNodeMetaData((Object)"static.import.alias")) != null) {
                String staticImport = expression.getText().replace('$', '.');
                if (!alias.equals(expression.getPropertyAsString())) {
                    staticImport = String.valueOf(staticImport) + " as " + alias;
                }
                this.doNotRemoveImport(staticImport);
            }
            super.visitPropertyExpression(expression);
        }

        public void visitVariableExpression(VariableExpression expression) {
            if (expression.getAccessedVariable() == expression) {
                this.handleType(expression.getType(), false);
            }
            if ((expression.getAccessedVariable() instanceof DynamicVariable || expression.isDynamicTyped()) && !this.checkRetainImport(expression.getName())) {
                this.handleVariable(expression);
            }
        }

        public void visitMethodCallExpression(MethodCallExpression call) {
            if (!call.isSynthetic() && call.getStart() > 0) {
                if (call.isImplicitThis()) {
                    this.checkRetainImport(call.getMethodAsString());
                } else if (call.getGenericsTypes() != null) {
                    GenericsType[] genericsTypeArray = call.getGenericsTypes();
                    int n = genericsTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GenericsType type = genericsTypeArray[n2];
                        this.handleType(type.getType(), false);
                        ++n2;
                    }
                }
            }
            super.visitMethodCallExpression(call);
        }

        public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
            if (!call.isSynthetic() && call.getStart() > 0) {
                String method = String.valueOf(call.getOwnerType().getName().replace('$', '.')) + '.' + call.getMethod();
                String alias = (String)call.getNodeMetaData((Object)"static.import.alias");
                if (alias != null) {
                    method = String.valueOf(method) + " as " + alias;
                }
                this.doNotRemoveImport(method);
            }
            super.visitStaticMethodCallExpression(call);
        }

        public void visitConstructorCallExpression(ConstructorCallExpression call) {
            this.handleType(call.getType(), false);
            super.visitConstructorCallExpression(call);
        }

        public void visitConstructor(ConstructorNode node) {
            if (!node.isSynthetic()) {
                Parameter[] parameterArray = node.getParameters();
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter param = parameterArray[n2];
                    this.handleType(param.getType(), false);
                    ++n2;
                }
            }
            super.visitConstructor(node);
        }

        public void visitField(FieldNode node) {
            if (node.getEnd() > 0) {
                this.handleType(node.getType(), false);
                if (node.getOwner().isScript()) {
                    this.handleType(CLASS_NODE_FIELD, true);
                }
            }
            super.visitField(node);
        }

        public void visitMethod(MethodNode node) {
            if (!node.isSynthetic()) {
                this.handleType(node.getReturnType(), false);
                Parameter[] parameterArray = node.getParameters();
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter param = parameterArray[n2];
                    this.handleType(param.getType(), false);
                    ++n2;
                }
                ClassNode[] thrownExceptions = node.getExceptions();
                if (thrownExceptions != null) {
                    ClassNode[] classNodeArray = thrownExceptions;
                    int n3 = thrownExceptions.length;
                    n = 0;
                    while (n < n3) {
                        ClassNode thrownException = classNodeArray[n];
                        this.handleType(thrownException, false);
                        ++n;
                    }
                }
            }
            super.visitMethod(node);
        }

        public void visitClass(ClassNode node) {
            this.current = node;
            if (!node.isSynthetic()) {
                this.handleType(node.getSuperClass(), false);
                ClassNode[] classNodeArray = node.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode impls = classNodeArray[n2];
                    this.handleType(impls, false);
                    ++n2;
                }
                GenericsType[] generics = node.getUnresolvedSuperClass().getGenericsTypes();
                if (generics != null) {
                    GenericsType[] genericsTypeArray = generics;
                    int n3 = generics.length;
                    n = 0;
                    while (n < n3) {
                        GenericsType generic = genericsTypeArray[n];
                        this.handleType(generic.getType(), false);
                        ++n;
                    }
                }
            }
            super.visitClass(node);
        }

        public void visitCatchStatement(CatchStatement node) {
            this.handleType(node.getVariable().getType(), false);
            super.visitCatchStatement(node);
        }

        public void visitForLoop(ForStatement node) {
            Parameter parm = node.getVariable();
            ClassNode type = parm.getType();
            if (type.getStart() > 0 && type.getEnd() < parm.getStart()) {
                this.handleType(type, false);
            }
            super.visitForLoop(node);
        }

        private void handleVariable(VariableExpression expr) {
            String name = expr.getName();
            if (!OrganizeGroovyImports.this.missingTypes.containsKey(name) && Character.isUpperCase(name.charAt(0)) && !STATIC_CONSTANT.matcher(name).matches()) {
                OrganizeGroovyImports.this.missingTypes.put(name, new UnresolvedTypeData(name, false, (ISourceRange)new SourceRange(expr.getStart(), expr.getEnd() - expr.getStart())));
            }
        }

        private void handleType(ClassNode node, boolean isAnnotation) {
            if (this.getBaseType(node).isPrimitive()) {
                return;
            }
            GenericsType[] generics = node.getGenericsTypes();
            int start = node.getNameStart();
            int until = node.getNameEnd();
            if (until < 1) {
                start = node.getStart();
                until = node.getEnd() - 1;
                if (generics != null && generics.length > 0) {
                    if (generics[0].getStart() > 0) {
                        until = generics[0].getStart() - 1;
                    }
                } else if (node.isArray() && this.getBaseType(node).getEnd() > 0) {
                    assert (start <= this.getBaseType(node).getStart());
                    assert (until <= 0 || this.getBaseType(node).getEnd() < until);
                    start = this.getBaseType(node).getStart();
                    until = this.getBaseType(node).getEnd();
                }
            }
            int length = until - start;
            String name = this.getTypeName(node);
            if (node.isUsingGenerics() && generics != null && generics.length > 0) {
                GenericsType[] genericsTypeArray = generics;
                int n = generics.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericsType gt = genericsTypeArray[n2];
                    if (!gt.isPlaceholder() && !gt.isWildcard()) {
                        this.handleType(gt.getType(), false);
                    }
                    if (gt.getLowerBound() != null) {
                        this.handleType(gt.getLowerBound(), false);
                    } else if (gt.getUpperBounds() != null) {
                        ClassNode[] classNodeArray = gt.getUpperBounds();
                        int n3 = classNodeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ClassNode upper = classNodeArray[n4];
                            if (!upper.getName().equals(node.getName())) {
                                this.handleType(upper, false);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            if (!node.isResolved() && node.redirect() != this.current) {
                if (ALIASED_IMPORT.matcher(name).find()) {
                    this.doNotRemoveImport(name);
                    return;
                }
                Object[] parts = name.split("\\.");
                if (Character.isUpperCase(name.charAt(0))) {
                    name = parts[0];
                } else if (length < name.length()) {
                    this.doNotRemoveImport(name);
                    name = (String)ArrayUtils.lastElement((Object[])parts);
                }
                if (!OrganizeGroovyImports.this.missingTypes.containsKey(name)) {
                    SourceRange range = new SourceRange(node.getStart(), node.getEnd() - node.getStart());
                    OrganizeGroovyImports.this.missingTypes.put(name, new UnresolvedTypeData(name, isAnnotation, (ISourceRange)range));
                }
            } else if (length < name.length()) {
                String partialName = name.replace('$', '.');
                int innerIndex = name.lastIndexOf(36);
                while (innerIndex > -1) {
                    this.doNotRemoveImport(partialName);
                    partialName = partialName.substring(0, innerIndex);
                    innerIndex = name.lastIndexOf(36, innerIndex - 1);
                }
                this.doNotRemoveImport(partialName);
            } else if (length > name.length()) {
                GroovyPlugin.getDefault().logException(String.format("Expected a fully-qualified name for %s at [%d..%d] line %d, but source length (%d) > name length (%d)%n", name, start, until, node.getLineNumber(), length, name.length()), new Exception());
            }
        }

        private ClassNode getBaseType(ClassNode node) {
            while (node.isArray()) {
                node = node.getComponentType();
            }
            return node;
        }

        private String getTypeName(ClassNode node) {
            ClassNode type = this.getBaseType(node);
            if (!type.getName().matches(".*\\b" + type.getUnresolvedName())) {
                return String.valueOf(type.getName()) + " as " + type.getUnresolvedName();
            }
            return type.getName();
        }

        private boolean checkRetainImport(String name) {
            if (!(OrganizeGroovyImports.this.importsSlatedForRemoval.isEmpty() || "this".equals(name) || "super".equals(name))) {
                String suffix = String.valueOf('.') + name;
                for (Map.Entry entry : OrganizeGroovyImports.this.importsSlatedForRemoval.entrySet()) {
                    if (!((ImportNode)entry.getValue()).isStatic() || !((String)entry.getKey()).endsWith(suffix)) continue;
                    this.doNotRemoveImport((String)entry.getKey());
                    return true;
                }
            }
            return false;
        }

        private void doNotRemoveImport(String name) {
            OrganizeGroovyImports.this.importsSlatedForRemoval.remove(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnresolvedTypeData {
        final String ref;
        final boolean isAnnotation;
        final ISourceRange range;
        final List<TypeNameMatch> foundInfos = new LinkedList<TypeNameMatch>();

        public UnresolvedTypeData(String ref, boolean annotation, ISourceRange range) {
            this.ref = ref;
            this.isAnnotation = annotation;
            this.range = range;
        }

        public void addInfo(TypeNameMatch info) {
            int i = this.foundInfos.size() - 1;
            while (i >= 0) {
                TypeNameMatch curr = this.foundInfos.get(i);
                if (curr.getTypeContainerName().equals(info.getTypeContainerName())) {
                    return;
                }
                --i;
            }
            this.foundInfos.add(info);
        }

        public List<TypeNameMatch> getFoundInfos() {
            return this.foundInfos;
        }
    }
}

