/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.search.GroovyOccurrencesFinder;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameLinkedMode;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedNamesAssistProposal;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class GroovyRenameLinkedMode
extends RenameLinkedMode {
    private final GroovyEditor editor;

    public GroovyRenameLinkedMode(IJavaElement element, GroovyEditor editor) {
        super(element, (CompilationUnitEditor)editor);
        this.editor = editor;
    }

    public void start() {
        if (GroovyRenameLinkedMode.getActiveLinkedMode() != null) {
            GroovyRenameLinkedMode.getMyActiveLinkedMode().startFullDialog();
            return;
        }
        ISourceViewer viewer = this.editor.getViewer();
        IDocument document = viewer.getDocument();
        Point fOriginalSelection = viewer.getSelectedRange();
        this.setOriginalSelection(fOriginalSelection);
        int offset = fOriginalSelection.x;
        int length = fOriginalSelection.y;
        try {
            IUndoManager undoManager;
            if (viewer instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)viewer).getUndoManager()) instanceof IUndoManagerExtension) {
                IUndoManagerExtension undoManagerExtension = (IUndoManagerExtension)undoManager;
                IUndoContext undoContext = undoManagerExtension.getUndoContext();
                IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
                this.setStartingUndoOperation(operationHistory.getUndoOperation(undoContext));
            }
            LinkedPositionGroup fLinkedPositionGroup = new LinkedPositionGroup();
            this.setLinkedPositionGroup(fLinkedPositionGroup);
            GroovyOccurrencesFinder finder = new GroovyOccurrencesFinder();
            finder.setGroovyCompilationUnit(this.editor.getGroovyCompilationUnit());
            finder.initialize(null, offset, length);
            ASTNode nodeToLookFor = finder.getNodeToLookFor();
            if (nodeToLookFor == null) {
                return;
            }
            this.setOriginalName(finder.getElementName());
            final int pos = nodeToLookFor.getStart();
            IOccurrencesFinder.OccurrenceLocation[] occurrences = finder.getOccurrences();
            if (occurrences.length == 0) {
                return;
            }
            int nameLength = finder.getElementName().length();
            ArrayList<IOccurrencesFinder.OccurrenceLocation> newOccurrences = new ArrayList<IOccurrencesFinder.OccurrenceLocation>(occurrences.length);
            IOccurrencesFinder.OccurrenceLocation[] occurrenceLocationArray = occurrences;
            int n = occurrences.length;
            int n2 = 0;
            while (n2 < n) {
                IOccurrencesFinder.OccurrenceLocation occurrence = occurrenceLocationArray[n2];
                if (occurrence.getLength() == nameLength) {
                    newOccurrences.add(occurrence);
                }
                ++n2;
            }
            occurrences = newOccurrences.toArray(new IOccurrencesFinder.OccurrenceLocation[0]);
            Arrays.sort(occurrences, new Comparator<IOccurrencesFinder.OccurrenceLocation>(){

                @Override
                public int compare(IOccurrencesFinder.OccurrenceLocation o1, IOccurrencesFinder.OccurrenceLocation o2) {
                    return this.rank(o1) - this.rank(o2);
                }

                private int rank(IOccurrencesFinder.OccurrenceLocation o) {
                    int relativeRank = o.getOffset() + o.getLength() - pos;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            int i = 0;
            while (i < occurrences.length) {
                IOccurrencesFinder.OccurrenceLocation location = occurrences[i];
                LinkedPosition linkedPosition = new LinkedPosition(document, location.getOffset(), location.getLength(), i);
                if (i == 0) {
                    this.setNamePosition(linkedPosition);
                }
                fLinkedPositionGroup.addPosition(linkedPosition);
                ++i;
            }
            if (fLinkedPositionGroup.isEmpty()) {
                IStatusLineManager status = this.getStatusLineManager();
                if (status != null) {
                    status.setErrorMessage("No positions found.  Cannot do refactoring...");
                }
                return;
            }
            LinkedModeModel fLinkedModeModel = new LinkedModeModel();
            this.setLinkedModeModel(fLinkedModeModel);
            fLinkedModeModel.addGroup(fLinkedPositionGroup);
            fLinkedModeModel.forceInstall();
            fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer((JavaEditor)this.editor));
            fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorSynchronizer());
            EditorLinkedModeUI ui = new EditorLinkedModeUI(fLinkedModeModel, (ITextViewer)viewer);
            ui.setExitPosition((ITextViewer)viewer, offset, 0, Integer.MAX_VALUE);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(document));
            ui.enter();
            viewer.setSelectedRange(fOriginalSelection.x, fOriginalSelection.y);
            if (viewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
                registry.register(this.getFocusEditingSupport());
            }
            this.doOpenSecondaryPopup();
            this.setActiveLinkedMode(this);
        }
        catch (BadLocationException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private void setOriginalSelection(Point p) {
        ReflectionUtils.setPrivateField(RenameLinkedMode.class, (String)"fOriginalSelection", (Object)((Object)this), (Object)p);
    }

    private void setLinkedPositionGroup(LinkedPositionGroup group) {
        ReflectionUtils.setPrivateField(RenameLinkedMode.class, (String)"fLinkedPositionGroup", (Object)((Object)this), (Object)group);
    }

    private IEditingSupport getFocusEditingSupport() {
        return (IEditingSupport)ReflectionUtils.getPrivateField(RenameLinkedMode.class, (String)"fFocusEditingSupport", (Object)((Object)this));
    }

    private boolean getShowPreview() {
        return (Boolean)ReflectionUtils.getPrivateField(RenameLinkedMode.class, (String)"fShowPreview", (Object)((Object)this));
    }

    private IJavaElement getJavaElement() {
        return (IJavaElement)ReflectionUtils.getPrivateField(RenameLinkedMode.class, (String)"fJavaElement", (Object)((Object)this));
    }

    private static RenameLinkedMode getMyActiveLinkedMode() {
        return (RenameLinkedMode)ReflectionUtils.getPrivateField(RenameLinkedMode.class, (String)"fgActiveLinkedMode", null);
    }

    private void setShowPreview(boolean show) {
        ReflectionUtils.setPrivateField(RenameLinkedMode.class, (String)"fShowPreview", (Object)((Object)this), (Object)show);
    }

    private void setNamePosition(LinkedPosition pos) {
        ReflectionUtils.setPrivateField(RenameLinkedMode.class, (String)"fNamePosition", (Object)((Object)this), (Object)pos);
    }

    private void setStartingUndoOperation(IUndoableOperation op) {
        ReflectionUtils.setPrivateField(RenameLinkedMode.class, (String)"fStartingUndoOperation", (Object)((Object)this), (Object)op);
    }

    private void setLinkedModeModel(LinkedModeModel model) {
        ReflectionUtils.setPrivateField(RenameLinkedMode.class, (String)"fLinkedModeModel", (Object)((Object)this), (Object)model);
    }

    private void setOriginalName(String name) {
        ReflectionUtils.setPrivateField(RenameLinkedMode.class, (String)"fOriginalName", (Object)((Object)this), (Object)name);
    }

    private void setActiveLinkedMode(RenameLinkedMode active) {
        ReflectionUtils.setPrivateField(RenameLinkedMode.class, (String)"fgActiveLinkedMode", (Object)((Object)this), (Object)active);
    }

    private void doOpenSecondaryPopup() {
        ReflectionUtils.executeNoArgPrivateMethod(RenameLinkedMode.class, (String)"openSecondaryPopup", (Object)((Object)this));
    }

    private void doLinkedModeLeft() {
        ReflectionUtils.executeNoArgPrivateMethod(RenameLinkedMode.class, (String)"linkedModeLeft", (Object)((Object)this));
    }

    private void doDoRename(boolean showPreview) {
        ReflectionUtils.executePrivateMethod(RenameLinkedMode.class, (String)"doRename", (Class[])new Class[]{Boolean.TYPE}, (Object)((Object)this), (Object[])new Object[]{showPreview});
    }

    private IStatusLineManager getStatusLineManager() {
        if (this.editor != null) {
            try {
                return this.editor.getEditorSite().getActionBars().getStatusLineManager();
            }
            catch (NullPointerException nullPointerException) {}
        }
        return null;
    }

    private class EditorSynchronizer
    implements ILinkedModeListener {
        private EditorSynchronizer() {
        }

        public void left(LinkedModeModel model, int flags) {
            GroovyRenameLinkedMode.this.doLinkedModeLeft();
            if ((flags & 2) != 0 && GroovyRenameLinkedMode.this.getJavaElement().getElementType() != 14) {
                GroovyRenameLinkedMode.this.doDoRename(GroovyRenameLinkedMode.this.getShowPreview());
            }
        }

        public void resume(LinkedModeModel model, int flags) {
        }

        public void suspend(LinkedModeModel model) {
        }
    }

    private class ExitPolicy
    extends LinkedNamesAssistProposal.DeleteBlockingExitPolicy {
        public ExitPolicy(IDocument document) {
            super(document);
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            GroovyRenameLinkedMode.this.setShowPreview((event.stateMask & 0x40000) != 0 && (event.character == '\r' || event.character == '\n'));
            return super.doExit(model, event, offset, length);
        }
    }
}

