/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class GroovyRefactoringAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private GroovyEditor editor;
    private ITextSelection selection;
    private GroovyCompilationUnit gcu;

    protected boolean initRefactoring() {
        if (this.editor == null || this.selection == null || this.gcu == null) {
            return false;
        }
        if (this.gcu != null) {
            if (this.gcu.getModuleNode() == null) {
                this.displayErrorDialog("Cannot find ModuleNode for " + this.gcu.getElementName());
                return false;
            }
            return true;
        }
        return false;
    }

    protected void displayErrorDialog(String message) {
        ErrorDialog error = new ErrorDialog(this.editor.getSite().getShell(), "Groovy Refactoring error", message, (IStatus)new Status(4, "org.codehaus.groovy.eclipse.ui", message), 6);
        error.open();
    }

    public void dispose() {
        this.editor = null;
        this.gcu = null;
        this.selection = null;
    }

    protected GroovyEditor getEditor() {
        return this.editor;
    }

    protected ITextSelection getSelection() {
        return this.selection;
    }

    protected GroovyCompilationUnit getUnit() {
        return this.gcu;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.selection = (ITextSelection)selection;
            action.setEnabled(true);
        } else {
            this.selection = null;
            action.setEnabled(false);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof GroovyEditor) {
            this.editor = (GroovyEditor)targetEditor;
            this.gcu = this.editor.getGroovyCompilationUnit();
            action.setEnabled(true);
        } else {
            this.editor = null;
            this.gcu = null;
            action.setEnabled(false);
        }
    }

    public static int getUIFlags() {
        return 36;
    }
}

