/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.refactoring.actions.AbstractGroovyCleanUp;
import org.codehaus.groovy.eclipse.refactoring.actions.OrganizeGroovyImports;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.ImportsFix;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class GroovyImportsCleanUp
extends AbstractGroovyCleanUp {
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        ICompilationUnit unit = context.getCompilationUnit();
        if (!(unit instanceof GroovyCompilationUnit)) {
            return null;
        }
        final boolean[] hasAmbiguity = new boolean[1];
        OrganizeImportsOperation.IChooseImportQuery query = new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                hasAmbiguity[0] = true;
                return new TypeNameMatch[0];
            }
        };
        OrganizeGroovyImports op = new OrganizeGroovyImports((GroovyCompilationUnit)unit, query);
        TextEdit edit = op.calculateMissingImports();
        if (this.status == null) {
            this.status = new RefactoringStatus();
        }
        if (hasAmbiguity[0]) {
            this.status.addInfo(Messages.format((String)ActionMessages.OrganizeImportsAction_multi_error_unresolvable, (Object)GroovyImportsCleanUp.getLocationString(unit)));
        } else if (edit == null) {
            this.status.addInfo(Messages.format((String)ActionMessages.OrganizeImportsAction_multi_error_parse, (Object)GroovyImportsCleanUp.getLocationString(unit)));
        }
        if (edit == null || edit instanceof MultiTextEdit && edit.getChildrenSize() == 0) {
            return null;
        }
        return new ImportsFix(edit, unit, FixMessages.ImportsFix_OrganizeImports_Description);
    }

    public String[] getStepDescriptions() {
        return new String[]{MultiFixMessages.ImportsCleanUp_OrganizeImports_Description};
    }

    private static String getLocationString(ICompilationUnit unit) {
        return BasicElementLabels.getPathLabel((IPath)unit.getPath(), (boolean)false);
    }
}

