/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyCodeFormatCleanUp;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.CleanUpAction;
import org.eclipse.jdt.internal.ui.actions.MultiFormatAction;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class FormatAllGroovyAction
extends FormatAllAction {
    public FormatAllGroovyAction(IWorkbenchSite site, FormatKind kind) {
        super(site);
        ReflectionUtils.setPrivateField(FormatAllAction.class, (String)"fCleanUpDelegate", (Object)((Object)this), (Object)((Object)new GroovyMultiFormatAction(site, kind)));
        if (kind == FormatKind.INDENT_ONLY) {
            this.setText("Indent");
            this.setToolTipText("Indent Groovy file");
            this.setDescription("Indent Groovy file");
        } else if (kind == FormatKind.FORMAT) {
            this.setToolTipText(this.getToolTipText().replace("Java", "Groovy"));
            this.setDescription(this.getDescription().replace("Java", "Groovy"));
        }
    }

    public void run(ITextSelection selection) {
        GroovyCompilationUnit unit;
        IWorkbenchPart part;
        if (this.getSite() instanceof IEditorSite && (part = ((IEditorSite)this.getSite()).getPart()) instanceof GroovyEditor && (unit = (GroovyCompilationUnit)part.getAdapter(GroovyCompilationUnit.class)) != null) {
            super.run((IStructuredSelection)new StructuredSelection((Object)unit));
        }
    }

    public static class GroovyMultiFormatAction
    extends MultiFormatAction {
        final FormatKind kind;

        public GroovyMultiFormatAction(IWorkbenchSite site, FormatKind kind) {
            super(site);
            this.kind = kind;
        }

        private void showUnexpectedError(CoreException e) {
            String message2 = Messages.format((String)ActionMessages.CleanUpAction_UnexpectedErrorMessage, (Object)e.getStatus().getMessage());
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, message2, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getActionName(), null, (IStatus)status);
        }

        private void run(ICompilationUnit cu) {
            block5: {
                if (cu.isReadOnly()) {
                    return;
                }
                ICleanUp[] cleanUps = this.getCleanUps(new ICompilationUnit[]{cu});
                if (cleanUps == null) {
                    return;
                }
                if (!ElementValidator.check((IJavaElement)cu, (Shell)this.getShell(), (String)this.getActionName(), (boolean)true)) {
                    return;
                }
                try {
                    this.performRefactoring(new ICompilationUnit[]{cu}, cleanUps);
                }
                catch (InvocationTargetException e) {
                    JavaPlugin.log((Throwable)e);
                    if (!(e.getCause() instanceof CoreException)) break block5;
                    this.showUnexpectedError((CoreException)e.getCause());
                }
            }
        }

        public void run(IStructuredSelection selection) {
            ICompilationUnit[] cus = this.getCompilationUnits(selection);
            if (cus.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getActionName(), (String)ActionMessages.CleanUpAction_EmptySelection_description);
            } else if (cus.length == 1) {
                this.run(cus[0]);
            } else {
                ReflectionUtils.executePrivateMethod(CleanUpAction.class, (String)"runOnMultuple", (Class[])new Class[]{ICompilationUnit.class}, (Object)((Object)this), (Object[])new Object[]{cus});
            }
        }

        protected ICleanUp[] getCleanUps(ICompilationUnit[] units) {
            Hashtable<String, String> settings = new Hashtable<String, String>();
            settings.put("cleanup.format_source_code", "true");
            return new ICleanUp[]{new GroovyCodeFormatCleanUp(this.kind)};
        }
    }
}

