/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.groovy.core.Activator;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFolderSelectorPreferences {
    private static final ImageDescriptor DESCRIPTOR = JavaPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB;
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_CHECKALL = 3;
    private static final int IDX_UNCHECKALL = 4;
    private static final String[] buttonLabels = new String[]{"Add", "Edit", "Remove", "Check all", "Uncheck all"};
    private final Composite parent;
    private CheckedListDialogField patternList;
    private BooleanFieldEditor disableButton;
    private final IEclipsePreferences preferences;
    private final IPreferenceStore store;
    private IProject project;
    private boolean hasChanges = false;

    public ScriptFolderSelectorPreferences(Composite parent, IEclipsePreferences preferences, IPreferenceStore store, IProject project) {
        this.parent = parent;
        this.preferences = preferences;
        this.store = store;
        this.project = project;
    }

    public ListDialogField createListContents() {
        Label label = new Label(this.parent, 64);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText("Groovy Script Folders:");
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Composite inner = new Composite(this.parent, 2048);
        inner.setFont(this.parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.numColumns = 1;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.disableButton = new BooleanFieldEditor("groovy.script.filters.enabled", "Enable script folder support", 0, inner);
        this.disableButton.setPreferenceStore(this.store);
        this.disableButton.load();
        final Composite innerInner = new Composite(inner, 0);
        innerInner.setFont(this.parent.getFont());
        layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.numColumns = 3;
        innerInner.setLayout((Layout)layout);
        innerInner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        innerInner.setToolTipText("CHECKED boxes are COPIED to output folder.\nUNCHECKED boxes are NOT copied.");
        boolean enabled = this.disableButton.getBooleanValue();
        innerInner.setEnabled(enabled);
        this.disableButton.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object o;
                if (event.getProperty() == "field_editor_value" && (o = event.getNewValue()) instanceof Boolean) {
                    boolean enabled = (Boolean)o;
                    innerInner.setEnabled(enabled);
                    Control[] controlArray = innerInner.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        c.setEnabled(enabled);
                        ++n2;
                    }
                }
                ScriptFolderSelectorPreferences.this.hasChanges = true;
            }
        });
        ScriptPatternAdapter adapter = new ScriptPatternAdapter();
        this.patternList = new CheckedListDialogField((IListAdapter)adapter, buttonLabels, (ILabelProvider)new ScriptLabelProvider(DESCRIPTOR));
        this.patternList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.patternList.setLabelText("Groovy files that match these patterns are treated as scripts.  They will not be compiled and will be copied as-is to the output folder.\n\nCHECKED boxes will be COPIED to the output folder.  UNCHECKED boxes are NOT copied to the output folder.");
        this.patternList.setRemoveButtonIndex(2);
        this.patternList.enableButton(1, false);
        this.patternList.setCheckAllButtonIndex(3);
        this.patternList.setUncheckAllButtonIndex(4);
        this.patternList.doFillIntoGrid(innerInner, 3);
        Label l = this.patternList.getLabelControl(innerInner);
        GridData gd = new GridData(4, 128, true, false);
        gd.widthHint = 200;
        l.setLayoutData((Object)gd);
        this.resetElements();
        this.patternList.enableButton(0, true);
        this.patternList.setViewerComparator(new ViewerComparator());
        innerInner.setEnabled(enabled);
        Control[] controlArray = innerInner.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(enabled);
            ++n2;
        }
        return this.patternList;
    }

    private List<String> findPatterns() {
        return Activator.getDefault().getListStringPreference(this.preferences, "groovy.script.filters", "**/*.dsld,y,scripts/**/*.groovy,y,src/main/resources/**/*.groovy,y,src/test/resources/**/*.groovy,y");
    }

    protected void doCustomButtonPressed(ListDialogField field, int index) {
        if (index == 0) {
            this.addEntry(field);
        } else if (index == 1) {
            this.editEntry((ListDialogField<String>)field);
        }
    }

    protected void doSelectionChanged(ListDialogField field) {
        List selected = field.getSelectedElements();
        field.enableButton(1, this.canEdit(selected));
    }

    protected void doDoubleClicked(ListDialogField field) {
        this.editEntry((ListDialogField<String>)field);
    }

    private boolean canEdit(List<String> selected) {
        return selected.size() == 1;
    }

    private void addEntry(ListDialogField field) {
        InputDialog dialog = this.createInputDialog("");
        if (dialog.open() == 0) {
            field.addElement((Object)dialog.getValue());
        }
    }

    private InputDialog createInputDialog(String initial) {
        InputDialog dialog = new InputDialog(this.parent.getShell(), "Add script folder", "Enter a pattern for denoting script files in Groovy projects. Allowed wildcards are '*', '?' and '**'. Examples: 'java/util/A*.java', 'java/util/', '**/Test*'.  All patterns are relative to the current project.", initial, null);
        return dialog;
    }

    private void editEntry(ListDialogField<String> field) {
        List selElements = field.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        String entry = (String)selElements.get(0);
        InputDialog dialog = this.createInputDialog(entry);
        if (dialog.open() == 0) {
            field.replaceElement((Object)entry, (Object)dialog.getValue());
        }
    }

    public void applyPreferences() {
        if (!this.hasChanges) {
            return;
        }
        this.hasChanges = false;
        this.disableButton.store();
        List elts = this.patternList.getElements();
        ArrayList<String> result = new ArrayList<String>(elts.size() * 2);
        for (String elt : elts) {
            result.add(elt);
            result.add(this.patternList.isChecked((Object)elt) ? "y" : "n");
        }
        Activator.getDefault().setPreference(this.preferences, "groovy.script.filters", result);
        boolean yesNo = MessageDialog.openQuestion((Shell)this.parent.getShell(), (String)"Do full build?", (String)"Script folder preferences have changed.\nMust do a full build before they come completely into effect.  Do you want to do a full build now?");
        if (yesNo) {
            if (this.project != null) {
                new BuildJob(this.project).schedule();
            } else {
                new BuildJob(GroovyNature.getAllAccessibleGroovyProjects().toArray(new IProject[0])).schedule();
            }
        }
    }

    public void restoreDefaultsPressed() {
        this.disableButton.loadDefault();
        Activator.getDefault().setPreference(this.preferences, "groovy.script.filters", "**/*.dsld,y,scripts/**/*.groovy,y,src/main/resources/**/*.groovy,y,src/test/resources/**/*.groovy,y");
        this.resetElements();
    }

    private void resetElements() {
        List<String> elements = this.findPatterns();
        ArrayList<String> filteredElements = new ArrayList<String>(elements.size() / 2);
        ArrayList<String> checkedElements = new ArrayList<String>(elements.size() / 2);
        Iterator<String> eltIter = elements.iterator();
        while (eltIter.hasNext()) {
            String doCopy;
            String elt = eltIter.next();
            filteredElements.add(elt);
            if (!eltIter.hasNext() || !(doCopy = eltIter.next()).equals("y")) continue;
            checkedElements.add(elt);
        }
        this.patternList.setElements(filteredElements);
        this.patternList.setCheckedElements(checkedElements);
        this.patternList.selectFirstElement();
        this.hasChanges = false;
    }

    private static class BuildJob
    extends Job {
        private IProject[] projects;

        public BuildJob(IProject ... projects) {
            super(BuildJob.getName(projects));
            this.projects = projects;
        }

        private static String getName(IProject ... projects) {
            if (projects.length == 1) {
                return "Building proiject " + projects[0].getName();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Building proijects ");
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                sb.append(String.valueOf(project.getName()) + " ");
                ++n2;
            }
            return sb.toString();
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.projects.length);
                IProject[] iProjectArray = this.projects;
                int n = this.projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    project.build(6, (IProgressMonitor)sub);
                    sub.worked(1);
                    ++n2;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (CoreException e) {
                GroovyCore.logException((String)"Error building groovy project", (Throwable)e);
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }

    private static class ScriptLabelProvider
    extends LabelProvider {
        private Image fElementImage;

        public ScriptLabelProvider(ImageDescriptor descriptor) {
            ImageDescriptorRegistry registry = JavaPlugin.getImageDescriptorRegistry();
            this.fElementImage = registry.get(descriptor);
        }

        public Image getImage(Object element) {
            return this.fElementImage;
        }

        public String getText(Object element) {
            return BasicElementLabels.getFilePattern((String)((String)element));
        }
    }

    private class ScriptPatternAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ScriptPatternAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            ScriptFolderSelectorPreferences.this.doCustomButtonPressed(field, index);
            ScriptFolderSelectorPreferences.this.hasChanges = true;
        }

        public void selectionChanged(ListDialogField field) {
            ScriptFolderSelectorPreferences.this.doSelectionChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
            ScriptFolderSelectorPreferences.this.doDoubleClicked(field);
            ScriptFolderSelectorPreferences.this.hasChanges = true;
        }

        public void dialogFieldChanged(DialogField field) {
            ScriptFolderSelectorPreferences.this.hasChanges = true;
        }
    }
}

