/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.builder.ConvertLegacyProject;
import org.codehaus.groovy.eclipse.preferences.FieldEditorOverlayPage;
import org.codehaus.groovy.eclipse.preferences.PreferenceInitializer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GroovyPreferencePage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    public GroovyPreferencePage() {
        super(1);
        this.setPreferenceStore(GroovyPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected String getPageId() {
        return "org.codehaus.groovy.eclipse.preferences";
    }

    protected void createFieldEditors() {
        MonospaceFieldEditor monospaceEditor = new MonospaceFieldEditor();
        monospaceEditor.setPreferenceStore(this.getPreferenceStore());
        monospaceEditor.setEnabled(true, this.getFieldEditorParent());
        this.addField((FieldEditor)monospaceEditor);
        Label monoLabel = new Label(this.getFieldEditorParent(), 16448);
        monoLabel.setText("This option is particularly useful for testing frameworks\nthat use a formatted output such as Spock\n\n");
        Label contentAssistLabel = new Label(this.getFieldEditorParent(), 16448);
        contentAssistLabel.setText("\n\nGroovy Content assist options to make your content assist Groovier.");
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.contentassist.noparens.around.closures", "Do not use parens around methods with arguments", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.contentassist.brackets", "Use brackets for closure arguments", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.contentassist.namedarguments", "Use named arguments for method calls", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.contentassist.parameterguessing", "Try to guess the most likely parameters to use for method invocations\n(if unchecked, then the argument name is used instead)", this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor("groovy.scripts.workingdir", "\nDefault working directory for running Groovy scripts \n(will not change the working directory of existing scripts,\nonly new ones).", 1, (String[][])new String[][]{{"Project home", "proj_home"}, {"Script location", "script_loc"}, {"Eclipse home", "eclipse_home"}}, this.getFieldEditorParent()));
        ConvertLegacyProject convert = new ConvertLegacyProject();
        IProject[] oldProjects = convert.getAllOldProjects();
        if (oldProjects.length > 0) {
            Label l = new Label(this.getFieldEditorParent(), 16448);
            l.setText("The following legacy groovy projects exist in the workspace:\n");
            final List oldProjectsList = new List(this.getFieldEditorParent(), 514);
            this.populateProjectsList(oldProjectsList, oldProjects);
            l = new Label(this.getFieldEditorParent(), 16448);
            l.setText("Select the projects to convert.");
            Button convertButton = new Button(this.getFieldEditorParent(), 8);
            convertButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            convertButton.setText("Convert");
            convertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GroovyPreferencePage.this.convertSelectedProjects(oldProjectsList.getSelection());
                    GroovyPreferencePage.this.populateProjectsList(oldProjectsList, new ConvertLegacyProject().getAllOldProjects());
                }
            });
        }
    }

    private void populateProjectsList(List oldProjectsList, IProject[] oldProjects) {
        String[] projNames = new String[oldProjects.length];
        int i = 0;
        while (i < oldProjects.length) {
            projNames[i] = oldProjects[i].getName();
            ++i;
        }
        oldProjectsList.setItems(projNames);
    }

    protected void convertSelectedProjects(String[] selection) {
        if (selection.length == 0) {
            return;
        }
        IProject[] toConvert = new IProject[selection.length];
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < toConvert.length) {
            toConvert[i] = root.getProject(selection[i]);
            ++i;
        }
        try {
            new ConvertLegacyProject().convertProjects(toConvert);
            StringBuffer sb = new StringBuffer();
            sb.append("The following projects have been converted:\n");
            String[] stringArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                String projName = stringArray[n2];
                sb.append(String.valueOf(projName) + "\n");
                ++n2;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Successful conversion", (String)sb.toString());
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Failure when converting legacy projects", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error converting projects", (String)"There has been an error converting the projects.  See the error log.");
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        new PreferenceInitializer().reset();
    }

    private final class MonospaceFieldEditor
    extends BooleanFieldEditor {
        Label myLabel;

        private MonospaceFieldEditor() {
            super("groovy.junit.monospace.font", "&Use monospace font for JUnit (deprecated)", GroovyPreferencePage.this.getFieldEditorParent());
        }

        public Label getLabelControl(Composite parent) {
            if (this.myLabel == null) {
                this.myLabel = new Label(parent, 16448);
                this.myLabel.setFont(parent.getFont());
                String text = this.getLabelText();
                if (text != null) {
                    this.myLabel.setText(text);
                }
                this.myLabel.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        MonospaceFieldEditor.this.myLabel = null;
                    }
                });
            } else {
                this.checkParent((Control)this.myLabel, parent);
            }
            return this.myLabel;
        }

        protected Label getLabelControl() {
            return this.myLabel;
        }
    }
}

