/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.editor.GroovyColorManager;
import org.codehaus.groovy.eclipse.preferences.FieldEditorOverlayPage;
import org.codehaus.groovy.eclipse.preferences.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class GroovyEditorPreferencesPage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    public GroovyEditorPreferencesPage() {
        super(1);
        this.setPreferenceStore(GroovyPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        final ColorFieldEditor gjdkEditor = this.createColorEditor("groovy.editor.highlight.gjdk.color", "GroovyEditorPreferencesPage.GJDK_method_color");
        final ColorFieldEditor gKeywordEditor = this.createColorEditor("groovy.editor.highlight.groovykeywords.color", "GroovyEditorPreferencesPage.Groovy_keyword_color");
        final ColorFieldEditor javaTypesEditor = this.createColorEditor("groovy.editor.highlight.javatypes.color", "GroovyEditorPreferencesPage.Java_types_color");
        final ColorFieldEditor javaKeywordEditor = this.createColorEditor("groovy.editor.highlight.javakeywords.color", "GroovyEditorPreferencesPage.Java_keyword_color");
        final ColorFieldEditor returnEditor = this.createColorEditor("groovy.editor.highlight.return.color", "GroovyEditorPreferencesPage.Return_color");
        final ColorFieldEditor stringEditor = this.createColorEditor("groovy.editor.highlight.strings.color", "GroovyEditorPreferencesPage.String_color");
        final ColorFieldEditor annotationEditor = this.createColorEditor("groovy.editor.highlight.annotation.color", "GroovyEditorPreferencesPage.Annotation_color");
        final ColorFieldEditor bracketEditor = this.createColorEditor("groovy.editor.highlight.bracket.color", "GroovyEditorPreferencesPage.Bracket_color");
        final ColorFieldEditor operatorEditor = this.createColorEditor("groovy.editor.highlight.operator.color", "GroovyEditorPreferencesPage.Operator_color");
        final ColorFieldEditor defaultEditor = this.createColorEditor("groovy.editor.highlight.default.color", "GroovyEditorPreferencesPage.Groovy_Default_color");
        Label l = new Label(this.getFieldEditorParent(), 0);
        l.setText("\n\n" + Messages.getString("GroovyEditorPreferencesPage.SemanticHighlightingPrefs"));
        Composite c = new Composite(this.getFieldEditorParent(), 2048);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new FillLayout(512));
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.semantic.highlighting", Messages.getString("GroovyEditorPreferencesPage.SemanticHighlightingToggle"), c));
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.editor.highlight.slashy", Messages.getString("GroovyEditorPreferencesPage.DollarSlashyHighlightingToggle"), c));
        PreferenceLinkArea area = new PreferenceLinkArea(c, 64, "org.eclipse.jdt.ui.preferences.JavaEditorColoringPreferencePage", "\n" + Messages.getString("GroovyEditorPreferencesPage.InheritedJavaColorsDescription"), (IWorkbenchPreferenceContainer)this.getContainer(), null);
        area.getControl().setLayoutData((Object)gd);
        Composite parent = this.getFieldEditorParent();
        Button javaColorButton = new Button(parent, 524288);
        javaColorButton.setText(Messages.getString("GroovyEditorPreferencesPage.Copy_Java_Color_Preferences"));
        javaColorButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
                RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_keyword");
                gjdkEditor.getColorSelector().setColorValue(rgb);
                gKeywordEditor.getColorSelector().setColorValue(rgb);
                javaTypesEditor.getColorSelector().setColorValue(rgb);
                javaKeywordEditor.getColorSelector().setColorValue(rgb);
                rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_string");
                stringEditor.getColorSelector().setColorValue(rgb);
                rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_bracket");
                bracketEditor.getColorSelector().setColorValue(rgb);
                rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_operator");
                operatorEditor.getColorSelector().setColorValue(rgb);
                rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_annotation");
                annotationEditor.getColorSelector().setColorValue(rgb);
                rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_keyword_return");
                returnEditor.getColorSelector().setColorValue(rgb);
                rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_default");
                defaultEditor.getColorSelector().setColorValue(rgb);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private ColorFieldEditor createColorEditor(String preference, String nls) {
        Composite parent = this.getFieldEditorParent();
        this.addField(new SpacerFieldEditor(parent));
        ColorFieldEditor colorFieldEditor = new ColorFieldEditor(preference, Messages.getString(nls), parent);
        this.addField((FieldEditor)colorFieldEditor);
        this.addField((FieldEditor)new BooleanFieldEditor(String.valueOf(preference) + "_bold", Messages.getString("GroovyEditorPreferencesPage.BoldToggle"), 1, this.getFieldEditorParent()));
        return colorFieldEditor;
    }

    public void init(IWorkbench workbench) {
    }

    protected String getPageId() {
        return "org.codehaus.groovy.eclipse.preferences.editor";
    }

    public boolean performOk() {
        boolean success = super.performOk();
        if (success) {
            GroovyColorManager colorManager = GroovyPlugin.getDefault().getTextTools().getColorManager();
            colorManager.uninitialize();
            colorManager.initialize();
        }
        return success;
    }

    class SpacerFieldEditor
    extends FieldEditor {
        private Label spacer;

        public SpacerFieldEditor(Composite parent) {
            this.spacer = new Label(parent, 0);
            GridData gd = new GridData();
            this.spacer.setLayoutData((Object)gd);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.spacer.getLayoutData()).horizontalSpan = numColumns;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns;
            this.spacer.setLayoutData((Object)gd);
        }

        protected void doLoad() {
        }

        public void store() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }

        public int getNumberOfControls() {
            return 0;
        }
    }
}

