/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import java.util.SortedSet;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.codehaus.groovy.eclipse.core.builder.GroovyClasspathContainerInitializer;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.preferences.CompilerSwitchUIHelper;
import org.codehaus.groovy.eclipse.preferences.ScriptFolderSelectorPreferences;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class CompilerPreferencesPage
extends PropertyAndPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PROPERTY_ID = "org.codehaus.groovy.eclipse.preferences.compiler.project";
    public static final String PREFERENCES_ID = "org.codehaus.groovy.eclipse.preferences.compiler";
    protected final SpecifiedVersion activeGroovyVersion = CompilerUtils.getActiveGroovyVersion();
    protected SpecifiedVersion currentProjectVersion;
    private Button groovyLibButt;
    private ScriptFolderSelectorPreferences scriptFolderSelector;
    private IEclipsePreferences preferences;
    private ComboViewer compilerCombo;
    private Button doCheckForCompilerMismatch;

    protected IPreferenceStore doGetPreferenceStore() {
        IProject project = this.getProject();
        Object scope = project == null ? InstanceScope.INSTANCE : new ProjectScope(project);
        this.preferences = scope.getNode("org.eclipse.jdt.groovy.core");
        ScopedPreferenceStore store = new ScopedPreferenceStore(scope, "org.eclipse.jdt.groovy.core");
        return store;
    }

    public IEclipsePreferences getPreferences() {
        if (this.preferences == null) {
            this.doGetPreferenceStore();
        }
        return this.preferences;
    }

    protected Label createDescriptionLabel(Composite parent) {
        if (this.isProjectPreferencePage()) {
            Composite body = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            body.setLayout((Layout)layout);
            body.setFont(parent.getFont());
            GridData data = new GridData(4, 4, true, true);
            body.setLayoutData((Object)data);
            this.createProjectCompilerSection(body);
        }
        return super.createDescriptionLabel(parent);
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        page.setLayout((Layout)layout);
        page.setFont(parent.getFont());
        if (this.getElement() == null) {
            this.createWorkspaceCompilerSection(page);
        }
        this.scriptFolderSelector = new ScriptFolderSelectorPreferences(page, this.getPreferences(), this.getPreferenceStore(), this.getProject());
        this.scriptFolderSelector.createListContents();
        if (this.getElement() == null) {
            this.createClasspathContainerSection(page);
        }
        return page;
    }

    protected void createClasspathContainerSection(Composite page) {
        Label gccLabel = new Label(page, 64);
        gccLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        gccLabel.setText("Groovy Classpath Container:");
        gccLabel.setFont(this.getBoldFont(page));
        Composite gccPage = new Composite(page, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        gccPage.setLayout((Layout)layout);
        gccPage.setFont(page.getFont());
        gccPage.setLayoutData((Object)new GridData(4, 128, true, false));
        this.groovyLibButt = new Button(gccPage, 32);
        this.groovyLibButt.setText("Include all jars in ~/.groovy/lib on the classpath.");
        this.groovyLibButt.setSelection(GroovyCoreActivator.getDefault().getPreference("groovy.classpath.use.groovy.lib.global", true));
        GridData gd = new GridData(4, 128, true, false);
        gd.widthHint = 500;
        Label groovyLibLabel = new Label(gccPage, 64);
        groovyLibLabel.setText("This is the default setting and individual projects can be configured by clicking on the properties page of the Groovy Support classpath container.");
        groovyLibLabel.setLayoutData((Object)gd);
        Label classpathLabel = new Label(gccPage, 64);
        classpathLabel.setText("\nReset the Groovy Classpath Containers.");
        Button updateGCC = new Button(gccPage, 8);
        updateGCC.setText("Update all Groovy Classpath Containers");
        updateGCC.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompilerPreferencesPage.this.updateClasspathContainers();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompilerPreferencesPage.this.updateClasspathContainers();
            }
        });
        Label classpathLabel2 = new Label(gccPage, 64);
        classpathLabel2.setText("Perform this action if there are changes to ~/.groovy/lib that should be reflected in your projects' classpaths.");
        classpathLabel2.setLayoutData((Object)gd);
    }

    protected void createProjectCompilerSection(Composite page) {
        Label compilerLabel = new Label(page, 64);
        compilerLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        compilerLabel.setText("Groovy compiler level for project " + this.getProject().getName() + ":");
        compilerLabel.setFont(this.getBoldFont(page));
        this.compilerCombo = new ComboViewer(new Combo(page, 12));
        this.compilerCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element instanceof SpecifiedVersion ? ((SpecifiedVersion)element).toReadableVersionString() : "";
            }
        });
        SortedSet versions = CompilerUtils.getAllGroovyVersions();
        this.compilerCombo.add((Object)SpecifiedVersion.DONT_CARE);
        for (SpecifiedVersion version : versions) {
            this.compilerCombo.add((Object)version);
        }
        this.currentProjectVersion = CompilerUtils.getCompilerLevel((IProject)this.getProject());
        Label explainLabel = new Label(page, 64);
        explainLabel.setText("If the project compiler level does not match the workspace compiler level,\nthere will be a build error placed on the project.");
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = false;
        explainLabel.setLayoutData((Object)data);
        this.setToProjectVersion();
    }

    private void setToProjectVersion() {
        this.compilerCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentProjectVersion), true);
    }

    protected void createWorkspaceCompilerSection(Composite page) {
        Label compilerLabel = new Label(page, 64);
        compilerLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        compilerLabel.setText("Groovy Compiler settings:");
        compilerLabel.setFont(this.getBoldFont(page));
        Composite compilerPage = new Composite(page, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        compilerPage.setLayout((Layout)layout);
        compilerPage.setFont(page.getFont());
        compilerPage.setLayoutData((Object)new GridData(4, 128, true, false));
        CompilerSwitchUIHelper.createCompilerSwitchBlock(compilerPage);
        this.doCheckForCompilerMismatch = new Button(compilerPage, 32);
        this.doCheckForCompilerMismatch.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.doCheckForCompilerMismatch.setText("Enable checking for mismatches between the project and workspace Groovy compiler levels");
        this.doCheckForCompilerMismatch.setSelection(this.getPreferences().getBoolean("groovy.check.for.compiler.mismatch", true));
    }

    private Font getBoldFont(Composite page) {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
    }

    public void init(IWorkbench workbench) {
    }

    private void updateClasspathContainers() {
        try {
            GroovyClasspathContainerInitializer.updateAllGroovyClasspathContainers();
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)"Problem updating Groovy classpath contianers", (Throwable)e);
        }
    }

    public boolean performOk() {
        this.applyPreferences();
        return super.performOk();
    }

    public void performApply() {
        super.performApply();
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.getProject() == null) {
            GroovyCoreActivator.getDefault().setPreference("groovy.classpath.use.groovy.lib.global", true);
        } else {
            this.enableProjectSpecificSettings(false);
        }
        this.scriptFolderSelector.restoreDefaultsPressed();
        if (this.compilerCombo != null) {
            this.setToProjectVersion();
        }
        if (this.doCheckForCompilerMismatch != null) {
            this.doCheckForCompilerMismatch.setSelection(true);
            this.getPreferences().putBoolean("groovy.check.for.compiler.mismatch", true);
        }
    }

    private void applyPreferences() {
        if (this.getProject() == null) {
            GroovyCoreActivator.getDefault().setPreference("groovy.classpath.use.groovy.lib.global", this.groovyLibButt.getSelection());
        } else {
            this.getPreferenceStore().setValue(PROPERTY_ID, this.useProjectSettings());
        }
        this.scriptFolderSelector.applyPreferences();
        if (this.doCheckForCompilerMismatch != null) {
            boolean isSelected = this.doCheckForCompilerMismatch.getSelection();
            boolean currentPref = this.getPreferences().getBoolean("groovy.check.for.compiler.mismatch", true);
            if (!isSelected && currentPref) {
                try {
                    ResourcesPlugin.getWorkspace().getRoot().deleteMarkers("org.codehaus.groovy.eclipse.core.compilerMismatch", true, 1);
                }
                catch (CoreException e) {
                    GroovyCore.logException((String)"Error deleting markers", (Throwable)e);
                }
            }
            if (isSelected != currentPref) {
                this.getPreferences().putBoolean("groovy.check.for.compiler.mismatch", isSelected);
                try {
                    this.getPreferences().flush();
                }
                catch (BackingStoreException e) {
                    GroovyCore.logException((String)"Error saving compiler preferences", (Throwable)e);
                }
            }
        }
        if (this.compilerCombo != null) {
            StructuredSelection selection = (StructuredSelection)this.compilerCombo.getSelection();
            SpecifiedVersion selected = (SpecifiedVersion)selection.getFirstElement();
            if (selected == null) {
                selected = SpecifiedVersion.UNSPECIFIED;
            }
            if (selected != this.currentProjectVersion && selected != SpecifiedVersion.UNSPECIFIED) {
                CompilerUtils.setCompilerLevel((IProject)this.getProject(), (SpecifiedVersion)selected, (boolean)true);
            }
        }
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        if (project != null && project.equals((Object)this.getProject())) {
            return this.getPreferenceStore().getBoolean(PROPERTY_ID);
        }
        return false;
    }

    protected String getPreferencePageID() {
        return PREFERENCES_ID;
    }

    protected String getPropertyPageID() {
        return PROPERTY_ID;
    }
}

