/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.builder.ConvertLegacyProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class AskToConvertLegacyProjects
extends UIJob {
    public AskToConvertLegacyProjects() {
        super("Convert Legacy Projects");
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        ConvertLegacyProject legacy = new ConvertLegacyProject();
        if (legacy.getAllOldProjects().length == 0) {
            return Status.OK_STATUS;
        }
        Shell shell = this.getDisplay().getActiveShell();
        boolean shouldDispose = false;
        if (shell == null) {
            Shell[] shells = this.getDisplay().getShells();
            if (shells.length > 0) {
                shell = shells[0];
            } else {
                shell = new Shell(this.getDisplay());
                shouldDispose = true;
            }
        }
        IPreferenceStore prefs = GroovyPlugin.getDefault().getPreferenceStore();
        MessageDialogWithToggle d = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)"Convert legacy Groovy Projects", (String)"Some of your Groovy projects appear to be incompatible with the new version of the Groovy plugin.  Should they be converted now?\n\nThey can be converted later from the Groovy Preferences page", (String)"Don't show this message again.", (boolean)false, (IPreferenceStore)prefs, (String)"groovy.plugin.ask.to.convert");
        try {
            if (2 == d.getReturnCode()) {
                IProject[] projects = legacy.getAllOldProjects();
                monitor.beginTask("", projects.length);
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    legacy.convertProject(project);
                    monitor.internalWorked(1.0);
                    ++n2;
                }
            }
            prefs.setValue("groovy.plugin.ask.to.convert", !d.getToggleState());
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.codehaus.groovy.eclipse.ui", "Error converting legacy projects", (Throwable)e);
            return status;
        }
        finally {
            if (shouldDispose) {
                shell.dispose();
            }
        }
    }
}

