/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.launchers;

import java.util.List;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.launchers.GroovyShellLaunchDelegate;
import org.codehaus.groovy.eclipse.core.util.ListUtil;
import org.codehaus.groovy.tools.shell.Main;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class GroovyShellLaunchShortcut
implements ILaunchShortcut {
    public static final String GROOVY_SHELL_LAUNCH_CONFIG_ID = "org.codehaus.groovy.eclipse.groovyShellLaunchConfiguration";
    public static final String SELECT_CONFIG_DIALOG_TITLE = "Select Groovy Shell Launch";
    public static final String SELECT_CONFIG_DIALOG_TEXT = "Please select the Groovy Shell run configuration to Launch";
    public static final String GROOVY_FILE_NOT_RUNNABLE_MESSAGE = "The groovy shell could not be run.";

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IJavaElement) {
            IStructuredSelection structredSelection = (IStructuredSelection)selection;
            IJavaElement elt = (IJavaElement)structredSelection.getFirstElement();
            this.launchGroovy(elt.getJavaProject(), mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        editor.getEditorSite().getPage().saveEditor(editor, false);
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)file);
        if (unit.getJavaProject() != null) {
            this.launchGroovy(unit.getJavaProject(), mode);
        }
    }

    private void launchGroovy(IJavaProject project, String mode) {
        String className = Main.class.getName();
        try {
            String launchName = GroovyShellLaunchShortcut.getLaunchManager().generateLaunchConfigurationName(project.getProject().getName());
            ILaunchConfigurationWorkingCopy launchConfig = GroovyShellLaunchShortcut.getGroovyLaunchConfigType().newInstance(null, launchName);
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, className);
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getElementName());
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-Djline.terminal=jline.UnsupportedTerminal");
            List classpath = ListUtil.newList((Object[])JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project));
            try {
                classpath.addAll(0, GroovyShellLaunchDelegate.getExtraClasspathElements());
            }
            catch (Exception e) {
                GroovyCore.logException((String)"Error getting extra classpath elements to launch", (Throwable)e);
            }
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
            DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)mode);
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logException("Exception launching Groovy Console", e);
        }
    }

    public static ILaunchConfigurationType getGroovyLaunchConfigType() {
        return GroovyShellLaunchShortcut.getLaunchManager().getLaunchConfigurationType(GROOVY_SHELL_LAUNCH_CONFIG_ID);
    }

    public static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

