/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.launchers;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GroovyConsoleLineTracker
implements IConsoleLineTracker {
    private IConsole console;
    private static final Pattern linePattern = Pattern.compile(".*\\((.*)\\.groovy(:(.*))?\\)");

    public void init(IConsole console) {
        this.console = console;
    }

    public void lineAppended(IRegion line) {
        if (this.console == null) {
            return;
        }
        int lineOffset = line.getOffset();
        int lineLength = line.getLength();
        try {
            String consoleLine = this.console.getDocument().get(lineOffset, lineLength);
            GroovyPlugin.trace(consoleLine);
            Matcher m = linePattern.matcher(consoleLine);
            String groovyFileName = null;
            int lineNumber = -1;
            int openParenIndexAt = -1;
            int closeParenIndexAt = -1;
            if (m.matches()) {
                GroovyCore.trace((String)("match: " + m));
                consoleLine = m.group(0);
                openParenIndexAt = consoleLine.indexOf("(");
                if (openParenIndexAt >= 0) {
                    int start;
                    int end = consoleLine.indexOf(".groovy");
                    if (end == -1 || openParenIndexAt + 1 >= end) {
                        return;
                    }
                    String groovyClassName = consoleLine.substring(openParenIndexAt + 1, end);
                    int classIndex = consoleLine.indexOf(groovyClassName);
                    if (classIndex < (start = 3) || classIndex >= consoleLine.length()) {
                        return;
                    }
                    String groovyFilePath = consoleLine.substring(start, classIndex).trim().replace('.', '/');
                    groovyFileName = String.valueOf(groovyFilePath) + groovyClassName + ".groovy";
                    int colonIndex = consoleLine.indexOf(":");
                    closeParenIndexAt = consoleLine.lastIndexOf(")");
                    if (colonIndex > 0) {
                        lineNumber = Integer.parseInt(consoleLine.substring(colonIndex + 1, closeParenIndexAt));
                    }
                    GroovyPlugin.trace("groovyFile=" + groovyFileName + " lineNumber:" + lineNumber);
                }
                if (groovyFileName != null) {
                    FileLink link;
                    IFile[] file = this.searchForFileInLaunchConfig(groovyFileName);
                    if (file.length == 1) {
                        link = new FileLink(file[0], "org.codehaus.groovy.eclipse.editor.GroovyEditor", -1, -1, lineNumber);
                        this.console.addLink((IHyperlink)link, lineOffset + openParenIndexAt + 1, closeParenIndexAt - openParenIndexAt - 1);
                    } else if (file.length > 1) {
                        link = new AmbiguousFileLink(file, "org.codehaus.groovy.eclipse.editor.GroovyEditor", -1, -1, lineNumber);
                        this.console.addLink((IHyperlink)link, lineOffset + openParenIndexAt + 1, closeParenIndexAt - openParenIndexAt - 1);
                    }
                }
            }
        }
        catch (Exception e) {
            GroovyPlugin.trace("unexpected error:" + e.getMessage());
        }
    }

    private IFile[] searchForFileInLaunchConfig(String groovyFileName) throws JavaModelException {
        IJavaProject[] projects;
        LinkedList<IFile> files = new LinkedList<IFile>();
        IJavaProject[] iJavaProjectArray = projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            if (GroovyNature.hasGroovyNature((IProject)javaProject.getProject())) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
                int n3 = iPackageFragmentRootArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFile file;
                    IResource resource;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                    if (root.getKind() == 1 && (resource = root.getResource()).isAccessible() && resource.getType() != 1 && (file = ((IContainer)resource).getFile((IPath)new Path(groovyFileName))).isAccessible()) {
                        files.add(file);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }

    IFile chooseFile(final IFile[] files) {
        final IFile[] result = new IFile[1];
        ConsolePlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                ListDialog dialog = new ListDialog(ConsolePlugin.getStandardDisplay().getActiveShell());
                dialog.setLabelProvider((ILabelProvider)new WorkbenchLabelProvider(){

                    protected String decorateText(String input, Object element) {
                        return ((IFile)element).getFullPath().toPortableString();
                    }
                });
                dialog.setTitle("Choose file to open");
                dialog.setInput((Object)files);
                dialog.setContentProvider((IStructuredContentProvider)new FileContentProvider());
                dialog.setAddCancelButton(true);
                dialog.setMessage("Select a file:");
                dialog.setBlockOnOpen(true);
                int dialogResult = dialog.open();
                if (dialogResult == 0 && dialog.getResult().length > 0) {
                    result[0] = (IFile)dialog.getResult()[0];
                }
            }
        });
        return result[0];
    }

    public void dispose() {
        this.console = null;
    }

    public class AmbiguousFileLink
    extends FileLink
    implements IHyperlink {
        IFile[] files;
        boolean fileChosen;

        public AmbiguousFileLink(IFile[] files, String editorId, int fileOffset, int fileLength, int fileLineNumber) {
            super(null, editorId, fileOffset, fileLength, fileLineNumber);
            this.fileChosen = false;
            this.files = files;
        }

        public void linkActivated() {
            IFile file;
            if (!this.fileChosen && (file = GroovyConsoleLineTracker.this.chooseFile(this.files)) != null) {
                this.fileChosen = true;
                ReflectionUtils.setPrivateField(FileLink.class, (String)"fFile", (Object)((Object)this), (Object)file);
            }
            if (this.fileChosen) {
                super.linkActivated();
            }
        }
    }

    public class FileContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            IFile[] files = (IFile[])inputElement;
            Object[] out = new Object[files.length];
            int i = 0;
            while (i < out.length) {
                out[i] = files[i];
                ++i;
            }
            return out;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

