/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.launchers;

import java.util.List;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroovyLauncherTab
extends JavaMainTab {
    protected void handleSearchButtonSelected() {
        IJavaProject javaProject = this.getJavaProject();
        try {
            List<IType> availableClasses = this.findAllRunnableTypes(javaProject);
            if (availableClasses.size() == 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"No Groovy classes to run", (String)"There are no compiled groovy classes to run in this project");
                return;
            }
            ListDialog dialog = new ListDialog(this.getShell());
            dialog.setBlockOnOpen(true);
            dialog.setMessage("Select a Groovy class to run");
            dialog.setTitle("Choose Groovy Class");
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setLabelProvider((ILabelProvider)new JavaUILabelProvider());
            dialog.setInput((Object)availableClasses.toArray(new IType[availableClasses.size()]));
            if (dialog.open() == 1) {
                return;
            }
            Object[] results = dialog.getResult();
            if (results == null || results.length == 0) {
                return;
            }
            if (results[0] instanceof IType) {
                this.fMainText.setText(((IType)results[0]).getFullyQualifiedName());
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)("Exception when launching " + javaProject), (Throwable)e);
        }
    }

    protected abstract List<IType> findAllRunnableTypes(IJavaProject var1) throws JavaModelException;

    public String getName() {
        return "Groovy Main";
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        super.activated(workingCopy);
    }
}

