/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.launchers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyProjectFacade;
import org.codehaus.groovy.eclipse.core.util.ListUtil;
import org.codehaus.groovy.eclipse.launchers.LaunchShortcutHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroovyLaunchShortcut
implements ILaunchShortcut {
    public static final String SELECT_CONFIG_DIALOG_TITLE = "Select Groovy {0} to launch";
    public static final String SELECT_CONFIG_DIALOG_TEXT = "Select the Groovy {0} to launch";
    public static final String GROOVY_FILE_NOT_RUNNABLE_MESSAGE = "Groovy {0} not found in current selection";
    public static final String GROOVY_TYPE_TO_RUN = "org.codehaus.groovy.eclipse.launch.runType";
    private final String title = "Select Groovy {0} to launch".replace("{0}", this.applicationOrConsole());
    private final String text = "Select the Groovy {0} to launch".replace("{0}", this.applicationOrConsole());
    private final String msg = "Groovy {0} not found in current selection".replace("{0}", this.applicationOrConsole());

    public void launch(ISelection selection, String mode) {
        ICompilationUnit unit = this.extractCompilationUnit(selection);
        IJavaProject javaProject = unit != null ? unit.getJavaProject() : this.extractJavaProject(selection);
        if (javaProject == null && unit == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Can't run script", (String)"No script or project selected!");
            return;
        }
        if (unit != null || this.canLaunchWithNoType()) {
            this.launchGroovy(unit, javaProject, mode);
        } else {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Can't run script", (String)"No script selected!");
        }
    }

    private IJavaProject extractJavaProject(ISelection selection) {
        IStructuredSelection struct;
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = (struct = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IJavaProject javaProject = (IJavaProject)((IAdaptable)obj).getAdapter(IJavaProject.class);
            if (javaProject != null) {
                return javaProject;
            }
            IProject project = (IProject)((IAdaptable)obj).getAdapter(IProject.class);
            if (project != null) {
                return JavaCore.create((IProject)project);
            }
        }
        return null;
    }

    private ICompilationUnit extractCompilationUnit(ISelection selection) {
        IStructuredSelection struct;
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = (struct = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            ICompilationUnit unit = (ICompilationUnit)((IAdaptable)obj).getAdapter(ICompilationUnit.class);
            if (unit != null) {
                return unit;
            }
            IFile file = (IFile)((IAdaptable)obj).getAdapter(IFile.class);
            if (file != null) {
                return JavaCore.createCompilationUnitFrom((IFile)file);
            }
        }
        return null;
    }

    protected void launchGroovy(ICompilationUnit unit, IJavaProject javaProject, String mode) {
        IType runType = null;
        if (unit != null) {
            IType[] types = null;
            try {
                types = unit.getAllTypes();
            }
            catch (JavaModelException e) {
                GroovyCore.errorRunningGroovy((Exception)((Object)e));
                return;
            }
            runType = this.findClassToRun(types);
            if (runType == null) {
                GroovyCore.errorRunningGroovy((Exception)new Exception(this.msg));
                return;
            }
        }
        Map<String, String> launchConfigProperties = this.createLaunchProperties(runType, javaProject);
        try {
            ILaunchConfigurationWorkingCopy workingConfig = this.findOrCreateLaunchConfig(launchConfigProperties, runType != null ? runType.getElementName() : javaProject.getElementName());
            workingConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, Arrays.asList(JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject)));
            ILaunchConfiguration config = workingConfig.doSave();
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
        catch (CoreException e) {
            GroovyCore.errorRunningGroovyFile((IFile)((IFile)unit.getResource()), (Exception)((Object)e));
        }
    }

    protected abstract String classToRun();

    protected Map<String, String> createLaunchProperties(IType runType, IJavaProject javaProject) {
        String pathToClass;
        HashMap<String, String> launchConfigProperties = new HashMap<String, String>();
        if (runType != null) {
            try {
                pathToClass = " \"${resource_loc:" + runType.getResource().getFullPath().toPortableString() + "}\"";
            }
            catch (NullPointerException nullPointerException) {
                pathToClass = "";
                GroovyCore.errorRunningGroovy((Exception)new IllegalArgumentException("Could not find file to run for " + runType));
            }
        } else {
            pathToClass = "";
        }
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.codehaus.groovy.tools.GroovyStarter");
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getElementName());
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, " -Dgroovy.home=" + this.getGroovyHome());
        launchConfigProperties.put(GROOVY_TYPE_TO_RUN, runType == null ? "" : runType.getFullyQualifiedName());
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "--classpath " + this.generateClasspath(javaProject) + " --main " + this.classToRun() + pathToClass);
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, this.getWorkingDirectory(runType, javaProject));
        return launchConfigProperties;
    }

    private String getGroovyConf() {
        return "\"${groovy_home}/conf/groovy-starter.conf\"";
    }

    private String getGroovyHome() {
        return "\"${groovy_home}\"";
    }

    private String getWorkingDirectory(IType runType, IJavaProject javaProject) {
        String workingDirSetting = GroovyPlugin.getDefault().getPreferenceStore().getString("groovy.scripts.workingdir");
        if (workingDirSetting.equals("eclipse_home")) {
            return "${eclipse_home}";
        }
        if (workingDirSetting.equals("script_loc") && runType != null) {
            try {
                return runType.getResource().getParent().getLocation().toOSString();
            }
            catch (Exception e) {
                GroovyCore.logException((String)("Exception trying to find the location of " + runType.getElementName()), (Throwable)e);
                return this.getProjectLocation((IJavaElement)runType);
            }
        }
        return this.getProjectLocation((IJavaElement)javaProject);
    }

    private String getProjectLocation(IJavaElement elt) {
        return "${workspace_loc:" + File.separator + elt.getJavaProject().getProject().getName() + "}";
    }

    private String getProjectLocation(IPath path) {
        if (path.segmentCount() > 0) {
            return "${workspace_loc:" + File.separator + path.segment(0) + "}";
        }
        return "${workspace_loc}";
    }

    protected String generateClasspath(IJavaProject javaProject) {
        TreeSet<String> sourceEntries = new TreeSet<String>();
        TreeSet<String> binEntries = new TreeSet<String>();
        this.addClasspathEntriesForProject(javaProject, sourceEntries, binEntries);
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        for (String entry : sourceEntries) {
            sb.append(entry);
            sb.append(File.pathSeparator);
        }
        for (String entry : binEntries) {
            sb.append(entry);
            sb.append(File.pathSeparator);
        }
        if (sb.length() > 0) {
            sb.replace(sb.length() - 1, sb.length(), "\"");
        }
        return sb.toString();
    }

    private void addClasspathEntriesForProject(IJavaProject javaProject, SortedSet<String> sourceEntries, SortedSet<String> binEntries) {
        ArrayList<IJavaProject> dependingProjects = new ArrayList<IJavaProject>();
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                int kind = entry.getEntryKind();
                switch (kind) {
                    case 1: {
                        IPath libPath = entry.getPath();
                        if (!this.isPathInWorkspace(libPath)) {
                            sourceEntries.add(libPath.toOSString());
                            break;
                        }
                    }
                    case 3: {
                        IPath srcPath = entry.getPath();
                        String sloc = this.getProjectLocation(srcPath);
                        if (srcPath.segmentCount() > 1) {
                            sloc = String.valueOf(sloc) + File.separator + srcPath.removeFirstSegments(1).toOSString();
                        }
                        sourceEntries.add(sloc);
                        IPath outPath = entry.getOutputLocation();
                        if (outPath == null) break;
                        String bloc = this.getProjectLocation(outPath);
                        if (outPath.segmentCount() > 1) {
                            bloc = String.valueOf(bloc) + File.separator + outPath.removeFirstSegments(1).toOSString();
                        }
                        binEntries.add(bloc);
                        break;
                    }
                    case 2: {
                        dependingProjects.add(javaProject.getJavaModel().getJavaProject(entry.getPath().lastSegment()));
                    }
                }
                ++n2;
            }
            IPath defaultOutPath = javaProject.getOutputLocation();
            if (defaultOutPath != null) {
                String bloc = this.getProjectLocation((IJavaElement)javaProject);
                if (defaultOutPath.segmentCount() > 1) {
                    bloc = String.valueOf(bloc) + File.separator + defaultOutPath.removeFirstSegments(1).toOSString();
                }
                binEntries.add(bloc);
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)"Exception generating classpath for launching groovy script", (Throwable)e);
        }
        for (IJavaProject dependingProject : dependingProjects) {
            if (!dependingProject.getProject().isAccessible()) continue;
            this.addClasspathEntriesForProject(dependingProject, sourceEntries, binEntries);
        }
    }

    private boolean isPathInWorkspace(IPath libPath) {
        if (!libPath.isAbsolute() || libPath.segmentCount() == 0) {
            return true;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(libPath.segment(0)).exists();
    }

    public void launch(IEditorPart editor, String mode) {
        editor.getEditorSite().getPage().saveEditor(editor, false);
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)file);
        if (unit != null) {
            this.launchGroovy(unit, unit.getJavaProject(), mode);
        }
    }

    public IType findClassToRun(IType[] types) {
        IType returnValue = null;
        ArrayList<IType> candidates = new ArrayList<IType>();
        int i = 0;
        while (i < types.length) {
            if (GroovyProjectFacade.hasRunnableMain((IType)types[i])) {
                candidates.add(types[i]);
            }
            ++i;
        }
        returnValue = candidates.size() == 1 ? (IType)candidates.get(0) : LaunchShortcutHelper.chooseClassNode(candidates);
        return returnValue;
    }

    public ILaunchConfigurationWorkingCopy findOrCreateLaunchConfig(Map<String, String> configProperties, String simpleMainTypeName) throws CoreException {
        ILaunchConfiguration config = this.findConfiguration(configProperties.get(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME), configProperties.get(GROOVY_TYPE_TO_RUN));
        ILaunchConfigurationWorkingCopy returnConfig = config == null ? this.createLaunchConfig(configProperties, simpleMainTypeName) : config.getWorkingCopy();
        return returnConfig;
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfig(Map<String, String> configProperties, String classUnderTest) throws CoreException {
        String launchName = AbstractGroovyLaunchShortcut.getLaunchManager().generateLaunchConfigurationName(classUnderTest);
        ILaunchConfigurationWorkingCopy returnConfig = this.getGroovyLaunchConfigType().newInstance(null, launchName);
        for (String key : configProperties.keySet()) {
            String value = configProperties.get(key);
            returnConfig.setAttribute(key, value);
        }
        return returnConfig;
    }

    private ILaunchConfiguration findConfiguration(String projectName, String mainTypeName) throws CoreException {
        ILaunchConfiguration returnValue = null;
        ILaunchConfigurationType configType = this.getGroovyLaunchConfigType();
        List candidateConfigs = ListUtil.newEmptyList();
        ILaunchConfiguration[] configs = AbstractGroovyLaunchShortcut.getLaunchManager().getLaunchConfigurations(configType);
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration config = configs[i];
            if (config.getAttribute(GROOVY_TYPE_TO_RUN, "").equals(mainTypeName) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                candidateConfigs.add(config);
            }
            ++i;
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 1) {
            returnValue = (ILaunchConfiguration)candidateConfigs.get(0);
        } else if (candidateCount > 1) {
            returnValue = this.chooseConfiguration(candidateConfigs);
        }
        return returnValue;
    }

    public ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        return LaunchShortcutHelper.chooseFromList(configList, (ILabelProvider)labelProvider, this.title, this.text);
    }

    protected abstract ILaunchConfigurationType getGroovyLaunchConfigType();

    public static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected abstract String applicationOrConsole();

    protected abstract boolean canLaunchWithNoType();
}

