/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.outline;

import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.editor.outline.OField;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.JavaElement;

class GroovyScriptVariable
extends OField {
    private static final String NO_NAME = "no name";
    private static final String DEF_SIGNATURE = "Qdef;";
    private String typeSignature;

    public GroovyScriptVariable(JavaElement parent, DeclarationExpression node) {
        super(parent, (ASTNode)node, GroovyScriptVariable.extractName(node));
        ClassNode fieldType = node.getLeftExpression().getType();
        if (ClassHelper.DYNAMIC_TYPE == fieldType) {
            this.typeSignature = DEF_SIGNATURE;
        } else {
            this.typeSignature = fieldType.getNameWithoutPackage();
            if (!this.typeSignature.startsWith("[")) {
                this.typeSignature = Signature.createTypeSignature((String)this.typeSignature, (boolean)false);
            }
        }
    }

    private static String extractName(DeclarationExpression node) {
        Expression leftExpression = node.getLeftExpression();
        if (leftExpression instanceof VariableExpression) {
            return ((VariableExpression)leftExpression).getName();
        }
        if (leftExpression instanceof TupleExpression) {
            List exprs = ((TupleExpression)leftExpression).getExpressions();
            StringBuilder sb = new StringBuilder();
            Iterator exprIter = exprs.iterator();
            while (exprIter.hasNext()) {
                Expression expr = (Expression)exprIter.next();
                sb.append(expr.getText());
                if (!exprIter.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
        return NO_NAME;
    }

    public ASTNode getElementNameNode() {
        DeclarationExpression decl = (DeclarationExpression)this.getNode();
        return decl.getLeftExpression();
    }

    public String getTypeSignature() {
        return this.typeSignature;
    }
}

