/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.editor.outline.GroovyScriptVariable;
import org.codehaus.groovy.eclipse.editor.outline.OCompilationUnit;
import org.codehaus.groovy.eclipse.editor.outline.OType;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;

class GroovyScriptOCompilationUnit
extends OCompilationUnit {
    public GroovyScriptOCompilationUnit(GroovyCompilationUnit unit) {
        super(unit);
    }

    public IJavaElement[] refreshChildren() {
        String scriptName;
        ClassNode scriptClassDummy;
        ModuleNode node = (ModuleNode)this.getNode();
        if (node != null) {
            scriptClassDummy = node.getScriptClassDummy();
            if (scriptClassDummy == null && node.getClasses().size() > 0) {
                scriptClassDummy = (ClassNode)node.getClasses().get(0);
            }
            scriptName = scriptClassDummy == null ? "Problem" : scriptClassDummy.getNameWithoutPackage();
        } else {
            scriptName = null;
            scriptClassDummy = null;
        }
        if (node == null || node.encounteredUnrecoverableError() || scriptClassDummy == null) {
            return new IJavaElement[]{new OType((IJavaElement)this.getUnit(), (ASTNode)node, String.valueOf(scriptName) + " -- No structure found")};
        }
        try {
            IJavaElement[] children = this.getUnit().getChildren();
            final ArrayList<IJavaElement> fakeChildren = new ArrayList<IJavaElement>();
            IType candidate = null;
            IJavaElement[] iJavaElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement elt = iJavaElementArray[n2];
                if (elt.getElementName().equals(scriptName)) {
                    candidate = (IType)elt;
                } else if (elt instanceof IJavaElement) {
                    fakeChildren.add(elt);
                }
                ++n2;
            }
            final IType scriptType = candidate;
            if (scriptType != null) {
                IJavaElement[] scriptChildren;
                IJavaElement[] iJavaElementArray2 = scriptChildren = scriptType.getChildren();
                int n3 = scriptChildren.length;
                n = 0;
                while (n < n3) {
                    IJavaElement scriptElt = iJavaElementArray2[n];
                    if (scriptElt instanceof IMember && !this.isRunMethod(scriptElt) && !this.isMainMethod(scriptElt) && !this.isConstructor(scriptElt)) {
                        fakeChildren.add(scriptElt);
                    }
                    ++n;
                }
                BlockStatement block = node.getStatementBlock();
                ClassCodeVisitorSupport visitor = new ClassCodeVisitorSupport(){

                    public void visitClosureExpression(ClosureExpression expression) {
                    }

                    public void visitDeclarationExpression(DeclarationExpression expression) {
                        fakeChildren.add(new GroovyScriptVariable((JavaElement)scriptType, expression));
                        super.visitDeclarationExpression(expression);
                    }
                };
                visitor.visitBlockStatement(block);
            }
            IJavaElement[] fakeChildrenArr = fakeChildren.toArray(new IJavaElement[fakeChildren.size()]);
            GroovyScriptOCompilationUnit.sort(fakeChildrenArr);
            return fakeChildrenArr;
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)"Encountered exception when calculating children", (Throwable)e);
            return new IJavaElement[]{new OType((IJavaElement)this.getUnit(), (ASTNode)node, String.valueOf(scriptName) + " -- Encountered exception.  See log.")};
        }
    }

    public static IJavaElement[] sort(IJavaElement[] elts) {
        Arrays.sort(elts, new Comparator<IJavaElement>(){

            @Override
            public int compare(IJavaElement e1, IJavaElement e2) {
                try {
                    Assert.isTrue((boolean)(e1 instanceof ISourceReference), (String)("Expecting a ISourceReference, but found " + e1));
                    Assert.isTrue((boolean)(e2 instanceof ISourceReference), (String)("Expecting a ISourceReference, but found " + e2));
                    return ((ISourceReference)e1).getSourceRange().getOffset() - ((ISourceReference)e2).getSourceRange().getOffset();
                }
                catch (JavaModelException e) {
                    GroovyCore.logException((String)("Exception when comparing " + e1 + " and " + e2), (Throwable)e);
                    return 0;
                }
            }
        });
        return elts;
    }

    private boolean isConstructor(IJavaElement scriptElt) throws JavaModelException {
        if (scriptElt.getElementType() != 9) {
            return false;
        }
        return ((IMethod)scriptElt).isConstructor();
    }

    private boolean isMainMethod(IJavaElement scriptElt) throws JavaModelException {
        if (scriptElt.getElementType() != 9) {
            return false;
        }
        return ((IMethod)scriptElt).isMainMethod();
    }

    private boolean isRunMethod(IJavaElement scriptElt) {
        if (scriptElt.getElementType() != 9) {
            return false;
        }
        if (!scriptElt.getElementName().equals("run")) {
            return false;
        }
        String[] parammeterTypes = ((IMethod)scriptElt).getParameterTypes();
        return parammeterTypes == null || parammeterTypes.length == 0;
    }
}

