/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.outline;

import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.editor.outline.OCompilationUnit;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaOutlinePage;
import org.eclipse.jdt.internal.ui.viewsupport.SourcePositionComparator;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;

public class GroovyOutlinePage
extends JavaOutlinePage {
    private OCompilationUnit outlineUnit = null;
    private boolean isInitialized = false;

    public GroovyOutlinePage(String contextMenuID, GroovyEditor editor, OCompilationUnit unit) {
        super(contextMenuID, (JavaEditor)editor);
        this.outlineUnit = unit;
    }

    public void refresh() {
        this.initializeViewer();
        this.outlineUnit.refresh();
        JavaOutlinePage.JavaOutlineViewer outlineViewer = this.getOutlineViewer();
        if (outlineViewer != null) {
            outlineViewer.refresh();
        }
    }

    public OCompilationUnit getOutlineCompilationUnit() {
        return this.outlineUnit;
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
    }

    private void initializeViewer() {
        IToolBarManager toolBarManager;
        IActionBars actionBars;
        if (this.isInitialized) {
            return;
        }
        IPageSite site = this.getSite();
        if (site != null && (actionBars = site.getActionBars()) != null && (toolBarManager = actionBars.getToolBarManager()) != null) {
            toolBarManager.removeAll();
            toolBarManager.add((IAction)new GroovyLexicalSortingAction());
            toolBarManager.update(true);
        }
        this.isInitialized = true;
    }

    public void createControl(Composite parent) {
        ViewerFilter[] filters;
        super.createControl(parent);
        ViewerFilter[] viewerFilterArray = filters = this.getOutlineViewer().getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter.getClass().getName().contains("CategoryFilter")) {
                this.getOutlineViewer().removeFilter(filter);
            }
            ++n2;
        }
    }

    public ISourceReference getOutlineElmenetAt(int caretOffset) {
        return this.getOutlineCompilationUnit().getOutlineElementAt(caretOffset);
    }

    public class GroovyLexicalSortingAction
    extends Action {
        private JavaElementComparator fComparator = new JavaElementComparator();
        private SourcePositionComparator fSourcePositonComparator = new SourcePositionComparator();

        public GroovyLexicalSortingAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.lexical_sorting_outline_action");
            this.setText("Link with Editor");
            JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"alphab_sort_co.gif");
            boolean checked = JavaPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(final boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)GroovyOutlinePage.this.getOutlineViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    if (on) {
                        GroovyOutlinePage.this.getOutlineViewer().setComparator((ViewerComparator)GroovyLexicalSortingAction.this.fComparator);
                    } else {
                        GroovyOutlinePage.this.getOutlineViewer().setComparator((ViewerComparator)GroovyLexicalSortingAction.this.fSourcePositonComparator);
                    }
                }
            });
            if (store) {
                JavaPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }
    }
}

