/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.highlighting;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTNode;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jface.text.Position;

public abstract class SemanticReferenceRequestor
implements ITypeRequestor {
    protected static Position getPosition(ASTNode node) {
        int length;
        int start;
        if (node instanceof FieldNode || node instanceof MethodNode || node instanceof PropertyNode || node instanceof ClassNode && ((ClassNode)node).getNameEnd() > 0) {
            AnnotatedNode an = (AnnotatedNode)node;
            start = an.getNameStart();
            length = an.getNameEnd() - start + 1;
        } else if (node instanceof Parameter) {
            Parameter p = (Parameter)node;
            start = p.getNameStart();
            length = p.getNameEnd() - start;
        } else if (node instanceof ImportNode) {
            ClassNode clazz = ((ImportNode)node).getType();
            start = clazz.getStart();
            length = clazz.getLength();
        } else if (node instanceof StaticMethodCallExpression) {
            start = node.getStart();
            length = ((StaticMethodCallExpression)node).getMethod().length();
        } else if (node instanceof MethodCallExpression) {
            Expression e = ((MethodCallExpression)node).getMethod();
            start = e.getStart();
            length = e.getLength();
        } else {
            start = node.getStart();
            length = node.getLength();
        }
        return new Position(start, length);
    }

    protected static boolean isDeprecated(ASTNode declaration) {
        if (declaration instanceof ClassNode) {
            declaration = ((ClassNode)declaration).redirect();
        }
        if (declaration instanceof PropertyNode && ((PropertyNode)declaration).getField() != null) {
            declaration = ((PropertyNode)declaration).getField();
        }
        if (declaration instanceof JDTNode) {
            return ((JDTNode)declaration).isDeprecated();
        }
        if (declaration instanceof ClassNode || declaration instanceof FieldNode || declaration instanceof MethodNode) {
            return SemanticReferenceRequestor.hasDeprecatedAnnotation((AnnotatedNode)declaration);
        }
        return false;
    }

    private static boolean hasDeprecatedAnnotation(AnnotatedNode declaration) {
        if (SemanticReferenceRequestor.isDeprecated(declaration)) {
            return true;
        }
        List anns = declaration.getAnnotations();
        for (AnnotationNode ann : anns) {
            if (ann.getClassNode() == null || !ann.getClassNode().getName().equals("java.lang.Deprecated")) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeprecated(AnnotatedNode node) {
        int flags = node instanceof ClassNode ? ((ClassNode)node).getModifiers() : (node instanceof MethodNode ? ((MethodNode)node).getModifiers() : (node instanceof FieldNode ? ((FieldNode)node).getModifiers() : 0));
        return (flags & 0x20000) != 0;
    }

    protected static boolean isFinal(ASTNode node) {
        if (node instanceof FieldNode) {
            return ((FieldNode)node).isFinal();
        }
        if (node instanceof MethodNode) {
            return (((MethodNode)node).getModifiers() & 0x10) != 0;
        }
        return false;
    }

    protected static boolean isForLoopParam(Variable param, VariableScope scope) {
        VariableScope.VariableInfo info = scope.lookupName(param.getName());
        return info != null && info.scopeNode instanceof ForStatement;
    }

    protected static boolean isCatchParam(Variable param, VariableScope scope) {
        VariableScope.VariableInfo info = scope.lookupName(param.getName());
        return info != null && info.scopeNode instanceof CatchStatement;
    }

    protected static boolean isNumber(ClassNode type) {
        return ClassHelper.isNumberType((ClassNode)type) || type == ClassHelper.BigDecimal_TYPE || type == ClassHelper.BigInteger_TYPE;
    }

    protected static boolean isStatic(ASTNode node) {
        if (node instanceof FieldNode) {
            return ((FieldNode)node).isStatic();
        }
        if (node instanceof MethodNode) {
            return ((MethodNode)node).isStatic();
        }
        if (node instanceof PropertyNode) {
            return ((PropertyNode)node).isStatic();
        }
        return false;
    }
}

