/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.highlighting;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.editor.highlighting.HighlightedTypedPosition;
import org.codehaus.groovy.eclipse.editor.highlighting.SemanticReferenceRequestor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class SemanticHighlightingReferenceRequestor
extends SemanticReferenceRequestor {
    private char[] contents;
    private boolean insideSlashy;
    private boolean insideDollarSlashy;
    private final GroovyCompilationUnit unit;
    private static final boolean DEBUG = false;
    protected final Set<HighlightedTypedPosition> typedPosition = new TreeSet<HighlightedTypedPosition>();

    public SemanticHighlightingReferenceRequestor(GroovyCompilationUnit unit) {
        this.unit = unit;
    }

    private int unitLength() {
        if (this.contents == null) {
            this.contents = this.unit.getContents();
        }
        return this.contents.length;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (!(node instanceof AnnotatedNode) || node instanceof ImportNode || this.endOffset(node, result) < 1) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        HighlightedTypedPosition pos = null;
        if (result.confidence == TypeLookupResult.TypeConfidence.UNKNOWN && node.getEnd() > 0) {
            if (this.isRealASTNode(node)) {
                Position p = SemanticHighlightingReferenceRequestor.getPosition(node);
                this.typedPosition.add(new HighlightedTypedPosition(p, HighlightedTypedPosition.HighlightKind.UNKNOWN));
                return ITypeRequestor.VisitStatus.CANCEL_BRANCH;
            }
        } else if (SemanticHighlightingReferenceRequestor.isDeprecated(result.declaration)) {
            pos = new HighlightedTypedPosition(SemanticHighlightingReferenceRequestor.getPosition(node), HighlightedTypedPosition.HighlightKind.DEPRECATED);
        } else if (result.declaration instanceof FieldNode || result.declaration instanceof PropertyNode) {
            pos = this.handleFieldOrProperty((AnnotatedNode)node, result.declaration);
        } else if (node instanceof MethodNode) {
            pos = result.enclosingAnnotation == null ? this.handleMethodDeclaration((MethodNode)node) : this.handleAnnotationElement(result.enclosingAnnotation, (MethodNode)node);
        } else if (node instanceof ConstructorCallExpression) {
            pos = this.handleMethodReference((ConstructorCallExpression)node);
        } else if (node instanceof MethodCallExpression) {
            pos = this.handleMethodReference((MethodCallExpression)node);
        } else if (node instanceof StaticMethodCallExpression) {
            pos = this.handleMethodReference((StaticMethodCallExpression)node);
        } else if (node instanceof MethodPointerExpression) {
            pos = this.handleMethodReference((MethodPointerExpression)node);
        } else if (node instanceof ConstantExpression) {
            pos = !(result.declaration instanceof MethodNode) ? this.handleConstantExpression((ConstantExpression)node) : this.handleMethodReference((ConstantExpression)node, result, enclosingElement instanceof ImportDeclaration);
        } else if (node instanceof MapEntryExpression) {
            pos = this.handleMapEntryExpression((MapEntryExpression)node);
        } else if (node instanceof Parameter) {
            pos = this.handleVariableExpression((Parameter)node, result.scope);
        } else if (node instanceof VariableExpression) {
            pos = this.handleVariableExpression((VariableExpression)node, result.scope, enclosingElement);
        }
        if (pos != null && (pos.getOffset() > 0 || pos.getLength() > 1 || node instanceof Expression)) {
            this.typedPosition.add(pos);
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private HighlightedTypedPosition handleFieldOrProperty(AnnotatedNode node, ASTNode decl) {
        int length;
        int offset;
        HighlightedTypedPosition.HighlightKind kind = !SemanticHighlightingReferenceRequestor.isStatic(decl) ? HighlightedTypedPosition.HighlightKind.FIELD : (!SemanticHighlightingReferenceRequestor.isFinal(decl) ? HighlightedTypedPosition.HighlightKind.STATIC_FIELD : HighlightedTypedPosition.HighlightKind.STATIC_VALUE);
        if (node == decl) {
            offset = node.getNameStart();
            length = node.getNameEnd() - node.getNameStart() + 1;
        } else {
            offset = node.getStart();
            length = node.getLength();
        }
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleAnnotationElement(AnnotationNode anno, MethodNode elem) {
        try {
            int start = anno.getStart() - 1;
            int until = GroovyUtils.lastElement((AnnotationNode)anno).getEnd() + 1;
            String source = this.unit.getSource().substring(start, until);
            Matcher m = Pattern.compile("\\b\\Q" + elem.getName() + "\\E\\b").matcher(source);
            if (m.find()) {
                return new HighlightedTypedPosition(start + m.start(), elem.getName().length(), HighlightedTypedPosition.HighlightKind.TAG_KEY);
            }
        }
        catch (Exception e) {
            Util.log((Throwable)e);
        }
        return null;
    }

    private HighlightedTypedPosition handleMethodDeclaration(MethodNode node) {
        HighlightedTypedPosition.HighlightKind kind = node instanceof ConstructorNode ? HighlightedTypedPosition.HighlightKind.CTOR : (!SemanticHighlightingReferenceRequestor.isStatic((ASTNode)node) ? HighlightedTypedPosition.HighlightKind.METHOD : HighlightedTypedPosition.HighlightKind.STATIC_METHOD);
        int offset = node.getNameStart();
        int length = node.getNameEnd() - node.getNameStart() + 1;
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleMethodReference(MethodCallExpression expr) {
        HighlightedTypedPosition.HighlightKind kind = HighlightedTypedPosition.HighlightKind.METHOD_CALL;
        if (expr.getObjectExpression() instanceof ClassExpression) {
            kind = HighlightedTypedPosition.HighlightKind.STATIC_CALL;
        }
        int offset = expr.getMethod().getStart();
        int length = expr.getMethod().getLength();
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleMethodReference(ConstructorCallExpression expr) {
        if (expr.isSpecialCall()) {
            return null;
        }
        int offset = expr.getNameStart();
        int length = expr.getNameEnd() - expr.getNameStart() + 1;
        return new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.CTOR_CALL);
    }

    private HighlightedTypedPosition handleMethodReference(StaticMethodCallExpression expr) {
        int offset = expr.getStart();
        int length = expr.getMethod().length();
        return new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.STATIC_CALL);
    }

    private HighlightedTypedPosition handleMethodReference(MethodPointerExpression expr) {
        HighlightedTypedPosition.HighlightKind kind = !(expr.getExpression() instanceof ClassExpression) ? HighlightedTypedPosition.HighlightKind.METHOD_CALL : HighlightedTypedPosition.HighlightKind.STATIC_CALL;
        int offset = expr.getMethodName().getStart();
        int length = expr.getMethodName().getLength();
        return new HighlightedTypedPosition(offset, length, kind);
    }

    private HighlightedTypedPosition handleMethodReference(ConstantExpression expr, TypeLookupResult result, boolean isStaticImport) {
        MethodNode meth = (MethodNode)result.declaration;
        HighlightedTypedPosition.HighlightKind kind = null;
        if (result.isGroovy) {
            kind = HighlightedTypedPosition.HighlightKind.GROOVY_CALL;
        } else if (isStaticImport) {
            kind = HighlightedTypedPosition.HighlightKind.STATIC_CALL;
        } else if (!expr.getText().equals(meth.getName())) {
            HighlightedTypedPosition.HighlightKind highlightKind = kind = !meth.isStatic() ? HighlightedTypedPosition.HighlightKind.METHOD_CALL : HighlightedTypedPosition.HighlightKind.STATIC_CALL;
        }
        if (kind != null) {
            return new HighlightedTypedPosition(expr.getStart(), expr.getLength(), kind);
        }
        return null;
    }

    private HighlightedTypedPosition handleMapEntryExpression(MapEntryExpression expr) {
        Expression key = expr.getKeyExpression();
        if (key instanceof ConstantExpression) {
            this.unitLength();
            char c = this.contents[key.getStart()];
            if (c != '\'' && c != '\"' && c != '/') {
                return new HighlightedTypedPosition(key.getStart(), key.getLength(), HighlightedTypedPosition.HighlightKind.MAP_KEY);
            }
        }
        return null;
    }

    private HighlightedTypedPosition handleConstantExpression(ConstantExpression expr) {
        if (expr.getStart() > this.unitLength()) {
            return null;
        }
        int offset = expr.getStart();
        int length = expr.getLength();
        HighlightedTypedPosition pos = null;
        if (this.insideSlashy) {
            pos = new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.REGEXP);
            if (this.contents[expr.getEnd() - 1] == '/') {
                this.insideSlashy = false;
            }
        } else if (this.insideDollarSlashy) {
            pos = new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.REGEXP);
            if (this.contents[expr.getEnd() - 2] == '/' && this.contents[expr.getEnd() - 1] == '$') {
                this.insideDollarSlashy = false;
            }
        } else if (this.contents[expr.getStart()] == '/') {
            pos = new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.REGEXP);
            if (this.contents[expr.getEnd() - 1] != '/') {
                this.insideSlashy = true;
            }
        } else if (this.contents[expr.getStart()] == '$' && this.contents[expr.getStart() + 1] == '/') {
            pos = new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.REGEXP);
            if (this.contents[expr.getEnd() - 2] != '/' || this.contents[expr.getEnd() - 1] != '$') {
                this.insideDollarSlashy = true;
            }
        } else if (SemanticHighlightingReferenceRequestor.isNumber(expr.getType())) {
            pos = new HighlightedTypedPosition(offset, length, HighlightedTypedPosition.HighlightKind.NUMBER);
        }
        return pos;
    }

    private HighlightedTypedPosition handleVariableExpression(Parameter expr, VariableScope scope) {
        HighlightedTypedPosition.HighlightKind kind = HighlightedTypedPosition.HighlightKind.PARAMETER;
        if (SemanticHighlightingReferenceRequestor.isCatchParam((Variable)expr, scope) || SemanticHighlightingReferenceRequestor.isForLoopParam((Variable)expr, scope)) {
            kind = HighlightedTypedPosition.HighlightKind.VARIABLE;
        }
        return new HighlightedTypedPosition(expr.getNameStart(), expr.getNameEnd() - expr.getNameStart(), kind);
    }

    private HighlightedTypedPosition handleVariableExpression(VariableExpression expr, VariableScope scope, IJavaElement source) {
        boolean isSuperOrThis;
        boolean isParam = expr.getAccessedVariable() instanceof Parameter && !SemanticHighlightingReferenceRequestor.isForLoopParam(expr.getAccessedVariable(), scope) && !SemanticHighlightingReferenceRequestor.isCatchParam(expr.getAccessedVariable(), scope);
        boolean isIt = isParam && "it".equals(expr.getName()) && ((Parameter)expr.getAccessedVariable()).getLineNumber() <= 0;
        boolean bl = isSuperOrThis = "super".equals(expr.getName()) || "this".equals(expr.getName());
        if (!isSuperOrThis && (!isParam || isIt || ((Parameter)expr.getAccessedVariable()).getLineNumber() > 0 || source instanceof SourceType)) {
            HighlightedTypedPosition.HighlightKind kind = isParam ? (isIt ? HighlightedTypedPosition.HighlightKind.GROOVY_CALL : HighlightedTypedPosition.HighlightKind.PARAMETER) : HighlightedTypedPosition.HighlightKind.VARIABLE;
            return new HighlightedTypedPosition(expr.getStart(), expr.getLength(), kind);
        }
        return null;
    }

    private int endOffset(ASTNode node, TypeLookupResult result) {
        int offset = node.getEnd();
        if (result.enclosingAnnotation != null) {
            offset = result.enclosingAnnotation.getEnd();
        }
        return offset;
    }

    private boolean isRealASTNode(ASTNode node) {
        String text = node.getText();
        if (text.length() != node.getLength()) {
            return false;
        }
        int contentsLength = this.unitLength();
        char[] textArr = text.toCharArray();
        int i = 0;
        int j = node.getStart();
        while (i < textArr.length && j < contentsLength) {
            if (textArr[i] != this.contents[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }
}

