/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.highlighting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.editor.highlighting.IHighlightingExtender;
import org.codehaus.groovy.eclipse.editor.highlighting.IHighlightingExtender2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.ui.internal.WorkbenchPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightingExtenderRegistry {
    public static final String EXTENSION_POINT = "org.codehaus.groovy.eclipse.ui.syntaxHighlightingExtension";
    public static final String NATURE_ID = "natureID";
    public static final String EXTENDER = "extender";
    Map<String, IHighlightingExtender> natureToExtenderMap;

    public void initialize() throws CoreException {
        IExtension[] extensions;
        this.natureToExtenderMap = new HashMap<String, IHighlightingExtender>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElts;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElts = ext.getConfigurationElements();
            int n3 = configElts.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elt = iConfigurationElementArray[n4];
                String natureid = elt.getAttribute(NATURE_ID);
                Object object = WorkbenchPlugin.createExtension((IConfigurationElement)elt, (String)EXTENDER);
                if (object instanceof IHighlightingExtender) {
                    this.natureToExtenderMap.put(natureid, (IHighlightingExtender)object);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public IHighlightingExtender getExtender(String natureID) {
        return this.natureToExtenderMap.get(natureID);
    }

    public List<String> getExtraGroovyKeywordsForProject(IProject project) throws CoreException {
        return this.internalGetExtraKeywordsForProject(project, false);
    }

    public List<String> getExtraGJDKKeywordsForProject(IProject project) throws CoreException {
        return this.internalGetExtraKeywordsForProject(project, true);
    }

    public List<String> internalGetExtraKeywordsForProject(IProject project, boolean isGJDK) throws CoreException {
        String[] natureIds;
        if (project == null) {
            return null;
        }
        ArrayList<String> extraKeywords = new ArrayList<String>();
        String[] stringArray = natureIds = project.getDescription().getNatureIds();
        int n = natureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String natureId = stringArray[n2];
            IHighlightingExtender extender = this.getExtender(natureId);
            if (extender != null) {
                List<String> keywords;
                List<String> list = keywords = isGJDK ? extender.getAdditionalGJDKKeywords() : extender.getAdditionalGroovyKeywords();
                if (keywords != null) {
                    extraKeywords.addAll(keywords);
                }
            }
            ++n2;
        }
        return extraKeywords;
    }

    public List<IRule> getAdditionalRulesForProject(IProject project) throws CoreException {
        String[] natureIds;
        if (project == null) {
            return null;
        }
        ArrayList<IRule> extraRules = new ArrayList<IRule>();
        String[] stringArray = natureIds = project.getDescription().getNatureIds();
        int n = natureIds.length;
        int n2 = 0;
        while (n2 < n) {
            List<IRule> rules;
            String natureId = stringArray[n2];
            IHighlightingExtender extender = this.getExtender(natureId);
            if (extender != null && (rules = extender.getAdditionalRules()) != null) {
                extraRules.addAll(rules);
            }
            ++n2;
        }
        return extraRules;
    }

    public List<IRule> getInitialAdditionalRulesForProject(IProject project) throws CoreException {
        String[] natureIds;
        if (project == null) {
            return null;
        }
        ArrayList<IRule> extraRules = new ArrayList<IRule>();
        String[] stringArray = natureIds = project.getDescription().getNatureIds();
        int n = natureIds.length;
        int n2 = 0;
        while (n2 < n) {
            List<IRule> rules;
            String natureId = stringArray[n2];
            IHighlightingExtender extender = this.getExtender(natureId);
            if (extender != null && extender instanceof IHighlightingExtender2 && (rules = ((IHighlightingExtender2)extender).getInitialAdditionalRules()) != null) {
                extraRules.addAll(rules);
            }
            ++n2;
        }
        return extraRules;
    }
}

