/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.highlighting;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.editor.highlighting.GatherSemanticReferences;
import org.codehaus.groovy.eclipse.editor.highlighting.HighlightedTypedPosition;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingPresenter;
import org.eclipse.jdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.jdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovySemanticReconciler
implements IJavaReconcilingListener {
    private static final String GROOVY_HIGHLIGHT_PREFERENCE = "groovy.editor.highlight.gjdk.color".replaceFirst("\\.color$", "");
    private static final String STRING_HIGHLIGHT_PREFERENCE = "groovy.editor.highlight.strings.color".replaceFirst("\\.color$", "");
    private static final String NUMBER_HIGHLIGHT_PREFERENCE = "semanticHighlighting.number";
    private static final String VARIABLE_HIGHLIGHT_PREFERENCE = "semanticHighlighting.localVariable";
    private static final String PARAMETER_HIGHLIGHT_PREFERENCE = "semanticHighlighting.parameterVariable";
    private static final String ANNOTATION_HIGHLIGHT_PREFERENCE = "semanticHighlighting.annotationElementReference";
    private static final String DEPRECATED_HIGHLIGHT_PREFERENCE = "semanticHighlighting.deprecatedMember";
    private static final String OBJECT_FIELD_HIGHLIGHT_PREFERENCE = "semanticHighlighting.field";
    private static final String STATIC_FIELD_HIGHLIGHT_PREFERENCE = "semanticHighlighting.staticField";
    private static final String STATIC_VALUE_HIGHLIGHT_PREFERENCE = "semanticHighlighting.staticFinalField";
    private static final String OBJECT_METHOD_HIGHLIGHT_PREFERENCE = "semanticHighlighting.method";
    private static final String STATIC_METHOD_HIGHLIGHT_PREFERENCE = "semanticHighlighting.staticMethodInvocation";
    private static final String METHOD_DECLARATION_HIGHLIGHT_PREFERENCE = "semanticHighlighting.methodDeclarationName";
    private static Method GET_HIGHLIGHTING = null;
    private static Constructor<?> HIGHLIGHTING_STYLE;
    private static Constructor<?> HIGHLIGHTED_POSITION;
    private volatile GroovyEditor editor;
    private final Semaphore lock = new Semaphore(1);
    private SemanticHighlightingPresenter presenter;
    private Object mapKeyHighlighting;
    private Object tagKeyHighlighting;
    private Object numberRefHighlighting;
    private Object regexpRefHighlighting;
    private Object undefinedRefHighlighting;
    private Object deprecatedRefHighlighting;
    private Object localHighlighting;
    private Object paramHighlighting;
    private Object objectFieldHighlighting;
    private Object staticFieldHighlighting;
    private Object staticValueHighlighting;
    private Object methodDefHighlighting;
    private Object methodUseHighlighting;
    private Object groovyMethodUseHighlighting;
    private Object staticMethodUseHighlighting;

    static {
        try {
            Class<?> style = Class.forName("org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingManager$Highlighting");
            HIGHLIGHTING_STYLE = ReflectionUtils.getConstructor(style, (Class[])new Class[]{TextAttribute.class, Boolean.TYPE});
            Class<?> position = Class.forName("org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingManager$HighlightedPosition");
            HIGHLIGHTED_POSITION = ReflectionUtils.getConstructor(position, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, style, Object.class});
            GET_HIGHLIGHTING = position.getDeclaredMethod("getHighlighting", new Class[0]);
            GET_HIGHLIGHTING.setAccessible(true);
        }
        catch (ClassNotFoundException cnfe) {
            HIGHLIGHTING_STYLE = null;
            HIGHLIGHTED_POSITION = null;
            GroovyPlugin.getDefault().logException("Semantic highlighting disabled", cnfe);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    public GroovySemanticReconciler() {
        IPreferenceStore javaPrefs = JavaPlugin.getDefault().getPreferenceStore();
        IPreferenceStore groovyPrefs = GroovyPlugin.getDefault().getPreferenceStore();
        Color groovyColor = GroovySemanticReconciler.loadColorFrom(groovyPrefs, GROOVY_HIGHLIGHT_PREFERENCE);
        Color numberColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, NUMBER_HIGHLIGHT_PREFERENCE);
        Color stringColor = GroovySemanticReconciler.loadColorFrom(groovyPrefs, STRING_HIGHLIGHT_PREFERENCE);
        Color tagKeyColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, ANNOTATION_HIGHLIGHT_PREFERENCE);
        Color parameterColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, PARAMETER_HIGHLIGHT_PREFERENCE);
        Color variableColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, VARIABLE_HIGHLIGHT_PREFERENCE);
        Color objectFieldColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, OBJECT_FIELD_HIGHLIGHT_PREFERENCE);
        Color staticFieldColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, STATIC_FIELD_HIGHLIGHT_PREFERENCE);
        Color staticValueColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, STATIC_VALUE_HIGHLIGHT_PREFERENCE);
        Color staticCallColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, STATIC_METHOD_HIGHLIGHT_PREFERENCE);
        Color methodCallColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, OBJECT_METHOD_HIGHLIGHT_PREFERENCE);
        Color methodDeclColor = GroovySemanticReconciler.loadColorFrom(javaPrefs, METHOD_DECLARATION_HIGHLIGHT_PREFERENCE);
        this.mapKeyHighlighting = this.newHighlightingStyle(stringColor);
        this.tagKeyHighlighting = this.newHighlightingStyle(tagKeyColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, ANNOTATION_HIGHLIGHT_PREFERENCE));
        this.numberRefHighlighting = this.newHighlightingStyle(numberColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, NUMBER_HIGHLIGHT_PREFERENCE));
        this.regexpRefHighlighting = this.newHighlightingStyle(stringColor, 2 | GroovySemanticReconciler.loadStyleFrom(groovyPrefs, STRING_HIGHLIGHT_PREFERENCE));
        this.deprecatedRefHighlighting = this.newHighlightingStyle(null, GroovySemanticReconciler.loadStyleFrom(javaPrefs, DEPRECATED_HIGHLIGHT_PREFERENCE));
        this.undefinedRefHighlighting = this.newHighlightingStyle(null, 0x40000000);
        this.localHighlighting = this.newHighlightingStyle(variableColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, VARIABLE_HIGHLIGHT_PREFERENCE));
        this.paramHighlighting = this.newHighlightingStyle(parameterColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, PARAMETER_HIGHLIGHT_PREFERENCE));
        this.objectFieldHighlighting = this.newHighlightingStyle(objectFieldColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, OBJECT_FIELD_HIGHLIGHT_PREFERENCE));
        this.staticFieldHighlighting = this.newHighlightingStyle(staticFieldColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, STATIC_FIELD_HIGHLIGHT_PREFERENCE));
        this.staticValueHighlighting = this.newHighlightingStyle(staticValueColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, STATIC_VALUE_HIGHLIGHT_PREFERENCE));
        this.methodDefHighlighting = this.newHighlightingStyle(methodDeclColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, METHOD_DECLARATION_HIGHLIGHT_PREFERENCE));
        this.methodUseHighlighting = this.newHighlightingStyle(methodCallColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, OBJECT_METHOD_HIGHLIGHT_PREFERENCE));
        this.groovyMethodUseHighlighting = this.newHighlightingStyle(groovyColor, GroovySemanticReconciler.loadStyleFrom(groovyPrefs, GROOVY_HIGHLIGHT_PREFERENCE));
        this.staticMethodUseHighlighting = this.newHighlightingStyle(staticCallColor, GroovySemanticReconciler.loadStyleFrom(javaPrefs, STATIC_METHOD_HIGHLIGHT_PREFERENCE));
    }

    protected static Color loadColorFrom(IPreferenceStore prefs, String which) {
        if (prefs.contains(String.valueOf(which) + ".enabled") && !prefs.getBoolean(String.valueOf(which) + ".enabled")) {
            return null;
        }
        RGB color = PreferenceConverter.getColor((IPreferenceStore)prefs, (String)(String.valueOf(which) + ".color"));
        return GroovyPlugin.getDefault().getTextTools().getColorManager().getColor(color);
    }

    protected static int loadStyleFrom(IPreferenceStore prefs, String which) {
        int style = 0;
        if (!prefs.contains(String.valueOf(which) + ".enabled") || prefs.getBoolean(String.valueOf(which) + ".enabled")) {
            if (prefs.getBoolean(String.valueOf(which) + ".bold") || prefs.getBoolean(String.valueOf(which) + ".color_bold")) {
                style |= 1;
            }
            if (prefs.getBoolean(String.valueOf(which) + ".italic")) {
                style |= 2;
            }
            if (prefs.getBoolean(String.valueOf(which) + ".underline")) {
                style |= 0x40000000;
            }
            if (prefs.getBoolean(String.valueOf(which) + ".strikethrough")) {
                style |= 0x20000000;
            }
        }
        return style;
    }

    protected Object newHighlightingStyle(Color color) {
        return ReflectionUtils.invokeConstructor(HIGHLIGHTING_STYLE, (Object[])new Object[]{new TextAttribute(color), Boolean.TRUE});
    }

    protected Object newHighlightingStyle(Color color, int style) {
        return ReflectionUtils.invokeConstructor(HIGHLIGHTING_STYLE, (Object[])new Object[]{new TextAttribute(color, null, style), Boolean.TRUE});
    }

    public void install(GroovyEditor editor, JavaSourceViewer viewer) {
        this.editor = editor;
        this.presenter = new SemanticHighlightingPresenter();
        this.presenter.install(viewer, (JavaPresentationReconciler)editor.getGroovyConfiguration().getPresentationReconciler((ISourceViewer)viewer));
    }

    public void uninstall() {
        this.presenter.uninstall();
        this.presenter = null;
        this.editor = null;
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(CompilationUnit ast, boolean forced, IProgressMonitor monitor) {
        block19: {
            if (ast != null && this.lock.tryAcquire()) {
                try {
                    if (this.editor == null) {
                        return;
                    }
                    monitor.beginTask("Groovy semantic highlighting", 10);
                    GroovyCompilationUnit unit = this.editor.getGroovyCompilationUnit();
                    if (unit == null) break block19;
                    this.presenter.setCanceled(monitor.isCanceled());
                    if (this.update(monitor, 1)) {
                        return;
                    }
                    GatherSemanticReferences finder = new GatherSemanticReferences(unit);
                    Collection<HighlightedTypedPosition> semanticReferences = finder.findSemanticHighlightingReferences();
                    if (this.update(monitor, 5)) {
                        return;
                    }
                    ArrayList<Position> newPositions = new ArrayList<Position>(semanticReferences.size());
                    LinkedList<Position> oldPositions = new LinkedList<Position>(this.getHighlightedPositions());
                    if (this.update(monitor, 1)) {
                        return;
                    }
                    for (HighlightedTypedPosition ref : semanticReferences) {
                        Position pos = this.newHighlightedPosition(ref);
                        this.tryAddPosition(newPositions, oldPositions, pos);
                    }
                    if (this.update(monitor, 2)) {
                        return;
                    }
                    try {
                        TextPresentation textPresentation = null;
                        if (!this.presenter.isCanceled()) {
                            textPresentation = this.presenter.createPresentation(newPositions, oldPositions);
                        }
                        if (!this.presenter.isCanceled()) {
                            this.updatePresentation(textPresentation, newPositions, oldPositions);
                        }
                        this.update(monitor, 1);
                    }
                    catch (Exception e) {
                        GroovyCore.logException((String)"Semantic highlighting failed", (Throwable)e);
                    }
                }
                finally {
                    monitor.done();
                    this.lock.release();
                }
            }
        }
    }

    private boolean update(IProgressMonitor monitor, int units) {
        monitor.worked(units);
        return monitor.isCanceled();
    }

    private List<Position> getHighlightedPositions() {
        return (List)ReflectionUtils.getPrivateField(SemanticHighlightingPresenter.class, (String)"fPositions", (Object)this.presenter);
    }

    private Position newHighlightedPosition(HighlightedTypedPosition pos) {
        Object style = null;
        switch (pos.kind) {
            case DEPRECATED: {
                style = this.deprecatedRefHighlighting;
                break;
            }
            case UNKNOWN: {
                style = this.undefinedRefHighlighting;
                break;
            }
            case NUMBER: {
                style = this.numberRefHighlighting;
                break;
            }
            case REGEXP: {
                style = this.regexpRefHighlighting;
                break;
            }
            case MAP_KEY: {
                style = this.mapKeyHighlighting;
                break;
            }
            case TAG_KEY: {
                style = this.tagKeyHighlighting;
                break;
            }
            case VARIABLE: {
                style = this.localHighlighting;
                break;
            }
            case PARAMETER: {
                style = this.paramHighlighting;
                break;
            }
            case FIELD: {
                style = this.objectFieldHighlighting;
                break;
            }
            case STATIC_FIELD: {
                style = this.staticFieldHighlighting;
                break;
            }
            case STATIC_VALUE: {
                style = this.staticValueHighlighting;
                break;
            }
            case CTOR: 
            case METHOD: 
            case STATIC_METHOD: {
                style = this.methodDefHighlighting;
                break;
            }
            case CTOR_CALL: 
            case METHOD_CALL: {
                style = this.methodUseHighlighting;
                break;
            }
            case GROOVY_CALL: {
                style = this.groovyMethodUseHighlighting;
                break;
            }
            case STATIC_CALL: {
                style = this.staticMethodUseHighlighting;
            }
        }
        return (Position)ReflectionUtils.invokeConstructor(HIGHLIGHTED_POSITION, (Object[])new Object[]{pos.offset, pos.length, style, this});
    }

    private void tryAddPosition(List<Position> newPositions, List<Position> oldPositions, Position maybePosition) {
        boolean found = false;
        Iterator<Position> it = oldPositions.iterator();
        while (it.hasNext()) {
            Position oldPosition = it.next();
            if (oldPosition.isDeleted() || !oldPosition.equals((Object)maybePosition) || !this.isSameStyle(oldPosition, maybePosition)) continue;
            found = true;
            it.remove();
            break;
        }
        if (!found) {
            newPositions.add(maybePosition);
        }
    }

    private boolean isSameStyle(Position a, Position b) {
        if (GET_HIGHLIGHTING != null) {
            try {
                return GET_HIGHLIGHTING.invoke((Object)a, new Object[0]) == GET_HIGHLIGHTING.invoke((Object)b, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return true;
    }

    private void updatePresentation(TextPresentation textPresentation, List<Position> addedPositions, List<Position> removedPositions) {
        Runnable runnable = this.presenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        GroovyEditor thisEditor = this.editor;
        if (thisEditor == null) {
            return;
        }
        IWorkbenchPartSite site = thisEditor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }
}

