/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.highlighting;

import java.util.Collection;
import java.util.Collections;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.editor.highlighting.HighlightedTypedPosition;
import org.codehaus.groovy.eclipse.editor.highlighting.SemanticHighlightingReferenceRequestor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatherSemanticReferences {
    private final GroovyCompilationUnit unit;
    private static TypeInferencingVisitorFactory factory = new TypeInferencingVisitorFactory();

    public GatherSemanticReferences(GroovyCompilationUnit unit) {
        this.unit = GatherSemanticReferences.isSemanticHighlightingEnabled() ? unit : null;
    }

    public Collection<HighlightedTypedPosition> findSemanticHighlightingReferences() {
        if (this.unit != null) {
            try {
                SemanticHighlightingReferenceRequestor requestor = new SemanticHighlightingReferenceRequestor(this.unit);
                TypeInferencingVisitorWithRequestor visitor = factory.createVisitor(this.unit);
                visitor.visitCompilationUnit((ITypeRequestor)requestor);
                return requestor.typedPosition;
            }
            catch (Exception e) {
                GroovyCore.logException((String)"Semantic highlighting gather failed", (Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    private static boolean isSemanticHighlightingEnabled() {
        IPreferenceStore prefs = GroovyPlugin.getDefault().getPreferenceStore();
        return prefs.getBoolean("groovy.semantic.highlighting");
    }
}

