/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.actions;

import java.util.ResourceBundle;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyIndentationService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.TextEditorAction;

public class GroovyTabAction
extends TextEditorAction {
    private static final String BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.jdt.internal.ui.javaeditor.ConstructedJavaEditorMessages";
    private static ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle("org.eclipse.jdt.internal.ui.javaeditor.ConstructedJavaEditorMessages");

    public GroovyTabAction(ITextEditor editor) {
        super(fgBundleForConstructedKeys, "Indent.", editor);
    }

    public GroovyIndentationService getIndentor() {
        return GroovyIndentationService.get((IJavaProject)this.getJavaProject());
    }

    public void run() {
        if (!this.isEnabled() || !this.validateEditorInputState()) {
            return;
        }
        ITextSelection selection = this.getSelection();
        IDocument d = this.getDocument();
        if (d != null) {
            try {
                int offset = selection.getOffset();
                Assert.isTrue((selection.getLength() == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)this.isInSmartTabRegion(d, offset));
                int tabLine = d.getLineOfOffset(offset);
                int newIndentLevel = this.getIndentor().computeIndentForLine(d, tabLine);
                String lineStartText = GroovyIndentationService.getLineTextUpto((IDocument)d, (int)offset);
                int cursorIndent = this.getIndentor().indentLevel(lineStartText);
                if (cursorIndent < newIndentLevel) {
                    String leadingWhiteSpace = GroovyIndentationService.getLineLeadingWhiteSpace((IDocument)d, (int)tabLine);
                    int editOffset = d.getLineOffset(tabLine);
                    int editLength = leadingWhiteSpace.length();
                    String editText = this.getIndentor().createIndentation(newIndentLevel);
                    d.replace(editOffset, editLength, editText);
                    this.selectAndReveal(editOffset + editText.length(), 0);
                } else {
                    String editText = this.getIndentor().getTabString();
                    d.replace(offset, 0, editText);
                    this.selectAndReveal(offset + editText.length(), 0);
                }
            }
            catch (Throwable e) {
                GroovyCore.logException((String)"something went wrong in smart tab", (Throwable)e);
            }
        }
    }

    private boolean isInSmartTabRegion(IDocument d, int offset) throws BadLocationException {
        String lineStartText = GroovyIndentationService.getLineTextUpto((IDocument)d, (int)offset);
        return lineStartText.trim().equals("");
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor() && this.isSmartMode() && this.isValidSelection());
        }
    }

    private boolean isValidSelection() {
        ITextSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        int offset = selection.getOffset();
        int length = selection.getLength();
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        try {
            IRegion firstLine = document.getLineInformationOfOffset(offset);
            int lineOffset = firstLine.getOffset();
            if (length == 0) {
                return document.get(lineOffset, offset - lineOffset).trim().length() == 0;
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isSmartMode() {
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof ITextEditorExtension3) {
            return ((ITextEditorExtension3)editor).getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    private IDocument getDocument() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            if (provider != null && input != null) {
                return provider.getDocument((Object)input);
            }
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return null;
        }
        ICompilationUnit cu = JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (cu == null) {
            return null;
        }
        return cu.getJavaProject();
    }

    private ITextSelection getSelection() {
        ISelection selection;
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    private ISelectionProvider getSelectionProvider() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            return editor.getSelectionProvider();
        }
        return null;
    }

    private void selectAndReveal(int newOffset, int newLength) {
        Assert.isTrue((newOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((newLength >= 0 ? 1 : 0) != 0);
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof JavaEditor) {
            ISourceViewer viewer = ((JavaEditor)editor).getViewer();
            if (viewer != null) {
                viewer.setSelectedRange(newOffset, newLength);
            }
        } else {
            this.getTextEditor().selectAndReveal(newOffset, newLength);
        }
    }
}

