/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.CombinedWordRule;
import org.eclipse.jdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.jdt.internal.ui.text.JavaWordDetector;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyTagScanner
extends AbstractJavaScanner {
    private static final String[] types = new String[]{"boolean", "byte", "char", "class", "double", "float", "int", "interface", "long", "short", "void"};
    private static final String[] keywords = new String[]{"abstract", "assert", "break", "case", "catch", "const", "continue", "default", "do", "else", "enum", "extends", "false", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "interface", "native", "new", "null", "package", "private", "protected", "public", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final String[] groovyKeywords = new String[]{"as", "in", "def", "trait"};
    private static final String returnKeyword = "return";
    private static final String[] fgTokenProperties = new String[]{"groovy.editor.highlight.default.color", "groovy.editor.highlight.gjdk.color", "groovy.editor.highlight.javakeywords.color", "groovy.editor.highlight.groovykeywords.color", "groovy.editor.highlight.javatypes.color", "groovy.editor.highlight.annotation.color", "groovy.editor.highlight.bracket.color", "groovy.editor.highlight.operator.color", "groovy.editor.highlight.return.color", "groovy.editor.highlight.strings.color"};
    private final List<IRule> initialAdditionalRules;
    private final List<IRule> additionalRules;
    private final List<String> additionalGroovyKeywords;
    private final List<String> additionalGJDKWords;

    @Deprecated
    public GroovyTagScanner(IColorManager manager) {
        this(manager, null, null, null);
    }

    @Deprecated
    public GroovyTagScanner(IColorManager manager, List<IRule> initialAdditionalRules, List<IRule> additionalRules, List<String> additionalGroovyKeywords) {
        this(manager, initialAdditionalRules, additionalRules, additionalGroovyKeywords, null);
    }

    public GroovyTagScanner(IColorManager manager, List<IRule> initialAdditionalRules, List<IRule> additionalRules, List<String> additionalGroovyKeywords, List<String> additionalGJDKKeywords) {
        super(manager, GroovyPlugin.getDefault().getPreferenceStore());
        this.initialAdditionalRules = initialAdditionalRules;
        this.additionalRules = additionalRules;
        this.additionalGroovyKeywords = additionalGroovyKeywords;
        this.additionalGJDKWords = additionalGJDKKeywords;
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        if (this.initialAdditionalRules != null) {
            rules.addAll(this.initialAdditionalRules);
        }
        Token token = this.getToken("groovy.editor.highlight.strings.color");
        rules.add((IRule)new SingleLineRule("'", "'", (IToken)token, '\\'));
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        AnnotationRule atInterfaceRule = new AnnotationRule((IToken)this.getToken("groovy.editor.highlight.annotation.color"), this.getToken("groovy.editor.highlight.annotation.color"));
        rules.add(atInterfaceRule);
        JavaWordDetector wordDetector = new JavaWordDetector();
        token = this.getToken("groovy.editor.highlight.default.color");
        CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)wordDetector, (IToken)token);
        CombinedWordRule.WordMatcher javaKeywordsMatcher = new CombinedWordRule.WordMatcher();
        token = this.getToken("groovy.editor.highlight.javakeywords.color");
        int i = 0;
        while (i < keywords.length) {
            javaKeywordsMatcher.addWord(keywords[i], (IToken)token);
            ++i;
        }
        combinedWordRule.addWordMatcher(javaKeywordsMatcher);
        CombinedWordRule.WordMatcher javaTypesMatcher = new CombinedWordRule.WordMatcher();
        token = this.getToken("groovy.editor.highlight.javatypes.color");
        int i2 = 0;
        while (i2 < types.length) {
            javaTypesMatcher.addWord(types[i2], (IToken)token);
            ++i2;
        }
        combinedWordRule.addWordMatcher(javaTypesMatcher);
        CombinedWordRule.WordMatcher groovyKeywordsMatcher = new CombinedWordRule.WordMatcher();
        token = this.getToken("groovy.editor.highlight.groovykeywords.color");
        int i3 = 0;
        while (i3 < groovyKeywords.length) {
            groovyKeywordsMatcher.addWord(groovyKeywords[i3], (IToken)token);
            ++i3;
        }
        if (this.additionalGroovyKeywords != null) {
            for (String additional : this.additionalGroovyKeywords) {
                groovyKeywordsMatcher.addWord(additional, (IToken)token);
            }
        }
        combinedWordRule.addWordMatcher(groovyKeywordsMatcher);
        CombinedWordRule.WordMatcher gjdkWordsMatcher = new CombinedWordRule.WordMatcher();
        token = this.getToken("groovy.editor.highlight.gjdk.color");
        if (this.additionalGJDKWords != null) {
            for (String additional : this.additionalGJDKWords) {
                gjdkWordsMatcher.addWord(additional, (IToken)token);
            }
        }
        combinedWordRule.addWordMatcher(gjdkWordsMatcher);
        token = this.getToken("groovy.editor.highlight.bracket.color");
        rules.add(new BracketRule((IToken)token));
        token = this.getToken("groovy.editor.highlight.operator.color");
        rules.add(new OperatorRule((IToken)token));
        CombinedWordRule.WordMatcher returnWordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken("groovy.editor.highlight.return.color");
        returnWordRule.addWord(returnKeyword, (IToken)token);
        combinedWordRule.addWordMatcher(returnWordRule);
        rules.add((IRule)combinedWordRule);
        if (this.additionalRules != null) {
            rules.addAll(this.additionalRules);
        }
        this.setDefaultReturnToken((IToken)this.getToken("groovy.editor.highlight.default.color"));
        return rules;
    }

    private static class AnnotationRule
    implements IRule {
        private final IWhitespaceDetector fWhitespaceDetector = new JavaWhitespaceDetector();
        private final IWordDetector fWordDetector = new JavaWordDetector();
        private final IToken fInterfaceToken;
        private final IToken fAnnotationToken;

        public AnnotationRule(IToken interfaceToken, Token annotationToken) {
            this.fInterfaceToken = interfaceToken;
            this.fAnnotationToken = annotationToken;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            ResettableScanner resettable = new ResettableScanner(scanner);
            if (resettable.read() == 64 && this.skipWhitespace(resettable)) {
                return this.readAnnotation(resettable);
            }
            resettable.reset();
            return Token.UNDEFINED;
        }

        private IToken readAnnotation(ResettableScanner scanner) {
            StringBuffer buffer = new StringBuffer();
            if (!this.readIdentifier(scanner, buffer)) {
                scanner.reset();
                return Token.UNDEFINED;
            }
            if ("interface".equals(buffer.toString())) {
                return this.fInterfaceToken;
            }
            while (this.readSegment(new ResettableScanner(scanner))) {
            }
            return this.fAnnotationToken;
        }

        private boolean readSegment(ResettableScanner scanner) {
            scanner.mark();
            if (this.skipWhitespace(scanner) && this.skipDot(scanner) && this.skipWhitespace(scanner) && this.readIdentifier(scanner, null)) {
                return true;
            }
            scanner.reset();
            return false;
        }

        private boolean skipDot(ICharacterScanner scanner) {
            int ch = scanner.read();
            if (ch == 46) {
                return true;
            }
            scanner.unread();
            return false;
        }

        private boolean readIdentifier(ICharacterScanner scanner, StringBuffer buffer) {
            int ch = scanner.read();
            boolean read = false;
            while (this.fWordDetector.isWordPart((char)ch)) {
                if (buffer != null) {
                    buffer.append((char)ch);
                }
                ch = scanner.read();
                read = true;
            }
            if (ch != -1) {
                scanner.unread();
            }
            return read;
        }

        private boolean skipWhitespace(ICharacterScanner scanner) {
            while (this.fWhitespaceDetector.isWhitespace((char)scanner.read())) {
            }
            scanner.unread();
            return true;
        }

        private static final class ResettableScanner
        implements ICharacterScanner {
            private final ICharacterScanner fDelegate;
            private int fReadCount;

            public ResettableScanner(ICharacterScanner scanner) {
                Assert.isNotNull((Object)scanner);
                this.fDelegate = scanner;
                this.mark();
            }

            public int getColumn() {
                return this.fDelegate.getColumn();
            }

            public char[][] getLegalLineDelimiters() {
                return this.fDelegate.getLegalLineDelimiters();
            }

            public int read() {
                int ch = this.fDelegate.read();
                if (ch != -1) {
                    ++this.fReadCount;
                }
                return ch;
            }

            public void unread() {
                if (this.fReadCount > 0) {
                    --this.fReadCount;
                }
                this.fDelegate.unread();
            }

            public void mark() {
                this.fReadCount = 0;
            }

            public void reset() {
                while (this.fReadCount > 0) {
                    this.unread();
                }
                while (this.fReadCount < 0) {
                    this.read();
                }
            }
        }
    }

    private static final class BracketRule
    implements IRule {
        private final char[] JAVA_BRACKETS = new char[]{'(', ')', '{', '}', '[', ']'};
        private final IToken fToken;

        public BracketRule(IToken token) {
            this.fToken = token;
        }

        public boolean isBracket(char character) {
            int index = 0;
            while (index < this.JAVA_BRACKETS.length) {
                if (this.JAVA_BRACKETS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isBracket((char)character)) {
                while (this.isBracket((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    protected class OperatorRule
    implements IRule {
        private final char[] JAVA_OPERATORS = new char[]{';', '(', ')', '{', '}', '.', '=', '/', '\\', '+', '-', '*', '[', ']', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};
        private final IToken fToken;

        public OperatorRule(IToken token) {
            this.fToken = token;
        }

        public boolean isOperator(char character) {
            int index = 0;
            while (index < this.JAVA_OPERATORS.length) {
                if (this.JAVA_OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isOperator((char)character)) {
                while (this.isOperator((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }
}

