/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String GROOVY_MULTILINE_STRINGS = "__groovy_multiline_string";
    public static final String[] LEGAL_CONTENT_TYPES = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character", "__groovy_multiline_string"};

    public GroovyPartitionScanner() {
        List<IRule> rules = GroovyPartitionScanner.createRules(false);
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }

    public static List<IRule> createRules(boolean withColor) {
        String objComment;
        String objmString;
        String objsString;
        String objsComment;
        String objdComment;
        IPreferenceStore store = GroovyPlugin.getDefault().getPreferenceStore();
        if (withColor) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"groovy.editor.highlight.strings.color");
            objsComment = objdComment = new TextAttribute(new Color(null, rgb), null, 2);
            objsString = objdComment;
            objmString = objdComment;
            objComment = objdComment;
        } else {
            objComment = "__java_multiline_comment";
            objmString = GROOVY_MULTILINE_STRINGS;
            objsString = "__java_string";
            objsComment = "__java_singleline_comment";
            objdComment = "__java_javadoc";
        }
        Token comment = new Token((Object)objComment);
        Token mString = new Token((Object)objmString);
        Token sString = new Token((Object)objsString);
        Token sComment = new Token((Object)objsComment);
        Token jdoc = new Token((Object)objdComment);
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new EndOfLineRule("//", (IToken)sComment));
        rules.add((IRule)new MultiLineRule("'''", "'''", (IToken)mString));
        rules.add((IRule)new MultiLineRule("\"\"\"", "\"\"\"", (IToken)mString));
        rules.add((IRule)new SingleLineRule("\"", "\"", (IToken)sString, '\\'));
        rules.add((IRule)new SingleLineRule("'", "'", (IToken)sString, '\\'));
        rules.add((IRule)new WordPredicateRule((IToken)comment));
        rules.add((IRule)new MultiLineRule("/**", "*/", (IToken)jdoc, '\u0000', true));
        rules.add((IRule)new MultiLineRule("/*", "*/", (IToken)comment, '\u0000', true));
        return rules;
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class WordPredicateRule
    extends WordRule
    implements IPredicateRule {
        private final IToken fSuccessToken;

        public WordPredicateRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return super.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }
}

