/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.eclipse.codebrowsing.elements.IGroovyResolvedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.debug.ui.JavaDebugHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class GroovyExtraInformationHover
extends JavadocHover {
    private final boolean alwaysReturnInformation;
    private final JavaDebugHover debugHover;

    public GroovyExtraInformationHover() {
        this.alwaysReturnInformation = false;
        this.debugHover = new JavaDebugHover();
    }

    public GroovyExtraInformationHover(boolean alwaysReturnInformation) {
        this.alwaysReturnInformation = alwaysReturnInformation;
        this.debugHover = new JavaDebugHover();
    }

    public void setEditor(IEditorPart editor) {
        super.setEditor(editor);
        this.debugHover.setEditor(editor);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        Object o;
        IEditorPart editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        if (!ContentTypeUtils.isGroovyLikeFileName((String)file.getName())) {
            return null;
        }
        if (!this.alwaysReturnInformation && (o = this.debugHover.getHoverInfo2(textViewer, hoverRegion)) != null) {
            return null;
        }
        IJavaElement[] elements = this.getJavaElementsAt(textViewer, hoverRegion);
        if (this.shouldComputeHover(elements)) {
            return this.computeHover(hoverRegion, elements);
        }
        return null;
    }

    private boolean shouldComputeHover(IJavaElement[] elements) {
        if (elements != null && elements.length == 1) {
            IGroovyResolvedElement resolvedElt;
            if (this.alwaysReturnInformation) {
                return true;
            }
            if (elements[0] instanceof IGroovyResolvedElement && (resolvedElt = (IGroovyResolvedElement)elements[0]).getExtraDoc() != null && resolvedElt.getExtraDoc().length() > 0) {
                return true;
            }
        }
        return false;
    }

    private Object computeHover(IRegion hoverRegion, IJavaElement[] elements) {
        Object[] objectArray = new Object[4];
        objectArray[0] = elements;
        objectArray[1] = this.getEditorInputJavaElement();
        objectArray[2] = hoverRegion;
        Object hover = ReflectionUtils.executePrivateMethod(JavadocHover.class, (String)"getHoverInfo", (Class[])new Class[]{IJavaElement[].class, ITypeRoot.class, IRegion.class, JavadocBrowserInformationControlInput.class}, (Object)((Object)this), (Object[])objectArray);
        if (hover instanceof JavadocBrowserInformationControlInput && elements[0] instanceof IGroovyResolvedElement) {
            JavadocBrowserInformationControlInput input = (JavadocBrowserInformationControlInput)hover;
            hover = new JavadocBrowserInformationControlInput((JavadocBrowserInformationControlInput)input.getPrevious(), input.getElement(), this.wrapHTML(input, (IGroovyResolvedElement)elements[0]), input.getLeadingImageWidth());
        }
        return hover;
    }

    protected String wrapHTML(JavadocBrowserInformationControlInput input, IGroovyResolvedElement elt) {
        String preamble = !elt.getElementName().equals(elt.getInferredElementName()) ? this.createLabel(elt.getInferredElement()) : "";
        if (elt.getExtraDoc() != null) {
            String wrapped = String.valueOf(preamble) + this.extraDocAsHtml(elt) + "\n<br/><hr/><br/>\n" + input.getHtml();
            return wrapped;
        }
        return String.valueOf(preamble) + input.getHtml();
    }

    protected String extraDocAsHtml(IGroovyResolvedElement elt) {
        String extraDoc = "/**" + elt.getExtraDoc() + "*/";
        if (!extraDoc.startsWith("/**")) {
            extraDoc = "/**" + extraDoc;
        }
        if (!extraDoc.endsWith("*/")) {
            extraDoc = String.valueOf(extraDoc) + "*/";
        }
        return (String)ReflectionUtils.executePrivateMethod(JavadocContentAccess2.class, (String)"javadoc2HTML", (Class[])new Class[]{IMember.class, String.class}, null, (Object[])new Object[]{elt, extraDoc});
    }

    private String createLabel(ASTNode inferredElement) {
        if (inferredElement instanceof PropertyNode) {
            inferredElement = ((PropertyNode)inferredElement).getField();
        }
        String label = inferredElement instanceof ClassNode ? this.createClassLabel((ClassNode)inferredElement) : (inferredElement instanceof MethodNode ? this.createMethodLabel((MethodNode)inferredElement) : (inferredElement instanceof FieldNode ? this.createFieldLabel((FieldNode)inferredElement) : inferredElement.getText()));
        return "<b>" + label + "</b><br>\n";
    }

    private String createFieldLabel(FieldNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createClassLabel(node.getType()));
        sb.append(" ");
        sb.append(this.createClassLabel(node.getDeclaringClass()));
        sb.append(".");
        sb.append(node.getName());
        return sb.toString();
    }

    private String createMethodLabel(MethodNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createClassLabel(node.getReturnType()));
        sb.append(" ");
        sb.append(this.createClassLabel(node.getDeclaringClass()));
        sb.append(".");
        sb.append(node.getName());
        sb.append("(");
        Parameter[] params = node.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                sb.append(this.createClassLabel(params[i].getType()));
                sb.append(" " + params[i].getName());
                if (i < params.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private String createClassLabel(ClassNode node) {
        StringBuilder sb = new StringBuilder();
        if (ClassHelper.DYNAMIC_TYPE == (node = node.redirect())) {
            return "def";
        }
        sb.append(node.getNameWithoutPackage());
        GenericsType[] genericsTypes = node.getGenericsTypes();
        if (genericsTypes != null && genericsTypes.length > 0) {
            sb.append(" <");
            int i = 0;
            while (i < genericsTypes.length) {
                sb.append(genericsTypes[i].getName());
                if (i < genericsTypes.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append("> ");
        }
        return sb.toString();
    }
}

