/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.editor.GroovyConfiguration;
import org.codehaus.groovy.eclipse.editor.GroovyTextTools;
import org.codehaus.groovy.eclipse.editor.ISurroundWithFactory;
import org.codehaus.groovy.eclipse.editor.NoopCleanUpsAction;
import org.codehaus.groovy.eclipse.editor.actions.ExpandSelectionAction;
import org.codehaus.groovy.eclipse.editor.actions.GroovyConvertLocalToFieldAction;
import org.codehaus.groovy.eclipse.editor.actions.GroovyExtractConstantAction;
import org.codehaus.groovy.eclipse.editor.actions.GroovyExtractLocalAction;
import org.codehaus.groovy.eclipse.editor.actions.GroovyExtractMethodAction;
import org.codehaus.groovy.eclipse.editor.actions.GroovyTabAction;
import org.codehaus.groovy.eclipse.editor.highlighting.GroovySemanticReconciler;
import org.codehaus.groovy.eclipse.editor.outline.GroovyOutlinePage;
import org.codehaus.groovy.eclipse.editor.outline.OutlineExtenderRegistry;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatAllGroovyAction;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatGroovyAction;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyRenameAction;
import org.codehaus.groovy.eclipse.refactoring.actions.OrganizeGroovyImportsAction;
import org.codehaus.groovy.eclipse.search.GroovyOccurrencesFinder;
import org.codehaus.groovy.eclipse.ui.decorators.GroovyImageDecorator;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.debug.ui.BreakpointMarkerUpdater;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.AllCleanUpsAction;
import org.eclipse.jdt.internal.ui.actions.CleanUpAction;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.actions.SurroundWithActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaOutlinePage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class GroovyEditor
extends CompilationUnitEditor {
    public static final String EDITOR_ID = "org.codehaus.groovy.eclipse.editor.GroovyEditor";
    private static final String INDENT_ON_TAB = "IndentOnTab";
    private GroovyImageDecorator decorator = new GroovyImageDecorator();
    private GroovySemanticReconciler semanticReconciler;
    private final GroovyBracketInserter groovyBracketInserter = new GroovyBracketInserter();
    IEditorInput internalInput;
    private OccurrencesFinderJob groovyOccurrencesFinderJob = null;
    private static final String CLOSE_STRINGS = "closeStrings";
    private static final String CLOSE_BRACKETS = "closeBrackets";
    private static final String CLOSE_BRACES = "closeBraces";
    private GroovyOutlinePage page;

    public GroovyEditor() {
        this.setRulerContextMenuId("#GroovyCompilationUnitRulerContext");
        this.setEditorContextMenuId("#GroovyCompilationUnitEditorContext");
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        ChainedPreferenceStore newStore = new ChainedPreferenceStore(new IPreferenceStore[]{store, GroovyPlugin.getDefault().getPreferenceStore()});
        super.setPreferenceStore((IPreferenceStore)newStore);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.createJavaSourceViewerConfiguration());
    }

    public GroovyConfiguration getGroovyConfiguration() {
        return (GroovyConfiguration)this.getSourceViewerConfiguration();
    }

    private void installGroovySemanticHighlighting() {
        try {
            this.fSemanticManager.uninstall();
            this.semanticReconciler = new GroovySemanticReconciler();
            this.semanticReconciler.install(this, (JavaSourceViewer)this.getSourceViewer());
            ReflectionUtils.executePrivateMethod(CompilationUnitEditor.class, (String)"addReconcileListener", (Class[])new Class[]{IJavaReconcilingListener.class}, (Object)((Object)this), (Object[])new Object[]{this.semanticReconciler});
        }
        catch (SecurityException e) {
            GroovyPlugin.getDefault().logException("Unable to install semantic reconciler for groovy editor", e);
        }
    }

    private void uninstallGroovySemanticHighlighting() {
        if (this.semanticHighlightingInstalled()) {
            try {
                this.semanticReconciler.uninstall();
                ReflectionUtils.executePrivateMethod(CompilationUnitEditor.class, (String)"removeReconcileListener", (Class[])new Class[]{IJavaReconcilingListener.class}, (Object)((Object)this), (Object[])new Object[]{this.semanticReconciler});
                this.semanticReconciler = null;
            }
            catch (SecurityException e) {
                GroovyPlugin.getDefault().logException("Unable to uninstall semantic reconciler for groovy editor", e);
            }
        }
    }

    private boolean semanticHighlightingInstalled() {
        return this.semanticReconciler != null;
    }

    public void dispose() {
        super.dispose();
        this.uninstallGroovySemanticHighlighting();
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.groovyBracketInserter);
        }
    }

    public IEditorInput getEditorInput() {
        return super.getEditorInput();
    }

    public int getCaretOffset() {
        ISourceViewer viewer = this.getSourceViewer();
        return viewer.getTextWidget().getCaretOffset();
    }

    public Image getTitleImage() {
        Image image;
        Object element = this.getEditorInput().getAdapter(IFile.class);
        if (element == null) {
            element = this.getEditorInput().getName();
        }
        return (image = this.decorator.decorateImage(null, element)) != null ? image : super.getTitleImage();
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        block10: {
            super.setSelection(reference, moveCursor);
            try {
                int length;
                int offset;
                if (!(reference instanceof IImportDeclaration) || !moveCursor) break block10;
                ISourceRange range = reference.getSourceRange();
                String content = reference.getSource();
                if (content != null) {
                    int start = Math.max(content.indexOf("import") + 6, 7);
                    while (start < content.length() && content.charAt(start) == ' ') {
                        ++start;
                    }
                    int end = content.trim().length();
                    while (--end >= 0 && (content.charAt(end) == ' ' || content.charAt(end) == ';')) {
                    }
                    offset = range.getOffset() + start;
                    length = end - start + 1;
                    int docLength = ((IImportDeclaration)reference).getOpenable().getBuffer().getLength();
                    if (docLength < offset + length) {
                        offset = docLength;
                    }
                } else {
                    offset = range.getOffset() + 1;
                    length = range.getLength() - 2;
                }
                if (offset <= -1 || length <= 0) break block10;
                try {
                    this.getSourceViewer().getTextWidget().setRedraw(false);
                    this.getSourceViewer().revealRange(offset, length);
                    this.getSourceViewer().setSelectedRange(offset, length);
                }
                finally {
                    this.getSourceViewer().getTextWidget().setRedraw(true);
                }
                this.markInNavigationHistory();
            }
            catch (JavaModelException e) {
                GroovyPlugin.getDefault().logException("Error selecting import statement", (Exception)((Object)e));
            }
        }
    }

    protected void createActions() {
        super.createActions();
        GenerateActionGroup group = this.getGenerateActionGroup();
        OrganizeGroovyImportsAction organizeGroovyImportsAction = new OrganizeGroovyImportsAction((JavaEditor)this);
        organizeGroovyImportsAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.organize.imports");
        this.setAction("OrganizeImports", (IAction)organizeGroovyImportsAction);
        ReflectionUtils.setPrivateField(GenerateActionGroup.class, (String)"fOrganizeImports", (Object)group, (Object)((Object)organizeGroovyImportsAction));
        FormatAllGroovyAction formatAllAction = new FormatAllGroovyAction((IWorkbenchSite)this.getEditorSite(), FormatKind.FORMAT);
        ReflectionUtils.setPrivateField(GenerateActionGroup.class, (String)"fFormatAll", (Object)group, (Object)((Object)formatAllAction));
        FormatGroovyAction formatAction = new FormatGroovyAction((IWorkbenchSite)this.getEditorSite(), FormatKind.FORMAT);
        formatAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.setAction("Format", (IAction)formatAction);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)formatAction, "org.eclipse.jdt.ui.format_action");
        FormatGroovyAction indentAction = new FormatGroovyAction((IWorkbenchSite)this.getEditorSite(), FormatKind.INDENT_ONLY);
        indentAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.indent");
        this.setAction("Indent", (IAction)indentAction);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)indentAction, "org.eclipse.jdt.ui.indent_action");
        GroovyTabAction indentOnTabAction = new GroovyTabAction((ITextEditor)this);
        this.setAction(INDENT_ON_TAB, (IAction)indentOnTabAction);
        this.markAsStateDependentAction(INDENT_ON_TAB, true);
        this.markAsSelectionDependentAction(INDENT_ON_TAB, true);
        AllCleanUpsAction acua = (AllCleanUpsAction)ReflectionUtils.getPrivateField(GenerateActionGroup.class, (String)"fCleanUp", (Object)group);
        if (acua != null) {
            acua.dispose();
            ReflectionUtils.setPrivateField(CleanUpAction.class, (String)"fEditor", (Object)acua, null);
        }
        ReflectionUtils.setPrivateField(GenerateActionGroup.class, (String)"fCleanUp", (Object)group, (Object)((Object)new NoopCleanUpsAction((IWorkbenchSite)this.getEditorSite())));
        this.removeRefactoringAction("fSelfEncapsulateField");
        this.removeRefactoringAction("fMoveAction");
        this.removeRefactoringAction("fModifyParametersAction");
        this.removeRefactoringAction("fIntroduceParameterAction");
        this.removeRefactoringAction("fIntroduceParameterObjectAction");
        this.removeRefactoringAction("fIntroduceFactoryAction");
        this.removeRefactoringAction("fExtractMethodAction");
        this.removeRefactoringAction("fExtractInterfaceAction");
        this.removeRefactoringAction("fExtractClassAction");
        this.removeRefactoringAction("fExtractSupertypeAction");
        this.removeRefactoringAction("fExtractTempAction");
        this.removeRefactoringAction("fExtractConstantAction");
        this.removeRefactoringAction("fChangeTypeAction");
        this.removeRefactoringAction("fConvertNestedToTopAction");
        this.removeRefactoringAction("fInferTypeArgumentsAction");
        this.removeRefactoringAction("fInlineAction");
        this.removeRefactoringAction("fConvertAnonymousToNestedAction");
        this.removeRefactoringAction("fIntroduceIndirectionAction");
        this.removeRefactoringAction("fUseSupertypeAction");
        GroovyRenameAction renameAction = new GroovyRenameAction((JavaEditor)this);
        renameAction.setActionDefinitionId("org.codehaus.groovy.eclipse.refactoring.command.rename");
        this.setAction("RenameElement", (IAction)renameAction);
        this.replaceRefactoringAction("fRenameAction", (SelectionDispatchAction)renameAction);
        GroovyExtractConstantAction extractConstantAction = new GroovyExtractConstantAction(this);
        extractConstantAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.constant");
        this.setAction("ExtractConstant", (IAction)extractConstantAction);
        this.replaceRefactoringAction("fExtractConstantAction", (SelectionDispatchAction)extractConstantAction);
        GroovyExtractMethodAction extractMethodAction = new GroovyExtractMethodAction(this);
        extractMethodAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.method");
        this.setAction("ExtractMethod", (IAction)extractMethodAction);
        this.replaceRefactoringAction("fExtractMethodAction", (SelectionDispatchAction)extractMethodAction);
        GroovyExtractLocalAction extractLocalAction = new GroovyExtractLocalAction(this);
        extractLocalAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.local.variable");
        this.setAction("ExtractLocalVariable", (IAction)extractLocalAction);
        this.replaceRefactoringAction("fExtractTempAction", (SelectionDispatchAction)extractLocalAction);
        GroovyConvertLocalToFieldAction convertLocalAction = new GroovyConvertLocalToFieldAction(this);
        convertLocalAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.promote.local.variable");
        this.setAction("ConvertLocalToField", (IAction)convertLocalAction);
        this.replaceRefactoringAction("fConvertLocalToFieldAction", (SelectionDispatchAction)convertLocalAction);
        ExpandSelectionAction selectionAction = new ExpandSelectionAction(this, (SelectionHistory)ReflectionUtils.getPrivateField(JavaEditor.class, (String)"fSelectionHistory", (Object)((Object)this)));
        selectionAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.enclosing");
        selectionAction.getDescription();
        this.setAction("SelectEnclosingElement", (IAction)selectionAction);
        this.setAction("SelectNextElement", null);
        this.setAction("SelectPreviousElement", null);
        ISurroundWithFactory surroundWithFactory = (ISurroundWithFactory)Platform.getAdapterManager().loadAdapter((Object)this, "org.codehaus.groovy.eclipse.quickfix.templates.SurroundWithAdapterFactory");
        if (surroundWithFactory != null) {
            CompositeActionGroup compositActions = (CompositeActionGroup)ReflectionUtils.getPrivateField(CompilationUnitEditor.class, (String)"fContextMenuGroup", (Object)((Object)this));
            ActionGroup[] groups = (ActionGroup[])ReflectionUtils.getPrivateField(CompositeActionGroup.class, (String)"fGroups", (Object)compositActions);
            boolean found = false;
            ActionGroup surroundWithGroup = surroundWithFactory.createSurrundWithGroup(this, "group.edit");
            int i = 0;
            while (i < groups.length) {
                if (groups[i] instanceof SurroundWithActionGroup) {
                    found = true;
                    groups[i] = surroundWithGroup;
                    break;
                }
                ++i;
            }
            if (!found) {
                GroovyPlugin.trace("Oops...surroundWithActionGroup not found in context menus");
            }
            found = false;
            groups = (ActionGroup[])ReflectionUtils.getPrivateField(CompositeActionGroup.class, (String)"fGroups", (Object)this.fActionGroups);
            i = 0;
            while (i < groups.length) {
                if (groups[i] instanceof SurroundWithActionGroup) {
                    found = true;
                    groups[i] = surroundWithGroup;
                    break;
                }
                ++i;
            }
            if (!found) {
                GroovyPlugin.trace("Oops...surroundWithActionGroup not found");
            }
        } else {
            GroovyPlugin.trace("Oops...surroundWithFactory not initialized");
        }
    }

    private void removeRefactoringAction(String actionFieldName) {
        this.replaceRefactoringAction(actionFieldName, null);
    }

    private void replaceRefactoringAction(String actionFieldName, SelectionDispatchAction newAction) {
        RefactorActionGroup group = this.getRefactorActionGroup();
        ISelectionChangedListener action = (ISelectionChangedListener)ReflectionUtils.getPrivateField(RefactorActionGroup.class, (String)actionFieldName, (Object)group);
        if (action != null) {
            this.getSite().getSelectionProvider().removeSelectionChangedListener(action);
        }
        ReflectionUtils.setPrivateField(RefactorActionGroup.class, (String)actionFieldName, (Object)group, (Object)newAction);
    }

    private IFile getFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    public GroovyCompilationUnit getGroovyCompilationUnit() {
        ITypeRoot root = super.getInputJavaElement();
        if (root instanceof GroovyCompilationUnit) {
            return (GroovyCompilationUnit)root;
        }
        return null;
    }

    public ModuleNode getModuleNode() {
        GroovyCompilationUnit unit = this.getGroovyCompilationUnit();
        if (unit != null) {
            return unit.getModuleNode();
        }
        return null;
    }

    public Object getAdapter(Class required) {
        if (IResource.class == required || IFile.class == required) {
            return this.getFile();
        }
        if (GroovyCompilationUnit.class == required || ICompilationUnit.class == required || org.eclipse.jdt.internal.core.CompilationUnit.class == required) {
            return super.getInputJavaElement();
        }
        if (ModuleNode.class == required) {
            return this.getModuleNode();
        }
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null && this.getSourceViewer() != null) {
                this.fOutlinePage = this.createOutlinePage();
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.unsetJavaBreakpointUpdater();
        this.installGroovySemanticHighlighting();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean closeBrackets = preferenceStore.getBoolean(CLOSE_BRACKETS);
        boolean closeStrings = preferenceStore.getBoolean(CLOSE_STRINGS);
        boolean closeBraces = preferenceStore.getBoolean(CLOSE_BRACES);
        boolean closeAngularBrackets = "1.5".compareTo(preferenceStore.getString("org.eclipse.jdt.core.compiler.source")) <= 0;
        this.groovyBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.groovyBracketInserter.setCloseStringsEnabled(closeStrings);
        this.groovyBracketInserter.setCloseAngularBracketsEnabled(closeAngularBrackets);
        this.groovyBracketInserter.setCloseBracesEnabled(closeBraces);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.groovyBracketInserter);
        }
        this.disableBracketInserter();
    }

    private void disableBracketInserter() {
        Object fBracketInserterField = ReflectionUtils.getPrivateField(CompilationUnitEditor.class, (String)"fBracketInserter", (Object)((Object)this));
        Class<?> fBracketInserterClass = fBracketInserterField.getClass();
        Class[] bool = new Class[]{Boolean.TYPE};
        Object[] disabled = new Object[]{Boolean.FALSE};
        ReflectionUtils.executePrivateMethod(fBracketInserterClass, (String)"setCloseBracketsEnabled", (Class[])bool, (Object)fBracketInserterField, (Object[])disabled);
        ReflectionUtils.executePrivateMethod(fBracketInserterClass, (String)"setCloseStringsEnabled", (Class[])bool, (Object)fBracketInserterField, (Object[])disabled);
        ReflectionUtils.executePrivateMethod(fBracketInserterClass, (String)"setCloseStringsEnabled", (Class[])bool, (Object)fBracketInserterField, (Object[])disabled);
        ReflectionUtils.executePrivateMethod(fBracketInserterClass, (String)"setCloseAngularBracketsEnabled", (Class[])bool, (Object)fBracketInserterField, (Object[])disabled);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        try {
            this.internalInput = input;
            boolean wasInstalled = this.semanticHighlightingInstalled();
            if (wasInstalled) {
                this.uninstallGroovySemanticHighlighting();
            }
            super.doSetInput(input);
            this.unsetJavaBreakpointUpdater();
            if (wasInstalled) {
                this.installGroovySemanticHighlighting();
            }
        }
        finally {
            this.internalInput = null;
        }
    }

    private Object myGetLockObject(IAnnotationModel model) {
        return ReflectionUtils.executePrivateMethod(JavaEditor.class, (String)"getLockObject", (Class[])new Class[]{IAnnotationModel.class}, (Object)((Object)this), (Object[])new Object[]{model});
    }

    private void myRemoveOccurrenceAnnotations() {
        ReflectionUtils.executePrivateMethod(JavaEditor.class, (String)"removeOccurrenceAnnotations", (Class[])new Class[0], (Object)((Object)this), (Object[])new Object[0]);
    }

    private void setOccurrenceAnnotations(Annotation[] as) {
        ReflectionUtils.setPrivateField(JavaEditor.class, (String)"fOccurrenceAnnotations", (Object)((Object)this), (Object)as);
    }

    private void setMarkOccurrenceTargetRegion(IRegion r) {
        ReflectionUtils.setPrivateField(JavaEditor.class, (String)"fMarkOccurrenceTargetRegion", (Object)((Object)this), (Object)r);
    }

    private void setMarkOccurrenceModificationStamp(long l) {
        ReflectionUtils.setPrivateField(JavaEditor.class, (String)"fMarkOccurrenceModificationStamp", (Object)((Object)this), (Object)l);
    }

    private Annotation[] getOccurrenceAnnotations() {
        return (Annotation[])ReflectionUtils.getPrivateField(JavaEditor.class, (String)"fOccurrenceAnnotations", (Object)((Object)this));
    }

    private IRegion getMarkOccurrenceTargetRegion() {
        return (IRegion)ReflectionUtils.getPrivateField(JavaEditor.class, (String)"fMarkOccurrenceTargetRegion", (Object)((Object)this));
    }

    private long getMarkOccurrenceModificationStamp() {
        return (Long)ReflectionUtils.getPrivateField(JavaEditor.class, (String)"fMarkOccurrenceModificationStamp", (Object)((Object)this));
    }

    private boolean getStickyOccurrenceAnnotations() {
        return (Boolean)ReflectionUtils.getPrivateField(JavaEditor.class, (String)"fStickyOccurrenceAnnotations", (Object)((Object)this));
    }

    private boolean getMarkOccurrenceAnnotations() {
        return (Boolean)ReflectionUtils.getPrivateField(JavaEditor.class, (String)"fMarkOccurrenceAnnotations", (Object)((Object)this));
    }

    private ISelection getForcedMarkOccurrencesSelection() {
        return (ISelection)ReflectionUtils.getPrivateField(JavaEditor.class, (String)"fForcedMarkOccurrencesSelection", (Object)((Object)this));
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, CompilationUnit astRoot) {
        if (this.groovyOccurrencesFinderJob != null) {
            this.groovyOccurrencesFinderJob.cancel();
        }
        if (!this.getMarkOccurrenceAnnotations()) {
            return;
        }
        if (astRoot == null || selection == null) {
            return;
        }
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        boolean hasChanged = false;
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            IRegion markOccurrenceTargetRegion = this.getMarkOccurrenceTargetRegion();
            boolean bl = hasChanged = currentModificationStamp != this.getMarkOccurrenceModificationStamp();
            if (markOccurrenceTargetRegion != null && !hasChanged && markOccurrenceTargetRegion.getOffset() <= offset && offset <= markOccurrenceTargetRegion.getOffset() + markOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.setMarkOccurrenceTargetRegion(this.findMarkOccurrencesRegion(document, offset));
            this.setMarkOccurrenceModificationStamp(currentModificationStamp);
        }
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        GroovyOccurrencesFinder finder = new GroovyOccurrencesFinder();
        finder.initialize(astRoot, selection.getOffset(), selection.getLength());
        locations = finder.getOccurrences();
        if (locations == null) {
            if (!this.getStickyOccurrenceAnnotations()) {
                this.myRemoveOccurrenceAnnotations();
            } else if (hasChanged) {
                this.myRemoveOccurrenceAnnotations();
            }
            return;
        }
        this.groovyOccurrencesFinderJob = new OccurrencesFinderJob(document, locations, (ISelection)selection);
        this.groovyOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    protected IRegion findMarkOccurrencesRegion(IDocument document, int offset) {
        IRegion word = JavaWordFinder.findWord((IDocument)document, (int)offset);
        try {
            if (word != null && word.getLength() > 1 && document.getChar(word.getOffset()) == '$') {
                word = new Region(word.getOffset() + 1, word.getLength() - 1);
            }
        }
        catch (BadLocationException badLocationException) {}
        return word;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.codehaus.groovy.eclipse.editor.groovyEditorScope"});
    }

    public JavaSourceViewerConfiguration createJavaSourceViewerConfiguration() {
        GroovyTextTools textTools = GroovyPlugin.getDefault().getTextTools();
        return new GroovyConfiguration(textTools.getColorManager(), this.getPreferenceStore(), (ITextEditor)this);
    }

    private void unsetJavaBreakpointUpdater() {
        block3: {
            try {
                IAnnotationModel model;
                ISourceViewer viewer = this.getSourceViewer();
                if (viewer == null || !((model = viewer.getAnnotationModel()) instanceof AbstractMarkerAnnotationModel)) break block3;
                ReflectionUtils.executePrivateMethod(AbstractMarkerAnnotationModel.class, (String)"installMarkerUpdaters", (Class[])new Class[0], (Object)model, (Object[])new Object[0]);
                List updaterSpecs = (List)ReflectionUtils.getPrivateField(AbstractMarkerAnnotationModel.class, (String)"fMarkerUpdaterSpecifications", (Object)model);
                Iterator specIter = updaterSpecs.iterator();
                while (specIter.hasNext()) {
                    IConfigurationElement spec = (IConfigurationElement)specIter.next();
                    if (!spec.getAttribute("class").equals(BreakpointMarkerUpdater.class.getCanonicalName())) continue;
                    specIter.remove();
                    break;
                }
            }
            catch (Exception e) {
                GroovyPlugin.getDefault().logException("Failed to unset Java breakpoint updater", e);
            }
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        ISourceViewer sv = this.getSourceViewer();
        if (sv != null) {
            String p = event.getProperty();
            if (CLOSE_BRACKETS.equals(p)) {
                this.groovyBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(p));
                this.disableBracketInserter();
                return;
            }
            if (CLOSE_STRINGS.equals(p)) {
                this.groovyBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(p));
                this.disableBracketInserter();
                return;
            }
            if (CLOSE_BRACES.equals(p)) {
                this.groovyBracketInserter.setCloseBracesEnabled(this.getPreferenceStore().getBoolean(p));
                this.disableBracketInserter();
                return;
            }
        }
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '<': {
                return '>';
            }
            case '>': {
                return '<';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
            case '{': {
                return '}';
            }
        }
        throw new IllegalArgumentException();
    }

    public VerifyKeyListener getGroovyBracketInserter() {
        return this.groovyBracketInserter;
    }

    public GroovyOutlinePage getOutlinePage() {
        IContentOutlinePage outlinePage;
        if (this.page == null && (outlinePage = (IContentOutlinePage)this.getAdapter(IContentOutlinePage.class)) instanceof GroovyOutlinePage) {
            this.page = (GroovyOutlinePage)outlinePage;
        }
        return this.page;
    }

    protected void synchronizeOutlinePage(ISourceReference element, boolean checkIfOutlinePageActive) {
        if (this.page != null) {
            this.page.refresh();
        }
        super.synchronizeOutlinePage(element, checkIfOutlinePageActive);
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        return this.page != null ? this.page.getOutlineElmenetAt(this.getCaretOffset()) : super.computeHighlightRangeSourceReference();
    }

    protected JavaOutlinePage createOutlinePage() {
        OutlineExtenderRegistry outlineExtenderRegistry = GroovyPlugin.getDefault().getOutlineTools().getOutlineExtenderRegistry();
        GroovyCompilationUnit unit = this.getGroovyCompilationUnit();
        if (unit != null) {
            try {
                this.page = outlineExtenderRegistry.getGroovyOutlinePageForEditor(unit.getJavaProject().getProject(), this.fOutlinerContextMenuId, this);
            }
            catch (CoreException e) {
                GroovyPlugin.getDefault().logException("Error creating Groovy Outline page", (Exception)((Object)e));
            }
            if (this.page != null) {
                this.page.setInput(this.page.getOutlineCompilationUnit());
                return this.page;
            }
        }
        return super.createOutlinePage();
    }

    private class GroovyBracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private boolean fCloseBrackets = true;
        private boolean fCloseBraces = true;
        private boolean fCloseStrings = true;
        private boolean fCloseAngularBrackets = true;
        private final String CATEGORY = this.toString();
        private final IPositionUpdater fUpdater = new GroovyExclusivePositionUpdater(this.CATEGORY);
        private final Stack<GroovyBracketLevel> fBracketLevelStack = new Stack();

        private GroovyBracketInserter() {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void setCloseBracesEnabled(boolean enabled) {
            this.fCloseBraces = enabled;
        }

        public void setCloseAngularBracketsEnabled(boolean enabled) {
            this.fCloseAngularBrackets = enabled;
        }

        private boolean isAngularIntroducer(String identifier) {
            return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
        }

        private boolean isMultilineSelection() {
            ISelection selection = GroovyEditor.this.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection ts = (ITextSelection)selection;
                return ts.getStartLine() != ts.getEndLine();
            }
            return false;
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || GroovyEditor.this.getInsertMode() != SMART_INSERT || GroovyEditor.this.isBlockSelectionModeEnabled() && this.isMultilineSelection()) {
                return;
            }
            switch (event.character) {
                case '\"': 
                case '\'': 
                case '(': 
                case '<': 
                case '[': 
                case '{': {
                    break;
                }
                default: {
                    return;
                }
            }
            ISourceViewer sourceViewer = GroovyEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            try {
                IRegion startLine = document.getLineInformationOfOffset(offset);
                IRegion endLine = document.getLineInformationOfOffset(offset + length);
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
                int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
                String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
                int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
                int prevTokenOffset = scanner.getPosition() + 1;
                String previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
                switch (event.character) {
                    case '(': {
                        if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '<': {
                        if (this.fCloseAngularBrackets && this.fCloseBrackets && nextToken != 13 && (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isAngularIntroducer(previous) || prevToken == -1)) break;
                        return;
                    }
                    case '[': {
                        if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        if (this.fCloseStrings && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '{': {
                        if (this.fCloseBraces && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true);
                if (event.character != '{' && !"__dftl_partition_content_type".equals(partition.getType()) && !this.shouldCloseTripleQuotes(document, offset, partition, GroovyEditor.getPeerCharacter(event.character))) {
                    return;
                }
                if (event.character == '{' && !this.shouldCloseCurly(document, offset, partition, GroovyEditor.getPeerCharacter(event.character))) {
                    return;
                }
                if (!GroovyEditor.this.validateEditorInputState()) {
                    return;
                }
                char character = event.character;
                char closingCharacter = GroovyEditor.getPeerCharacter(character);
                StringBuffer buffer = new StringBuffer();
                buffer.append(character);
                buffer.append(closingCharacter);
                int insertedLength = 1;
                if (this.fCloseStrings && offset > 1) {
                    String start = document.get(offset - 2, 2);
                    boolean doit = false;
                    if (event.character == closingCharacter) {
                        doit = start.equals(String.valueOf(Character.toString(closingCharacter)) + closingCharacter);
                    }
                    if (doit) {
                        buffer.append(closingCharacter);
                        ++insertedLength;
                        ++insertedLength;
                        if (offset > 2 && document.getChar(offset - 3) == closingCharacter) {
                            --offset;
                        } else {
                            buffer.append(closingCharacter);
                        }
                    }
                }
                document.replace(offset, length, buffer.toString());
                GroovyBracketLevel level = new GroovyBracketLevel();
                this.fBracketLevelStack.push(level);
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset + insertedLength, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addLinkingListener((ILinkedModeListener)this);
                model.addGroup(group);
                model.forceInstall();
                if (this.fBracketLevelStack.size() == 1) {
                    document.addPositionCategory(this.CATEGORY);
                    document.addPositionUpdater(this.fUpdater);
                }
                level.fFirstPosition = new Position(offset, 1);
                level.fSecondPosition = new Position(offset + insertedLength, 1);
                document.addPosition(this.CATEGORY, level.fFirstPosition);
                document.addPosition(this.CATEGORY, level.fSecondPosition);
                level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                level.fUI.setSimpleMode(true);
                level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new GroovyExitPolicy(closingCharacter, GroovyEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 1 + insertedLength, 0, Integer.MAX_VALUE);
                level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                level.fUI.enter();
                IRegion newSelection = level.fUI.getSelectedRegion();
                sourceViewer.setSelectedRange(newSelection.getOffset() - insertedLength + 1, newSelection.getLength());
                event.doit = false;
            }
            catch (BadLocationException e) {
                JavaPlugin.log((Throwable)e);
            }
            catch (BadPositionCategoryException e) {
                JavaPlugin.log((Throwable)e);
            }
        }

        private boolean shouldCloseCurly(IDocument document, int offset, ITypedRegion partition, char peer) throws BadLocationException {
            if (offset < 2 || !"__java_string".equals(partition.getType()) && !"__groovy_multiline_string".equals(partition.getType())) {
                return false;
            }
            char maybeOpen = document.getChar(offset - 1);
            if (maybeOpen != '$') {
                return false;
            }
            char maybeNext = document.getChar(offset);
            return Character.isWhitespace(maybeNext) || maybeNext == '\"' || maybeNext == '\'';
        }

        private boolean shouldCloseTripleQuotes(IDocument document, int offset, ITypedRegion partition, char quote) throws BadLocationException {
            if (offset < 3 || "__groovy_multiline_string".equals(partition.getType())) {
                return false;
            }
            String maybequotes = document.get(offset - 3, 3);
            return maybequotes.equals(String.valueOf(Character.toString(quote)) + quote + quote);
        }

        public void left(LinkedModeModel environment, int flags) {
            final GroovyBracketLevel level = this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = GroovyEditor.this.getSourceViewer();
            final IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                    public void perform(IDocument d, IDocumentListener owner) {
                        if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                            try {
                                document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, "");
                            }
                            catch (BadLocationException e) {
                                JavaPlugin.log((Throwable)e);
                            }
                        }
                        if (GroovyBracketInserter.this.fBracketLevelStack.size() == 0) {
                            document.removePositionUpdater(GroovyBracketInserter.this.fUpdater);
                            try {
                                document.removePositionCategory(GroovyBracketInserter.this.CATEGORY);
                            }
                            catch (BadPositionCategoryException e) {
                                JavaPlugin.log((Throwable)e);
                            }
                        }
                    }
                });
            }
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void resume(LinkedModeModel environment, int flags) {
        }
    }

    private static class GroovyBracketLevel {
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private GroovyBracketLevel() {
        }
    }

    private static class GroovyExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public GroovyExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroovyExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack<GroovyBracketLevel> fStack;
        final int fSize;

        public GroovyExitPolicy(char exitCharacter, char escapeCharacter, Stack<GroovyBracketLevel> stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (event.character == this.fExitCharacter) {
                    GroovyBracketLevel level = this.fStack.peek();
                    if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                        return null;
                    }
                    if (level.fSecondPosition.offset == offset && length == 0) {
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (event.character == '\r' && offset > 0) {
                    IDocument document = GroovyEditor.this.getSourceViewer().getDocument();
                    try {
                        if (document.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = GroovyEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private final IDocument fDocument;
        private final ISelection fSelection;
        private final ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private final IOccurrencesFinder.OccurrenceLocation[] fLocations;

        public OccurrencesFinderJob(IDocument document, IOccurrencesFinder.OccurrenceLocation[] locations, ISelection selection) {
            super("Mark Occurrences");
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fLocations = locations;
            this.fPostSelectionValidator = GroovyEditor.this.getSelectionProvider() instanceof ISelectionValidator ? (ISelectionValidator)GroovyEditor.this.getSelectionProvider() : null;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && GroovyEditor.this.getForcedMarkOccurrencesSelection() != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = GroovyEditor.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = GroovyEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)GroovyEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int n = this.fLocations.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(n);
            int i = 0;
            while (i < n) {
                if (this.isCanceled(progressMonitor)) {
                    return Status.CANCEL_STATUS;
                }
                IOccurrencesFinder.OccurrenceLocation location = this.fLocations[i];
                Position position = new Position(location.getOffset(), location.getLength());
                String description = location.getDescription();
                String annotationType = location.getFlags() == 1 ? "org.eclipse.jdt.ui.occurrences.write" : "org.eclipse.jdt.ui.occurrences";
                annotationMap.put(new Annotation(annotationType, false, description), position);
                ++i;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = GroovyEditor.this.myGetLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(GroovyEditor.this.getOccurrenceAnnotations(), annotationMap);
                } else {
                    GroovyEditor.this.myRemoveOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                GroovyEditor.this.setOccurrenceAnnotations(annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]));
            }
            return Status.OK_STATUS;
        }
    }
}

