/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.editor.GroovyAutoIndentStrategy;
import org.codehaus.groovy.eclipse.editor.GroovyColorManager;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.editor.GroovyExtraInformationHover;
import org.codehaus.groovy.eclipse.editor.GroovyMultilineStringAutoEditStrategy;
import org.codehaus.groovy.eclipse.editor.GroovyTagScanner;
import org.codehaus.groovy.eclipse.editor.highlighting.HighlightingExtenderRegistry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.ContentAssistProcessor;
import org.eclipse.jdt.internal.ui.text.java.JavaAutoIndentStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaInformationProvider;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class GroovyConfiguration
extends JavaSourceViewerConfiguration {
    public GroovyConfiguration(GroovyColorManager colorManager, IPreferenceStore preferenceSource, ITextEditor editor) {
        super((IColorManager)colorManager, preferenceSource, editor, "___java_partitioning");
        ReflectionUtils.setPrivateField(JavaSourceViewerConfiguration.class, (String)"fStringScanner", (Object)((Object)this), (Object)this.createStringScanner((IColorManager)colorManager, preferenceSource));
        try {
            ReflectionUtils.setPrivateField(JavaSourceViewerConfiguration.class, (String)"fCodeScanner", (Object)((Object)this), (Object)((Object)this.createTagScanner(this.getProject(), (IColorManager)colorManager, this.getHighlightingExtenderRegistry())));
        }
        catch (CoreException e) {
            GroovyCore.logException((String)"Error creating syntax highlighter", (Throwable)e);
        }
    }

    private RuleBasedScanner createStringScanner(IColorManager colorManager, IPreferenceStore store) {
        return new SingleTokenJavaScanner(colorManager, store, "groovy.editor.highlight.strings.color");
    }

    private GroovyTagScanner createTagScanner(IProject project, IColorManager colorManager, HighlightingExtenderRegistry registry) throws CoreException {
        return new GroovyTagScanner(colorManager, registry.getInitialAdditionalRulesForProject(project), registry.getAdditionalRulesForProject(project), registry.getExtraGroovyKeywordsForProject(project), registry.getExtraGJDKKeywordsForProject(project));
    }

    public HighlightingExtenderRegistry getHighlightingExtenderRegistry() {
        return GroovyPlugin.getDefault().getTextTools().getHighlightingExtenderRegistry();
    }

    private IProject getProject() {
        IEditorInput input;
        ITextEditor editor = this.getEditor();
        if (editor != null && editor instanceof GroovyEditor && (input = ((GroovyEditor)editor).internalInput) instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            return file.getProject();
        }
        return null;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = (PresentationReconciler)super.getPresentationReconciler(sourceViewer);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__groovy_multiline_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__groovy_multiline_string");
        return reconciler;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character", "__groovy_multiline_string"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = (ContentAssistant)super.getContentAssistant(sourceViewer);
        JavaCompletionProcessor stringProcessor = new JavaCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__groovy_multiline_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__groovy_multiline_string");
        IContentAssistProcessor processor = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        List categories = (List)ReflectionUtils.getPrivateField(ContentAssistProcessor.class, (String)"fCategories", (Object)processor);
        ArrayList<CompletionProposalCategory> newCategories = new ArrayList<CompletionProposalCategory>(categories.size() - 1);
        for (CompletionProposalCategory category : categories) {
            if (category.getId().equals("org.eclipse.jdt.ui.javaTypeProposalCategory") || category.getId().equals("org.eclipse.jdt.ui.templateProposalCategory") || category.getId().equals("org.eclipse.ajdt.ui.templateCategory") || category.getId().equals("org.eclipse.jdt.ui.swtProposalCategory") || category.getId().equals("org.eclipse.jdt.ui.javaNoTypeProposalCategory") || category.getId().equals("org.eclipse.jdt.ui.javaAllProposalCategory") || category.getId().equals("org.eclipse.mylyn.java.ui.javaAllProposalCategory")) continue;
            newCategories.add(category);
        }
        ReflectionUtils.setPrivateField(ContentAssistProcessor.class, (String)"fCategories", (Object)processor, newCategories);
        return assistant;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        IInformationPresenter presenter = super.getOutlinePresenter(sourceViewer, doCodeResolve);
        if (presenter instanceof InformationPresenter) {
            IInformationProvider provider = presenter.getInformationProvider("__dftl_partition_content_type");
            ((InformationPresenter)presenter).setInformationProvider(provider, "__groovy_multiline_string");
        }
        return presenter;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        return super.getQuickAssistAssistant(sourceViewer);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__groovy_multiline_string".equals(contentType) || "__java_string".equals(contentType)) {
            return new IAutoEditStrategy[]{new GroovyMultilineStringAutoEditStrategy(contentType)};
        }
        IAutoEditStrategy[] strats = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        while (i < strats.length) {
            if (strats[i] instanceof JavaAutoIndentStrategy) {
                strats[i] = new GroovyAutoIndentStrategy(contentType, (JavaAutoIndentStrategy)strats[i]);
            }
            ++i;
        }
        return strats;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        IInformationPresenter informationPresenter = super.getInformationPresenter(sourceViewer);
        try {
            Class<?> clazz = Class.forName("org.eclipse.jdt.internal.ui.text.java.hover.JavaTypeHover");
            JavaInformationProvider provider = (JavaInformationProvider)informationPresenter.getInformationProvider("__dftl_partition_content_type");
            IJavaEditorTextHover implementation = (IJavaEditorTextHover)ReflectionUtils.getPrivateField(JavaInformationProvider.class, (String)"fImplementation", (Object)provider);
            GroovyExtraInformationHover hover = new GroovyExtraInformationHover(true);
            hover.setEditor((IEditorPart)this.getEditor());
            ReflectionUtils.setPrivateField(clazz, (String)"fJavadocHover", (Object)implementation, (Object)((Object)hover));
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return informationPresenter;
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.codehaus.groovy.eclipse.groovyCode", this.getEditor());
        return targets;
    }
}

