/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.editor.AbstractAutoEditStrategy;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyIndentationService;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.text.java.JavaAutoIndentStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class GroovyAutoIndentStrategy
extends AbstractAutoEditStrategy {
    private JavaAutoIndentStrategy javaStrategy;
    private boolean closeBraces;
    private GroovyIndentationService indentor;

    public GroovyAutoIndentStrategy(String contentType, JavaAutoIndentStrategy javaStrategy) {
        this.javaStrategy = javaStrategy;
        ReflectionUtils.executePrivateMethod(JavaAutoIndentStrategy.class, (String)"clearCachedValues", (Class[])new Class[0], (Object)javaStrategy, (Object[])new Object[0]);
        this.indentor = new GroovyIndentationService((IJavaProject)ReflectionUtils.getPrivateField(JavaAutoIndentStrategy.class, (String)"fProject", (Object)javaStrategy));
        this.closeBraces = (Boolean)ReflectionUtils.getPrivateField(JavaAutoIndentStrategy.class, (String)"fCloseBrace", (Object)javaStrategy);
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        try {
            if (!c.doit) {
                return;
            }
            if (c.length == 0 && c.text != null && this.isNewline(d, c.text)) {
                this.autoEditAfterNewline(d, c);
            } else {
                if (c.text.length() > 2) {
                    this.smartPaste(d, c);
                }
                if ("}".equals(c.text)) {
                    this.javaStrategy.customizeDocumentCommand(d, c);
                }
            }
        }
        finally {
            this.indentor.disposePrefs();
        }
    }

    private IFormatterPreferences getPrefs() {
        return this.indentor.getPrefs();
    }

    private void smartPaste(IDocument d, DocumentCommand c) {
        try {
            if (this.getPrefs().isSmartPaste() && this.indentor.isInEmptyLine(d, c.offset)) {
                int pasteLine = d.getLineOfOffset(c.offset);
                IRegion pasteLineRegion = d.getLineInformation(pasteLine);
                Document workCopy = new Document(d.get(0, pasteLineRegion.getOffset()));
                workCopy.replace(pasteLineRegion.getOffset(), 0, c.text);
                int startLine = workCopy.getLineOfOffset(pasteLineRegion.getOffset());
                int endLine = workCopy.getLineOfOffset(pasteLineRegion.getOffset() + c.text.length());
                int indentDiff = 0;
                boolean isMultiLineComment = false;
                boolean isMultiLineString = false;
                int line = startLine;
                while (line <= endLine) {
                    int newIndentLevel;
                    int oldIndentLevel;
                    IRegion lineRegion = workCopy.getLineInformation(line);
                    String text = workCopy.get(lineRegion.getOffset(), lineRegion.getLength());
                    if (line - startLine < 2) {
                        oldIndentLevel = this.indentor.getLineIndentLevel((IDocument)workCopy, line);
                        newIndentLevel = this.indentor.computeIndentForLine((IDocument)workCopy, line);
                        if (isMultiLineComment) {
                            this.indentor.fixIndentation(workCopy, line, ++newIndentLevel);
                        } else if (!isMultiLineString) {
                            this.indentor.fixIndentation(workCopy, line, newIndentLevel);
                        }
                        indentDiff = newIndentLevel - oldIndentLevel;
                    } else {
                        oldIndentLevel = this.indentor.getLineIndentLevel((IDocument)workCopy, line);
                        newIndentLevel = oldIndentLevel + indentDiff;
                        if (isMultiLineComment) {
                            this.indentor.fixIndentation(workCopy, line, newIndentLevel);
                        } else if (!isMultiLineString) {
                            this.indentor.fixIndentation(workCopy, line, newIndentLevel);
                        }
                    }
                    if (text.indexOf("/*") != -1) {
                        isMultiLineComment = true;
                    }
                    if (text.indexOf("*/") != -1 && isMultiLineComment) {
                        isMultiLineComment = false;
                    } else if (!(text.indexOf("\"\"\"") == -1 && text.indexOf("'''") == -1 || isMultiLineComment)) {
                        isMultiLineString = !isMultiLineString;
                    }
                    ++line;
                }
                int workStart = workCopy.getLineOffset(startLine);
                int workEnd = workCopy.getLineOffset(endLine) + workCopy.getLineLength(endLine);
                c.text = workCopy.get(workStart, workEnd - workStart);
                c.offset = pasteLineRegion.getOffset();
                c.length = pasteLineRegion.getLength();
                c.caretOffset = c.offset + c.text.length();
                c.shiftsCaret = false;
            }
        }
        catch (Throwable e) {
            GroovyCore.logException((String)"Something went wrong in smartPaste", (Throwable)e);
        }
    }

    private void autoEditAfterNewline(IDocument d, DocumentCommand c) {
        try {
            int lengthToCurly;
            int orgIndentLevel = this.indentor.getIndentLevel(d, c.offset);
            int indentLevel = this.indentor.computeIndentAfterNewline(d, c.offset);
            String indentation = this.indentor.createIndentation(indentLevel);
            c.text = String.valueOf(c.text) + indentation;
            if (this.closeBraces && this.shouldInsertBrace(d, c.offset, (lengthToCurly = this.indentor.lengthToNextCurly(d, c.offset)) > 0)) {
                c.length = lengthToCurly;
                int newCaret = c.offset + c.text.length();
                c.text = String.valueOf(c.text) + this.indentor.newline(d) + this.indentor.createIndentation(orgIndentLevel) + "}";
                c.caretOffset = newCaret;
                c.shiftsCaret = false;
            }
        }
        catch (Throwable e) {
            GroovyCore.logException((String)"Something went wrong in Groovy autoEditAfterNewline", (Throwable)e);
            return;
        }
    }

    private boolean shouldInsertBrace(IDocument d, int enterPos, boolean nextTokenIsCloseBrace) {
        if (!this.indentor.moreOpenThanCloseBefore(d, enterPos)) {
            return false;
        }
        if (nextTokenIsCloseBrace || this.indentor.isEndOfLine(d, enterPos)) {
            String line;
            block8: {
                int nextIndentLevel;
                int indentLevel;
                block7: {
                    try {
                        int lineNum = d.getLineOfOffset(enterPos);
                        indentLevel = this.indentor.getLineIndentLevel(d, lineNum);
                        do {
                            line = GroovyIndentationService.getLine((IDocument)d, (int)(++lineNum));
                        } while ((line = line.trim()).equals("") && lineNum < d.getNumberOfLines());
                        nextIndentLevel = this.indentor.getLineIndentLevel(d, lineNum);
                        if (nextIndentLevel <= indentLevel) break block7;
                        return false;
                    }
                    catch (BadLocationException e) {
                        GroovyCore.logException((String)"internal error", (Throwable)e);
                        return false;
                    }
                }
                if (nextIndentLevel >= indentLevel) break block8;
                return true;
            }
            return !line.startsWith("}");
        }
        return false;
    }
}

