/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.core.search.LexicalClassVisitor;

public class ValidBreakpointLocationFinder {
    private ASTNode lastValid = null;
    private int startLine;

    public ValidBreakpointLocationFinder(int startLine) {
        this.startLine = startLine;
    }

    private void validateNode(ASTNode node) throws VisitCompleted {
        if (node.getLineNumber() == -1 || node instanceof Statement || node instanceof ClosureExpression || node instanceof ClassNode || node instanceof FieldNode) {
            return;
        }
        if (node.getLineNumber() == this.startLine) {
            this.lastValid = node;
        } else if (node.getLineNumber() > this.startLine) {
            if (this.lastValid == null) {
                this.lastValid = node;
            }
            throw new VisitCompleted();
        }
    }

    public ASTNode findValidBreakpointLocation(ModuleNode module) {
        LexicalClassVisitor visitor = new LexicalClassVisitor(module);
        try {
            boolean skipNext = false;
            while (visitor.hasNextNode()) {
                ASTNode node = visitor.getNextNode();
                if (node instanceof DeclarationExpression) {
                    skipNext = true;
                    Expression rightExpression = ((DeclarationExpression)node).getRightExpression();
                    if (rightExpression == null || !"null".equals(rightExpression.getText())) continue;
                    continue;
                }
                if (skipNext) {
                    skipNext = false;
                    continue;
                }
                this.validateNode(node);
            }
        }
        catch (VisitCompleted visitCompleted) {}
        return this.lastValid;
    }

    private class VisitCompleted
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private VisitCompleted() {
        }
    }
}

