/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.debug.ui.BreakpointLocationVerifierJob;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    public static final Object TOGGLE_BREAKPOINT_FAMILY = new Object();

    public ToggleBreakpointAdapter() {
        ActionDelegateHelper.getDefault();
    }

    protected void report(final String message, final IWorkbenchPart part) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    if (message != null) {
                        statusLine.setMessage(true, message, null);
                    } else {
                        statusLine.setMessage(true, null, null);
                    }
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
                }
            }
        });
    }

    protected IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        return type;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, false);
    }

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection, final boolean bestMatch) {
        Job job = new Job("Toggle Line Breakpoint"){

            public boolean belongsTo(Object family) {
                return family == TOGGLE_BREAKPOINT_FAMILY;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (selection instanceof ITextSelection) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ToggleBreakpointAdapter.this.report(null, part);
                    IEditorPart editorPart = (IEditorPart)part;
                    ITextSelection textSelection = (ITextSelection)selection;
                    IType type = ToggleBreakpointAdapter.this.getType(textSelection);
                    IEditorInput editorInput = editorPart.getEditorInput();
                    IDocumentProvider documentProvider = ((ITextEditor)editorPart).getDocumentProvider();
                    if (documentProvider == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IDocument document = documentProvider.getDocument((Object)editorInput);
                    int lineNumber = textSelection.getStartLine() + 1;
                    int offset = textSelection.getOffset();
                    try {
                        IClassFile classFile;
                        if (type == null && (classFile = (IClassFile)editorInput.getAdapter(IClassFile.class)) != null && (type = classFile.getType()).getDeclaringType() != null) {
                            ISourceRange sourceRange = type.getSourceRange();
                            int start = sourceRange.getOffset();
                            int end = start + sourceRange.getLength();
                            if (offset < start || offset > end) {
                                IStatusLineManager statusLine = editorPart.getEditorSite().getActionBars().getStatusLineManager();
                                statusLine.setErrorMessage(NLS.bind((String)"Breakpoints can only be created within the type associated with the editor: {0}.", (Object[])new String[]{type.getTypeQualifiedName()}));
                                Display.getCurrent().beep();
                                return Status.OK_STATUS;
                            }
                        }
                        String typeName = null;
                        IResource resource = null;
                        HashMap attributes = new HashMap(10);
                        if (type == null) {
                            ICompilationUnit unit;
                            int end;
                            int begin;
                            ModuleNode node;
                            resource = ToggleBreakpointAdapter.getResource(editorPart);
                            if (editorPart instanceof ITextEditor && (node = ToggleBreakpointAdapter.this.getModuleNode((ITextEditor)editorPart)) != null) {
                                for (ClassNode clazz : node.getClasses()) {
                                    begin = clazz.getStart();
                                    end = clazz.getEnd();
                                    if (offset < begin || offset > end || clazz.isInterface()) continue;
                                    typeName = clazz.getName();
                                    break;
                                }
                            }
                            if (typeName == null && (unit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource))) != null) {
                                IType[] types = unit.getAllTypes();
                                int i = 0;
                                while (i < types.length) {
                                    begin = types[i].getSourceRange().getOffset();
                                    end = begin + types[i].getSourceRange().getLength();
                                    if (offset >= begin && offset <= end && !types[i].isInterface()) {
                                        typeName = String.valueOf(types[i].getPackageFragment().getElementName()) + "." + types[i].getTypeQualifiedName();
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        } else {
                            typeName = type.getFullyQualifiedName();
                            int index = typeName.indexOf(36);
                            if (index >= 0) {
                                typeName = typeName.substring(0, index);
                            }
                            resource = BreakpointUtils.getBreakpointResource((IMember)type);
                            try {
                                IRegion line = document.getLineInformation(lineNumber - 1);
                                int start = line.getOffset();
                                int end = start + line.getLength() - 1;
                                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)type, (int)start, (int)end);
                            }
                            catch (BadLocationException ble) {
                                JDIDebugUIPlugin.log((Throwable)ble);
                            }
                        }
                        if (typeName != null && resource != null) {
                            IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((IResource)resource, (String)typeName, (int)lineNumber);
                            if (existingBreakpoint != null) {
                                ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                                return Status.OK_STATUS;
                            }
                            ToggleBreakpointAdapter.this.createLineBreakpoint(resource, typeName, offset, lineNumber, -1, -1, 0, true, attributes, document, bestMatch, type, editorPart);
                        }
                    }
                    catch (CoreException ce) {
                        return ce.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void createLineBreakpoint(IResource resource, String typeName, int offset, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes, IDocument document, boolean bestMatch, IType type, IEditorPart editorPart) throws CoreException {
        IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)typeName, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, (Map)attributes);
        new BreakpointLocationVerifierJob(breakpoint, lineNumber, typeName, type, resource, editorPart).schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection finalSelection) {
    }

    private void removeBreakpoint(IBreakpoint breakpoint, boolean delete) throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, delete);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    protected ModuleNode getModuleNode(ITextEditor editor) throws CoreException {
        IFile file;
        IEditorInput editorInput = editor.getEditorInput();
        ICompilationUnit unit = (ICompilationUnit)editorInput.getAdapter(ICompilationUnit.class);
        if (unit == null && (file = (IFile)editorInput.getAdapter(IFile.class)) != null) {
            unit = JavaCore.createCompilationUnitFrom((IFile)file);
        }
        if (!(unit instanceof GroovyCompilationUnit)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        return ((GroovyCompilationUnit)unit).getModuleNode();
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection finalSelection) {
    }

    protected static IResource getResource(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IFile resource = (IFile)editorInput.getAdapter(IFile.class);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, true);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }
}

