/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.ui.variables.JavaStackFrameLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

class GroovyJavaStackFrameLabelProvider
extends JavaStackFrameLabelProvider
implements IPropertyChangeListener {
    private boolean isEnabled;
    private String[] filteredList;
    private IPreferenceStore preferenceStore = GroovyPlugin.getDefault().getPreferenceStore();

    public GroovyJavaStackFrameLabelProvider() {
        this.isEnabled = this.preferenceStore.getBoolean("groovy.debug.filter.stack");
        this.filteredList = this.computeFilteredList();
    }

    private String[] computeFilteredList() {
        String filter = this.preferenceStore.getString("groovy.debug.filter.list");
        if (filter != null) {
            return filter.split(",");
        }
        return new String[0];
    }

    protected void retrieveLabel(ILabelUpdate update) throws CoreException {
        IJavaStackFrame frame;
        Object element;
        super.retrieveLabel(update);
        if (this.isEnabled && !update.isCanceled() && (element = update.getElement()) instanceof IJavaStackFrame && this.isFiltered((frame = (IJavaStackFrame)element).getDeclaringTypeName())) {
            try {
                update.setForeground(new RGB(200, 200, 200), 0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    private boolean isFiltered(String qualifiedName) {
        String[] stringArray = this.filteredList;
        int n = this.filteredList.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (qualifiedName.startsWith(filter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("groovy.debug.filter.stack".equals(event.getProperty())) {
            this.isEnabled = this.preferenceStore.getBoolean("groovy.debug.filter.stack");
        } else if ("groovy.debug.filter.list".equals(event.getProperty())) {
            this.filteredList = this.computeFilteredList();
        }
    }

    void connect() {
        GroovyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    void disconnect() {
        GroovyPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

