/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.groovy.eclipse.debug.ui.ForceDetailFormatter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jface.preference.IPreferenceStore;

public class GroovyDebugOptionsEnforcer {
    private static final String[] DEFAULT_GROOVY_STEP_FILTERS = new String[]{"groovy.lang.*", "org.codehaus.groovy.*", "java.lang.reflect.*", "sun.misc.*", "groovy.ui.*", "sun.reflect.*"};
    private IPreferenceStore preferenceStore = JDIDebugUIPlugin.getDefault().getPreferenceStore();

    public void force() {
        this.forceLogicalStructure();
        this.forceStepThroughFilters();
        this.forceUseStepFilters();
        this.forceGroovyStepFilters();
        this.forceDetailFormatter();
    }

    private void forceDetailFormatter() {
        new ForceDetailFormatter().forceReferenceFormatter();
    }

    private void forceLogicalStructure() {
    }

    private void forceStepThroughFilters() {
        this.preferenceStore.setValue(IJDIPreferencesConstants.PREF_STEP_THRU_FILTERS, true);
    }

    private void forceUseStepFilters() {
        DebugPlugin.setUseStepFilters((boolean)true);
    }

    private void forceGroovyStepFilters() {
        String active = this.preferenceStore.getString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST);
        String[] activeArr = JavaDebugOptionsManager.parseList((String)active);
        ArrayList<String> activeList = new ArrayList<String>(Arrays.asList(activeArr));
        String[] stringArray = DEFAULT_GROOVY_STEP_FILTERS;
        int n = DEFAULT_GROOVY_STEP_FILTERS.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (!activeList.contains(filter)) {
                activeList.add(filter);
            }
            ++n2;
        }
        String newActive = JavaDebugOptionsManager.serializeList((String[])activeList.toArray(new String[0]));
        this.preferenceStore.setValue(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST, newActive);
        String inactive = this.preferenceStore.getString(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST);
        String[] inactiveArr = JavaDebugOptionsManager.parseList((String)inactive);
        ArrayList<String> inactiveList = new ArrayList<String>(Arrays.asList(inactiveArr));
        String[] stringArray2 = DEFAULT_GROOVY_STEP_FILTERS;
        int n3 = DEFAULT_GROOVY_STEP_FILTERS.length;
        int n4 = 0;
        while (n4 < n3) {
            String filter = stringArray2[n4];
            while (inactiveList.remove(filter)) {
            }
            ++n4;
        }
        String newInactive = JavaDebugOptionsManager.serializeList((String[])inactiveList.toArray(new String[0]));
        this.preferenceStore.setValue(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST, newInactive);
    }

    public void maybeForce(IPreferenceStore store) {
        if (store.getBoolean("groovy.debug.force_options")) {
            this.force();
            store.setValue("groovy.debug.force_options", false);
        }
    }
}

