/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.junit.ui.FailureTrace;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.Workbench;

public class EnsureJUnitFont
implements IPartListener2,
IPropertyChangeListener {
    private static final String JUNIT_RESULT_VIEW = "org.eclipse.jdt.junit.ResultView";

    public void maybeForceMonospaceFont() {
        this.forceMonospaceFont(this.isMonospace());
    }

    public void forceMonospaceFont(boolean isMonospace) {
        try {
            IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
            if (page == null) {
                return;
            }
            TestRunnerViewPart view = (TestRunnerViewPart)page.findView(JUNIT_RESULT_VIEW);
            if (view == null) {
                return;
            }
            this.internalSetMonospaceFont(isMonospace, view);
        }
        catch (Exception e) {
            GroovyCore.logException((String)("Error setting monospace font for JUnit pane to " + isMonospace), (Throwable)e);
        }
    }

    private boolean isMonospace() {
        try {
            IPreferenceStore prefs = GroovyPlugin.getDefault().getPreferenceStore();
            return prefs.getBoolean("groovy.junit.monospace.font");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void internalSetMonospaceFont(boolean isMonospace, TestRunnerViewPart view) {
        FailureTrace trace = view.getFailureTrace();
        Composite widget = (Composite)ReflectionUtils.getPrivateField(FailureTrace.class, (String)"fTable", (Object)trace);
        if (isMonospace) {
            widget.setFont(JFaceResources.getTextFont());
        } else {
            widget.setFont(JFaceResources.getDefaultFont());
        }
    }

    private void internalForceMonospaceFont(IWorkbenchPartReference partRef) {
        TestRunnerViewPart view;
        if (partRef.getId().equals(JUNIT_RESULT_VIEW) && (view = (TestRunnerViewPart)partRef.getPage().findView(JUNIT_RESULT_VIEW)) != null) {
            this.internalSetMonospaceFont(this.isMonospace(), view);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.internalForceMonospaceFont(partRef);
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        this.internalForceMonospaceFont(partRef);
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.internalForceMonospaceFont(partRef);
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.internalForceMonospaceFont(partRef);
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("groovy.junit.monospace.font") || event.getProperty().equals("org.eclipse.jface.textfont") || event.getProperty().equals("org.eclipse.jface.defaultfont")) {
            this.maybeForceMonospaceFont();
        }
    }
}

