/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.HashMap;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.debug.ui.ValidBreakpointLocationFinder;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class BreakpointLocationVerifierJob
extends Job {
    public static final Object FAMILY = new Object();
    private IJavaLineBreakpoint fBreakpoint;
    private int fLineNumber;
    private String fTypeName;
    private IType fType;
    private IResource fResource;
    private IEditorStatusLine fStatusLine;

    public BreakpointLocationVerifierJob(IJavaLineBreakpoint breakpoint, int lineNumber, String typeName, IType type, IResource resource, IEditorPart editorPart) {
        super(ActionMessages.BreakpointLocationVerifierJob_breakpoint_location);
        this.fBreakpoint = breakpoint;
        this.fLineNumber = lineNumber;
        this.fTypeName = typeName;
        this.fType = type;
        this.fResource = resource;
        this.fStatusLine = (IEditorStatusLine)editorPart.getAdapter(IEditorStatusLine.class);
    }

    public IStatus run(IProgressMonitor monitor) {
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)this.fResource));
        try {
            ValidBreakpointLocationFinder finder;
            ASTNode valid;
            ModuleNode node = null;
            if (cu instanceof GroovyCompilationUnit) {
                node = ((GroovyCompilationUnit)cu).getModuleNode();
            }
            if (node == null) {
                return new Status(2, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
            }
            if (this.fBreakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
            }
            if ((valid = (finder = new ValidBreakpointLocationFinder(this.fLineNumber)).findValidBreakpointLocation(node)) instanceof MethodNode && ((MethodNode)valid).getNameEnd() > 0) {
                this.createNewMethodBreakpoint((MethodNode)valid, this.fTypeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
            }
            if (valid != null) {
                this.createNewLineBreakpoint(valid, this.fTypeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        this.report(ActionMessages.BreakpointLocationVerifierJob_not_valid_location);
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
    }

    private void createNewMethodBreakpoint(MethodNode node, String typeName) throws CoreException {
        IJavaElement elt;
        HashMap newAttributes = new HashMap(10);
        int start = node.getNameStart();
        int end = node.getNameEnd();
        if (this.fType != null && (elt = this.fType.getTypeRoot().getElementAt(start)) != null) {
            IMethod method = (IMethod)elt;
            BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(newAttributes, (IJavaElement)this.fType, (int)start, (int)end);
            BreakpointUtils.addJavaBreakpointAttributes(newAttributes, (IJavaElement)method);
            JDIDebugModel.createMethodBreakpoint((IResource)this.fResource, (String)typeName, (String)node.getName(), (String)this.createMethodSignature(node), (boolean)true, (boolean)false, (boolean)false, (int)node.getLineNumber(), (int)start, (int)end, (int)0, (boolean)true, newAttributes);
        }
    }

    private String createMethodSignature(MethodNode node) {
        String returnType = this.createTypeSignatureStr(node.getReturnType());
        String[] parameterTypes = new String[node.getParameters().length];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = this.createTypeSignatureStr(node.getParameters()[i].getType());
            ++i;
        }
        return Signature.createMethodSignature((String[])parameterTypes, (String)returnType).replace('.', '/');
    }

    private String createTypeSignatureStr(ClassNode node) {
        String name;
        if (node == null) {
            node = VariableScope.OBJECT_CLASS_NODE;
        }
        if ((name = node.getName()).startsWith("[")) {
            return name;
        }
        return Signature.createTypeSignature((String)name, (boolean)true);
    }

    private void createNewLineBreakpoint(ASTNode node, String typeName) throws CoreException {
        if (JDIDebugModel.lineBreakpointExists((String)typeName, (int)node.getLineNumber()) != null) {
            return;
        }
        HashMap newAttributes = new HashMap(10);
        int start = node.getStart();
        int end = node.getEnd();
        if (this.fType != null) {
            BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(newAttributes, (IJavaElement)this.fType, (int)start, (int)end);
        }
        JDIDebugModel.createLineBreakpoint((IResource)this.fResource, (String)typeName, (int)node.getLineNumber(), (int)start, (int)end, (int)0, (boolean)true, newAttributes);
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (BreakpointLocationVerifierJob.this.fStatusLine != null) {
                    BreakpointLocationVerifierJob.this.fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY;
    }
}

