/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.actions;

import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveGroovyNatureAction
implements IObjectActionDelegate {
    private List<IProject> currSelected = new LinkedList<IProject>();
    private IWorkbenchPart targetPart;
    private boolean shouldAskToRemoveJars = true;

    public void run(IAction action) {
        if (this.currSelected != null && this.currSelected.size() > 0) {
            GroovyCore.trace((String)"RemoveGroovySupportAction.run()");
            for (IProject project : this.currSelected) {
                GroovyCore.trace((String)("   to " + project.getName()));
                try {
                    boolean shouldRemove;
                    GroovyRuntime.removeGroovyNature((IProject)project);
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (!GroovyRuntime.hasGroovyClasspathContainer((IJavaProject)javaProject) || !(shouldRemove = this.shouldAskToRemoveJars ? MessageDialog.openQuestion((Shell)this.getShell(), (String)"Remove Groovy jars?", (String)("Do you want to also remove the groovy runtime jars from project " + project.getName() + "?")) : true)) continue;
                    GroovyRuntime.removeGroovyClasspathContainer((IJavaProject)javaProject);
                    GroovyRuntime.removeLibraryFromClasspath((IJavaProject)javaProject, (IPath)GroovyRuntime.DSLD_CONTAINER_ID);
                }
                catch (CoreException e) {
                    GroovyCore.logException((String)"Error removing Groovy nature", (Throwable)e);
                }
            }
        }
    }

    private Shell getShell() {
        return this.targetPart != null ? this.targetPart.getSite().getShell() : Display.getDefault().getActiveShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currSelected.clear();
        LinkedList<IProject> newSelected = new LinkedList<IProject>();
        boolean enabled = true;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection newSelection = (IStructuredSelection)selection;
            for (Object object : newSelection) {
                if (object instanceof IAdaptable) {
                    IProject project = (IProject)((IAdaptable)object).getAdapter(IProject.class);
                    if (project != null) {
                        newSelected.add(project);
                        continue;
                    }
                    enabled = false;
                    break;
                }
                enabled = false;
                break;
            }
            if (action != null) {
                action.setEnabled(enabled);
            }
        }
        if (enabled) {
            this.currSelected = newSelected;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void doNotAskToRemoveJars() {
        this.shouldAskToRemoveJars = false;
    }
}

