/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.actions;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractAddClasspathContainerAction
implements IObjectActionDelegate {
    protected IJavaProject targetProject;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        try {
            if (GroovyRuntime.hasClasspathContainer((IJavaProject)this.targetProject, (IPath)this.getClasspathContainerPath())) {
                GroovyRuntime.removeLibraryFromClasspath((IJavaProject)this.targetProject, (IPath)this.getClasspathContainerPath());
            } else {
                GroovyRuntime.addLibraryToClasspath((IJavaProject)this.targetProject, (IPath)this.getClasspathContainerPath(), (boolean)this.exportClasspath());
            }
        }
        catch (CoreException e) {
            GroovyCore.logException((String)this.errorMessage(), (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.targetProject = this.getTargetProject(selection);
        if (this.targetProject == null) {
            action.setEnabled(false);
            action.setText(this.disabledText());
        } else {
            action.setEnabled(true);
            try {
                if (GroovyRuntime.hasClasspathContainer((IJavaProject)this.targetProject, (IPath)this.getClasspathContainerPath())) {
                    action.setText(this.removeText());
                } else {
                    action.setText(this.addText());
                }
            }
            catch (CoreException e) {
                GroovyCore.logException((String)this.errorMessage(), (Throwable)e);
                action.setEnabled(false);
                action.setText(this.disabledText());
            }
        }
    }

    private IJavaProject getTargetProject(ISelection selection) {
        IJavaProject candidate = null;
        if (selection instanceof IStructuredSelection) {
            IJavaProject projSelected;
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IProject) {
                IProject projSelected2 = (IProject)selected;
                if (GroovyNature.hasGroovyNature((IProject)projSelected2)) {
                    candidate = JavaCore.create((IProject)projSelected2);
                }
            } else if (selected instanceof IJavaProject && GroovyNature.hasGroovyNature((IProject)(projSelected = (IJavaProject)selected).getProject())) {
                candidate = projSelected;
            }
        }
        return candidate;
    }

    protected abstract IPath getClasspathContainerPath();

    protected abstract boolean exportClasspath();

    protected abstract String errorMessage();

    protected abstract String disabledText();

    protected abstract String addText();

    protected abstract String removeText();
}

