/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse;

import org.codehaus.groovy.eclipse.debug.ui.EnsureJUnitFont;
import org.codehaus.groovy.eclipse.debug.ui.GroovyDebugOptionsEnforcer;
import org.codehaus.groovy.eclipse.debug.ui.GroovyJavaDebugElementAdapterFactory;
import org.codehaus.groovy.eclipse.editor.GroovyOutlineTools;
import org.codehaus.groovy.eclipse.editor.GroovyTextTools;
import org.codehaus.groovy.eclipse.refactoring.actions.DelegatingCleanUpPostSaveListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GroovyPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.codehaus.groovy.eclipse.ui";
    public static final String GROOVY_TEMPLATE_CTX = "org.codehaus.groovy.eclipse.templates";
    public static final String COMPILER_MISMATCH_MARKER = "org.codehaus.groovy.eclipse.core.compilerMismatch";
    private static GroovyPlugin plugin;
    private static Boolean trace;
    private EnsureJUnitFont junitMono;
    private GroovyTextTools textTools;
    private GroovyOutlineTools outlineTools;

    public static GroovyPlugin getDefault() {
        return plugin;
    }

    public static void trace(String message) {
        if (trace == null) {
            String value = Platform.getDebugOption((String)"org.codehaus.groovy.eclipse/trace");
            trace = Boolean.valueOf(value);
        }
        if (trace == Boolean.TRUE) {
            plugin.logTraceMessage("trace: " + message);
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = GroovyPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell shell = window.getShell();
        if (shell == null) {
            shell = plugin.getWorkbench().getDisplay().getActiveShell();
        }
        return shell;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (plugin == null) {
            return null;
        }
        IWorkbench workbench = plugin.getWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    public GroovyPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.textTools = new GroovyTextTools();
        this.outlineTools = new GroovyOutlineTools();
        this.addMonospaceFontListener();
        DelegatingCleanUpPostSaveListener.installCleanUp();
        GroovyJavaDebugElementAdapterFactory.connect();
        if (this.getPreferenceStore().getBoolean("groovy.debug.force_options")) {
            new GroovyDebugOptionsEnforcer().maybeForce(this.getPreferenceStore());
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.textTools.dispose();
        this.textTools = null;
        this.outlineTools.dispose();
        this.outlineTools = null;
        DelegatingCleanUpPostSaveListener.uninstallCleanUp();
        this.removeMonospaceFontListener();
    }

    private void addMonospaceFontListener() {
        this.junitMono = new EnsureJUnitFont();
        try {
            if (PlatformUI.isWorkbenchRunning()) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.addPartListener((IPartListener2)this.junitMono);
            }
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.junitMono);
            PrefUtil.getInternalPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.junitMono);
        }
        catch (Exception e) {
            this.logException("Error installing JUnit monospace font listener", e);
        }
    }

    private void removeMonospaceFontListener() {
        try {
            try {
                IWorkbench workbench = this.getWorkbench();
                if (!workbench.isClosing()) {
                    IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                    page.removePartListener((IPartListener2)this.junitMono);
                }
            }
            catch (Throwable throwable) {
                PrefUtil.getInternalPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
                this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
                this.junitMono = null;
            }
        }
        finally {
            PrefUtil.getInternalPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
            this.junitMono = null;
        }
    }

    public GroovyTextTools getTextTools() {
        return this.textTools;
    }

    public GroovyOutlineTools getOutlineTools() {
        return this.outlineTools;
    }

    public void logException(String message, Exception exception) {
        this.log(4, message, exception);
    }

    public void logWarning(String message) {
        this.log(2, message, null);
    }

    public void logTraceMessage(String message) {
        this.log(1, message, null);
    }

    private void log(int severity, String message, Exception exception) {
        Status status = new Status(severity, this.getBundle().getSymbolicName(), 0, message, (Throwable)exception);
        this.getLog().log((IStatus)status);
    }
}

