/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.kobiton.preferences;

import com.kms.katalon.integration.kobiton.entity.KobitonApiKey;
import com.kms.katalon.integration.kobiton.entity.KobitonLoginInfo;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class KobitonPreferencesProvider {
    private static ScopedPreferenceStore getPreferencetStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.integration.kobiton");
    }

    public static boolean isKobitonIntegrationEnabled() {
        return KobitonPreferencesProvider.getPreferencetStore().getBoolean("kobiton.integration.enable");
    }

    public static String getKobitonUserName() {
        return KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.authentication.username");
    }

    public static void saveKobitonUserName(String userName) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return;
        }
        KobitonPreferencesProvider.getPreferencetStore().setValue("kobiton.authentication.username", userName);
    }

    public static String getKobitonPassword() {
        return KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.authentication.password");
    }

    public static void saveKobitonPassword(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return;
        }
        KobitonPreferencesProvider.getPreferencetStore().setValue("kobiton.authentication.password", password);
    }

    public static String getKobitonToken() {
        String kobitonToken = KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.authentication.token");
        if (StringUtils.isEmpty((CharSequence)kobitonToken)) {
            try {
                KobitonLoginInfo loginInfo = KobitonApiProvider.login(KobitonPreferencesProvider.getKobitonUserName(), KobitonPreferencesProvider.getKobitonPassword());
                kobitonToken = loginInfo.getToken();
                KobitonPreferencesProvider.saveKobitonToken(loginInfo.getToken());
                List<KobitonApiKey> apiKeys = KobitonApiProvider.getApiKeyList(loginInfo.getToken());
                if (!apiKeys.isEmpty()) {
                    KobitonPreferencesProvider.saveKobitonApiKey(apiKeys.get(0).getKey());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Authentication kobiton system failed !", e);
            }
        }
        return kobitonToken;
    }

    public static void saveKobitonToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return;
        }
        KobitonPreferencesProvider.getPreferencetStore().setValue("kobiton.authentication.token", token);
    }

    public static String getKobitonApiKey() {
        return KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.apiKey");
    }

    public static void saveKobitonApiKey(String apiKey) {
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            return;
        }
        KobitonPreferencesProvider.getPreferencetStore().setValue("kobiton.apiKey", apiKey);
    }
}

