/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.kobiton.driver;

import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.integration.kobiton.constants.IntegrationKobitonMessages;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import java.io.IOException;
import java.util.Map;

public class KobitonDriverConnector
extends RemoteWebDriverConnector {
    private KobitonDevice kobitonDevice;
    private String apiKey;
    private String userName;

    public KobitonDriverConnector(String projectDir) throws IOException {
        super(projectDir);
        this.remoteWebDriverConnectorType = RemoteWebDriverConnector.RemoteWebDriverConnectorType.Appium;
    }

    public String getRemoteServerUrl() {
        if (this.apiKey == null || this.userName == null || this.kobitonDevice == null) {
            throw new IllegalArgumentException(IntegrationKobitonMessages.MSG_ERR_MISSING_EXECUTION_INFO);
        }
        return this.buildKobitonUrl();
    }

    private String buildKobitonUrl() {
        return "http://" + this.userName + ":" + this.apiKey + "@" + "api.kobiton.com" + "/wd/hub";
    }

    public DriverType getDriverType() {
        return WebUIDriverType.KOBITON_WEB_DRIVER;
    }

    public KobitonDevice getKobitonDevice() {
        return this.kobitonDevice;
    }

    public void setKobitonDevice(KobitonDevice kobitonDevice) {
        this.kobitonDevice = kobitonDevice;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Map<String, Object> getUserConfigProperties() {
        Map configProperties = super.getUserConfigProperties();
        configProperties.putAll(this.kobitonDevice.toDesireCapabilitiesMap());
        return configProperties;
    }

    public Map<String, Object> getSystemProperties() {
        Map systemProperties = super.getSystemProperties();
        systemProperties.putAll(this.kobitonDevice.getSystemPropertiesMap());
        return systemProperties;
    }
}

