/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.kobiton.configuration;

import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.webui.configuration.contributor.WebUIRunConfigurationContributor;
import com.kms.katalon.integration.kobiton.configuration.KobitonRunConfiguration;
import com.kms.katalon.integration.kobiton.constants.IntegrationKobitonMessages;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class KobitonRunConfigurationContributor
extends WebUIRunConfigurationContributor {
    private static final int PREFERRED_ORDER = 8;
    private KobitonDevice selectedDevice;

    public String getId() {
        return WebUIDriverType.KOBITON_WEB_DRIVER.toString();
    }

    public IRunConfiguration getRunConfiguration(String projectDir) throws IOException, ExecutionException {
        if (this.selectedDevice != null) {
            return this.getKobitonConfiguration(projectDir, this.selectedDevice);
        }
        return new KobitonRunConfiguration(projectDir);
    }

    public IRunConfiguration getRunConfiguration(String projectDir, RunConfigurationDescription runConfigurationDescription) throws IOException, ExecutionException, InterruptedException {
        KobitonDevice device = (KobitonDevice)JsonUtil.fromJson((String)((String)runConfigurationDescription.getRunConfigurationData().get("kobitonDevice")), KobitonDevice.class);
        return this.getKobitonConfiguration(projectDir, device);
    }

    private IRunConfiguration getKobitonConfiguration(String projectDir, KobitonDevice device) throws IOException {
        KobitonRunConfiguration runConfiguration = new KobitonRunConfiguration(projectDir);
        runConfiguration.setKobitonDevice(device);
        runConfiguration.setApiKey(KobitonPreferencesProvider.getKobitonApiKey());
        runConfiguration.setUserName(KobitonPreferencesProvider.getKobitonUserName());
        runConfiguration.setKobitonDevice(device);
        return runConfiguration;
    }

    public int getPreferredOrder() {
        return 8;
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        return Arrays.asList(this.getKobitonDeviceIdConsoleOpt(""));
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        int kobitonDeviceId = Integer.valueOf(argumentValue);
        List<KobitonDevice> availableDevices = KobitonApiProvider.getKobitonFavoriteDevices(KobitonPreferencesProvider.getKobitonToken());
        Optional<KobitonDevice> selectedDeviceOpt = availableDevices.stream().filter(device -> device.getId() == kobitonDeviceId).findAny();
        if (!selectedDeviceOpt.isPresent()) {
            throw new ExecutionException(MessageFormat.format(IntegrationKobitonMessages.MSG_ERR_KOBITON_DEVICE_NOT_FOUND, kobitonDeviceId));
        }
        this.selectedDevice = selectedDeviceOpt.get();
    }

    public List<ConsoleOption<?>> getConsoleOptions(RunConfigurationDescription description) {
        KobitonDevice device = (KobitonDevice)JsonUtil.fromJson((String)((String)description.getRunConfigurationData().get("kobitonDevice")), KobitonDevice.class);
        return Arrays.asList(this.getKobitonDeviceIdConsoleOpt(Integer.toString(device.getId())));
    }

    private ConsoleOption<?> getKobitonDeviceIdConsoleOpt(final String rawValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return "kobitonDeviceId";
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return rawValue;
            }
        };
    }
}

