/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.keyword.internal;

import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.TestObjectProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SelectorBuilderHelper {
    public static String buildXpathFromProperties(List<TestObjectProperty> properties) {
        Map<String, String> binding = SelectorBuilderHelper.buildLocator(properties);
        return binding.containsKey("xpath") ? binding.get("xpath") : "";
    }

    public static List<TestObjectProperty> escapeSpecialProperties(List<TestObjectProperty> properties) {
        ArrayList<TestObjectProperty> specialProperties = new ArrayList<TestObjectProperty>();
        for (TestObjectProperty property : properties) {
            if (!property.getCondition().equals((Object)ConditionType.EXPRESSION)) continue;
            specialProperties.add(property);
            properties.remove(property);
        }
        return specialProperties;
    }

    private static Map<String, String> buildLocator(List<TestObjectProperty> propEntities) {
        HashMap<String, String> binding = new HashMap<String, String>();
        StringBuilder exp = new StringBuilder();
        String tagName = "";
        int i = 0;
        while (i < propEntities.size()) {
            TestObjectProperty prop = propEntities.get(i);
            String propName = prop.getName();
            String propVal = prop.getValue();
            String mCondition = prop.getCondition().toString();
            if (propName.equals("id") || propName.equals("name")) {
                if (propEntities.size() == 1 && mCondition.equals(ConditionType.EQUALS.toString())) {
                    binding.put(propName, propVal);
                    break;
                }
            } else if (propName.equals("xpath") || propName.equals("css") || propName.equals("cssSelector")) {
                binding.put(propName, propVal);
                break;
            }
            if (!propName.equalsIgnoreCase("ref_element") && !propName.equalsIgnoreCase("parent_frame")) {
                if (propName.equalsIgnoreCase("tagName") || propName.equalsIgnoreCase("tag") || propName.equalsIgnoreCase("type")) {
                    tagName = propVal;
                } else {
                    if (!exp.toString().isEmpty()) {
                        exp.append(" and ");
                    }
                    if (propName.equals("text") || propName.equals("link_text")) {
                        propName = "text()";
                    }
                    if (!propName.endsWith("()")) {
                        propName = "@" + propName;
                    }
                    if (mCondition.equals(ConditionType.EQUALS.toString())) {
                        exp.append(String.format("%s = '%s'", propName, propVal));
                    } else if (mCondition.equals(ConditionType.NOT_EQUAL.toString())) {
                        exp.append(String.format("%s != '%s'", propName, propVal));
                    } else if (mCondition.equals(ConditionType.CONTAINS.toString())) {
                        exp.append(String.format("contains(%s,'%s')", propName, propVal));
                    } else if (mCondition.equals(ConditionType.NOT_CONTAIN.toString())) {
                        exp.append(String.format("not(contains(%s,'%s'))", propName, propVal));
                    } else if (mCondition.equals(ConditionType.STARTS_WITH.toString())) {
                        exp.append(String.format("starts-with(%s,'%s')", propName, propVal));
                    }
                }
            }
            ++i;
        }
        if (!(binding.containsKey("name") || binding.containsKey("id") || binding.containsKey("xpath") || binding.containsKey("css") || binding.containsKey("cssSelector") || exp.toString().equals(""))) {
            StringBuilder xpath = new StringBuilder();
            xpath.append("//");
            xpath.append(tagName.equals("") ? "*" : tagName);
            xpath.append("[" + exp + "]");
            binding.put("xpath", xpath.toString());
        } else if (tagName != null && !tagName.equals("")) {
            binding.put("xpath", "//" + tagName);
        }
        return binding;
    }

    public static String makeXpath(List<TestObjectProperty> propEntities) {
        StringBuilder exp = new StringBuilder();
        String tagName = "";
        int i = 0;
        while (i < propEntities.size()) {
            TestObjectProperty prop = propEntities.get(i);
            String propName = prop.getName();
            String propVal = prop.getValue();
            String mCondition = prop.getCondition().toString();
            if ("xpath".equals(propName)) {
                return propVal;
            }
            if (!"ref_element".equalsIgnoreCase(propName) && !"parent_frame".equalsIgnoreCase(propName)) {
                if ("tagName".equalsIgnoreCase(propName) || "tag".equalsIgnoreCase(propName) || "type".equalsIgnoreCase(propName)) {
                    tagName = propVal;
                } else {
                    if (!StringUtils.isEmpty((String)exp.toString())) {
                        exp.append(" and ");
                    }
                    if ("text".equals(propName) || "link_text".equals(propName)) {
                        propName = "text()";
                    }
                    if (!StringUtils.endsWith((String)propName, (String)"()")) {
                        propName = "@" + propName;
                    }
                    if (mCondition.equals(ConditionType.EQUALS.toString())) {
                        exp.append(String.format("%s = '%s'", propName, propVal));
                    } else if (mCondition.equals(ConditionType.NOT_EQUAL.toString())) {
                        exp.append(String.format("%s != '%s'", propName, propVal));
                    } else if (mCondition.equals(ConditionType.CONTAINS.toString())) {
                        exp.append(String.format("contains(%s,'%s')", propName, propVal));
                    } else if (mCondition.equals(ConditionType.NOT_CONTAIN.toString())) {
                        exp.append(String.format("not(contains(%s,'%s'))", propName, propVal));
                    } else if (mCondition.equals(ConditionType.STARTS_WITH.toString())) {
                        exp.append(String.format("starts-with(%s,'%s')", propName, propVal));
                    }
                }
            }
            ++i;
        }
        if (!StringUtils.isEmpty((String)exp.toString())) {
            StringBuilder xpath = new StringBuilder();
            xpath.append("//");
            xpath.append(StringUtils.isEmpty((String)tagName) ? "*" : tagName);
            xpath.append("[" + exp + "]");
            return xpath.toString();
        }
        if (StringUtils.isNotBlank((String)tagName)) {
            return "//" + tagName;
        }
        return "";
    }
}

