/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.keyword.internal;

import com.google.common.base.Preconditions;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.appium.exception.AppiumStartException;
import com.kms.katalon.core.appium.exception.IOSWebkitStartException;
import com.kms.katalon.core.appium.exception.MobileDriverInitializeException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.driver.ExistingDriverType;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.CoreMobileMessageConstants;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import io.appium.java_client.AppiumDriver;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;

public class MobileDriverFactory {
    private static final KeywordLogger logger = KeywordLogger.getInstance(MobileDriverFactory.class);
    private static final String WAIT_FOR_APP_SCRIPT_TRUE = "true;";
    private static final String WAIT_FOR_APP_SCRIPT = "waitForAppScript";
    private static final String NO_RESET = "noReset";
    private static final String FULL_RESET = "fullReset";
    public static final String MOBILE_DRIVER_PROPERTY = "Mobile";
    public static final String EXISTING_DRIVER_PROPERTY = "Existing";

    public static void cleanup() throws InterruptedException, IOException {
        AppiumDriverManager.cleanup();
    }

    public static MobileDriverType getMobileDriverType() {
        String mobileDriverType = RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"devicePlatform");
        return mobileDriverType != null ? MobileDriverType.valueOf(mobileDriverType) : null;
    }

    public static String getRemoteWebDriverServerUrl() {
        return RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"remoteWebDriverUrl");
    }

    public static String getRemoteWebDriverType() {
        return RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"browserType");
    }

    public static String getDevicePlatform() {
        return MobileDriverFactory.getMobileDriverType().toString();
    }

    public static String getDeviceId() {
        return AppiumDriverManager.getDeviceId((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceName() {
        return AppiumDriverManager.getDeviceName((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceModel() {
        return AppiumDriverManager.getDeviceModel((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceManufacturer() {
        return AppiumDriverManager.getDeviceManufacturer((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceOSVersion() {
        return AppiumDriverManager.getDeviceOSVersion((String)MOBILE_DRIVER_PROPERTY);
    }

    public static String getDeviceOS() {
        return AppiumDriverManager.getDeviceOS((String)MOBILE_DRIVER_PROPERTY);
    }

    public static AppiumDriver<?> getDriver() throws StepFailedException {
        try {
            AppiumDriver driver = AppiumDriverManager.getDriver();
            return driver;
        }
        catch (StepFailedException e) {
            if (MobileDriverFactory.isUsingExistingDriver()) {
                try {
                    return MobileDriverFactory.startExistingBrowser();
                }
                catch (MobileDriverInitializeException | MalformedURLException throwable) {}
            }
            throw e;
        }
    }

    public static void closeDriver() {
        AppiumDriverManager.closeDriver();
    }

    private static DesiredCapabilities convertPropertiesMaptoDesireCapabilities(Map<String, Object> propertyMap, MobileDriverType mobileDriverType) {
        DesiredCapabilities desireCapabilities = new DesiredCapabilities();
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_MOBILE_PROPERTY_SETTING, property.getKey(), property.getValue()));
            desireCapabilities.setCapability(property.getKey(), property.getValue());
        }
        return desireCapabilities;
    }

    private static DesiredCapabilities createCapabilities(MobileDriverType osType, String deviceId, String deviceName, String appFile, boolean uninstallAfterCloseApp) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        Map driverPreferences = RunConfiguration.getDriverPreferencesProperties((String)MOBILE_DRIVER_PROPERTY);
        if (driverPreferences.containsKey("browserName")) {
            driverPreferences.remove("browserName");
        }
        if (driverPreferences != null && osType == MobileDriverType.IOS_DRIVER) {
            capabilities.merge((Capabilities)MobileDriverFactory.convertPropertiesMaptoDesireCapabilities(driverPreferences, MobileDriverType.IOS_DRIVER));
            capabilities.setCapability(WAIT_FOR_APP_SCRIPT, WAIT_FOR_APP_SCRIPT_TRUE);
            try {
                if (AppiumDriverManager.getXCodeVersion() >= 8) {
                    capabilities.setCapability("automationName", "XCUITest");
                    capabilities.setCapability("realDeviceLogger", RunConfiguration.getDeviceConsoleExecutable());
                    capabilities.setCapability("wdaLocalPort", (Object)AppiumDriverManager.getFreePort());
                }
            }
            catch (ExecutionException executionException) {}
            if (deviceId == null) {
                capabilities.setCapability("platform", MobileDriverFactory.getDeviceOS());
                capabilities.setCapability("platformVersion", MobileDriverFactory.getDeviceOSVersion());
            }
        } else if (driverPreferences != null && osType == MobileDriverType.ANDROID_DRIVER) {
            capabilities.setCapability("autoGrantPermissions", true);
            capabilities.merge((Capabilities)MobileDriverFactory.convertPropertiesMaptoDesireCapabilities(driverPreferences, MobileDriverType.ANDROID_DRIVER));
            capabilities.setPlatform(Platform.ANDROID);
            capabilities.setCapability("autoGrantPermissions", true);
            if (MobileDriverFactory.isUsingAndroid7OrBigger()) {
                capabilities.setCapability("automationName", "uiautomator2");
            }
        }
        capabilities.setCapability("deviceName", deviceName);
        capabilities.setCapability("app", appFile);
        if (deviceId != null) {
            capabilities.setCapability("udid", deviceId);
        }
        capabilities.setCapability(FULL_RESET, uninstallAfterCloseApp);
        capabilities.setCapability(NO_RESET, !uninstallAfterCloseApp);
        capabilities.setCapability("newCommandTimeout", (Object)1800);
        return capabilities;
    }

    public static boolean isUsingAndroid7OrBigger() {
        String[] splitParts;
        block5: {
            String osVersion;
            block4: {
                try {
                    osVersion = MobileDriverFactory.getDeviceOSVersion();
                    if (!StringUtils.isEmpty((CharSequence)osVersion)) break block4;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            splitParts = osVersion.split("\\.");
            if (splitParts != null && splitParts.length != 0) break block5;
            return false;
        }
        String osVersionMajor = splitParts[0];
        Number androidVersion = NumberUtils.createNumber((String)osVersionMajor);
        return androidVersion.intValue() >= 7;
    }

    private static boolean isUsingExistingDriver() {
        return MobileDriverFactory.getExistingDriver() != null;
    }

    public static AppiumDriver<?> startMobileDriver(String appFile, boolean uninstallAfterCloseApp) throws AppiumStartException, IOException, InterruptedException, MobileDriverInitializeException, IOSWebkitStartException {
        if (MobileDriverFactory.isUsingExistingDriver()) {
            return MobileDriverFactory.startExistingBrowser();
        }
        AppiumDriver<?> driver = MobileDriverFactory.startMobileDriver(MobileDriverFactory.getMobileDriverType(), MobileDriverFactory.getDeviceId(), MobileDriverFactory.getDeviceName(), appFile, uninstallAfterCloseApp);
        MobileDriverFactory.saveWebDriverSessionData(driver);
        return driver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveWebDriverSessionData(AppiumDriver<?> remoteWebDriver) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                Socket myClient = new Socket(RunConfiguration.getSessionServerHost(), RunConfiguration.getSessionServerPort());
                try {
                    try (PrintStream output = new PrintStream(myClient.getOutputStream());){
                        output.println(remoteWebDriver.getSessionId());
                        output.println(MobileDriverFactory.getWebDriverServerUrl(remoteWebDriver));
                        output.println(MobileDriverFactory.getMobileDriverType().toString());
                        output.println(RunConfiguration.getLogFolderPath());
                        DriverType executedDriver = MobileDriverFactory.getExecutedDriver();
                        if (MobileDriverFactory.getRemoteWebDriverServerUrl() != null) {
                            output.println(MobileDriverFactory.getRemoteWebDriverType());
                            output.println(String.valueOf(MobileDriverFactory.getDeviceName()) + " " + MobileDriverFactory.getDeviceOSVersion());
                        } else {
                            output.println("");
                            if (executedDriver == MobileDriverType.ANDROID_DRIVER) {
                                output.println(String.valueOf(MobileDriverFactory.getDeviceManufacturer()) + " " + MobileDriverFactory.getDeviceModel() + " " + MobileDriverFactory.getDeviceOSVersion());
                            } else if (executedDriver == MobileDriverType.IOS_DRIVER) {
                                output.println(String.valueOf(MobileDriverFactory.getDeviceName()) + " " + MobileDriverFactory.getDeviceOSVersion());
                            }
                        }
                        output.flush();
                    }
                    if (myClient == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (myClient == null) throw throwable;
                    myClient.close();
                    throw throwable;
                }
                myClient.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    public static DriverType getExecutedDriver() {
        ExistingDriverType existingDriver = MobileDriverFactory.getExistingDriver();
        return existingDriver != null ? existingDriver : MobileDriverFactory.getMobileDriverType();
    }

    private static ExistingDriverType getExistingDriver() {
        if (RunConfiguration.getDriverSystemProperties((String)EXISTING_DRIVER_PROPERTY) != null) {
            return new ExistingDriverType("");
        }
        return null;
    }

    private static String getWebDriverServerUrl(AppiumDriver<?> remoteWebDriver) {
        return ((HttpCommandExecutor)remoteWebDriver.getCommandExecutor()).getAddressOfRemoteServer().toString();
    }

    protected static AppiumDriver<?> startExistingBrowser() throws MalformedURLException, MobileDriverInitializeException {
        return AppiumDriverManager.startExisitingMobileDriver((DriverType)MobileDriverType.fromStringValue(RunConfiguration.getExisingSessionDriverType()), (String)RunConfiguration.getExisingSessionSessionId(), (String)RunConfiguration.getExisingSessionServerUrl());
    }

    public static AppiumDriver<?> startMobileDriver(MobileDriverType osType, String deviceId, String deviceName, String appFile, boolean uninstallAfterCloseApp) throws MobileDriverInitializeException, IOException, InterruptedException, AppiumStartException {
        Preconditions.checkArgument((osType != null && StringUtils.isNotEmpty((CharSequence)deviceName) ? 1 : 0) != 0, (Object)CoreMobileMessageConstants.KW_MSG_DEVICE_MISSING);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appFile), (Object)CoreMobileMessageConstants.KW_MSG_APP_FILE_MISSING);
        String remoteWebUrl = MobileDriverFactory.getRemoteWebDriverServerUrl();
        if (StringUtils.isNotEmpty((CharSequence)remoteWebUrl)) {
            return AppiumDriverManager.createMobileDriver((DriverType)osType, (DesiredCapabilities)MobileDriverFactory.createCapabilities(osType, deviceId, deviceName, appFile, uninstallAfterCloseApp), (URL)new URL(remoteWebUrl));
        }
        return AppiumDriverManager.createMobileDriver((DriverType)osType, (String)deviceId, (DesiredCapabilities)MobileDriverFactory.createCapabilities(osType, deviceId, deviceName, appFile, uninstallAfterCloseApp));
    }
}

