/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.support;

import com.kms.katalon.composer.objectrepository.part.TestObjectPart;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class PropertyNameEditingSupport
extends EditingSupport {
    private TableViewer viewer;
    private IEventBroker eventBroker;
    private TestObjectPart testObjectPart;

    public PropertyNameEditingSupport(TableViewer viewer, IEventBroker eventBroker, TestObjectPart testObjectPart) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.eventBroker = eventBroker;
        this.testObjectPart = testObjectPart;
    }

    protected CellEditor getCellEditor(Object element) {
        return new CustomTextCellEditor((Composite)this.viewer.getTable());
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof WebElementPropertyEntity) {
            WebElementPropertyEntity property = (WebElementPropertyEntity)element;
            return property.getName();
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof WebElementPropertyEntity && value instanceof String) {
            this.testObjectPart.executeOperation((IUndoableOperation)new PropertyNameChangeOperation((WebElementPropertyEntity)element, (String)value));
        }
    }

    private class CustomTextCellEditor
    extends TextCellEditor {
        public CustomTextCellEditor(Composite parent) {
            super(parent);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData result = super.getLayoutData();
            result.minimumHeight = PropertyNameEditingSupport.this.viewer.getTable().getItemHeight();
            return result;
        }
    }

    public class PropertyNameChangeOperation
    extends AbstractOperation {
        private WebElementPropertyEntity property;
        private String value;
        private String oldValue;

        public PropertyNameChangeOperation(WebElementPropertyEntity property, String value) {
            super(PropertyNameChangeOperation.class.getName());
            this.property = property;
            this.oldValue = property.getName();
            this.value = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.value.equals("") || this.value.equals(this.oldValue)) {
                return Status.CANCEL_STATUS;
            }
            return this.doSetItemValue(this.value);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.value);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.oldValue);
        }

        protected IStatus doSetItemValue(String itemValue) {
            this.property.setName(itemValue);
            PropertyNameEditingSupport.this.viewer.update((Object)this.property, null);
            PropertyNameEditingSupport.this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)PropertyNameEditingSupport.this.viewer);
            return Status.OK_STATUS;
        }
    }
}

