/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.objectrepository.constant.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.repository.WebElementEntity;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameTestObjectHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof WebElementTreeEntity) {
                    RenameTestObjectHandler.this.execute((WebElementTreeEntity)object);
                }
            }
        });
    }

    private void execute(WebElementTreeEntity webElementTreeEntity) {
        block5: {
            try {
                if (!(webElementTreeEntity.getObject() instanceof WebElementEntity)) break block5;
                WebElementEntity webElement = (WebElementEntity)webElementTreeEntity.getObject();
                List existingNames = FolderController.getInstance().getChildrenNames(webElement.getParentFolder());
                RenameWizard renameWizard = new RenameWizard((ITreeEntity)webElementTreeEntity, existingNames);
                CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
                int code = wizardDialog.open();
                if (code != 0) break block5;
                String oldName = webElement.getName();
                String pk = webElement.getId();
                String oldIdForDisplay = webElement.getIdForDisplay();
                try {
                    if (renameWizard.getNewNameValue() != null && !renameWizard.getNewNameValue().isEmpty() && !renameWizard.getNewNameValue().equals(oldName)) {
                        webElement.setName(renameWizard.getNewNameValue());
                        ObjectRepositoryController.getInstance().updateTestObject(webElement);
                        String newIdForDisplay = webElement.getIdForDisplay();
                        this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, newIdForDisplay});
                    }
                    this.partService.saveAll(false);
                }
                catch (Exception ex) {
                    webElement.setName(oldName);
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_TEST_OBJECT);
                    return;
                }
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)webElementTreeEntity.getParent());
                this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new Object[]{pk, webElement});
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)webElementTreeEntity);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }
}

